/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.interaction;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.ProfessionsMCA;
import fabric.net.mca.advancement.criterion.CriterionMCA;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.Chore;
import fabric.net.mca.entity.ai.Memories;
import fabric.net.mca.entity.ai.MoveState;
import fabric.net.mca.entity.ai.relationship.RelationshipState;
import fabric.net.mca.entity.interaction.EntityCommandHandler;
import fabric.net.mca.item.ItemsMCA;
import fabric.net.mca.mixin.MixinVillagerEntityInvoker;
import fabric.net.mca.server.world.data.FamilyTree;
import fabric.net.mca.server.world.data.FamilyTreeNode;
import fabric.net.mca.server.world.data.PlayerSaveData;
import fabric.net.mca.util.WorldUtils;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_3908;
import net.minecraft.class_5146;
import net.minecraft.class_5535;
import net.minecraft.class_5819;

public class VillagerCommandHandler
extends EntityCommandHandler<VillagerEntityMCA> {
    public VillagerCommandHandler(VillagerEntityMCA entity) {
        super(entity);
    }

    @Override
    public boolean handle(class_3222 player, String command) {
        Memories memory = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((class_1657)player);
        if (MoveState.byCommand(command).filter(state -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().setMoveState((MoveState)((Object)state), (class_1657)player);
            return true;
        }).isPresent()) {
            return true;
        }
        if (Chore.byCommand(command).filter(chore -> {
            ((VillagerEntityMCA)this.entity).getVillagerBrain().assignJob((Chore)((Object)chore), (class_1657)player);
            CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "chores");
            ((VillagerEntityMCA)this.entity).sendChatMessage(class_2561.method_43471((String)"chore.success"), (class_1297)player);
            return true;
        }).isPresent()) {
            return true;
        }
        String arg = "";
        String[] split = command.split("\\.");
        if (split.length > 1) {
            command = split[0];
            arg = split[1];
        }
        switch (command) {
            case "pick_up": {
                if (player.method_5685().size() >= 3) {
                    ((class_1297)player.method_5685().get(0)).method_5848();
                }
                if (((VillagerEntityMCA)this.entity).method_5765()) {
                    ((VillagerEntityMCA)this.entity).method_5848();
                } else {
                    ((VillagerEntityMCA)this.entity).method_5873((class_1297)player, true);
                }
                player.field_13987.method_14364((class_2596)new class_2752((class_1297)player));
                return false;
            }
            case "ridehorse": {
                if (((VillagerEntityMCA)this.entity).method_5765()) {
                    ((VillagerEntityMCA)this.entity).method_5848();
                } else {
                    ((VillagerEntityMCA)this.entity).method_37908().method_8333((class_1297)player, player.method_5829().method_1014(10.0), e -> e instanceof class_5146 && ((class_5146)e).method_6725()).stream().filter(horse -> !horse.method_5782()).min(Comparator.comparingDouble(a -> a.method_5858(this.entity))).ifPresentOrElse(horse -> {
                        ((VillagerEntityMCA)this.entity).method_5873((class_1297)horse, false);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "interaction.ridehorse.success", new Object[0]);
                    }, () -> ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "interaction.ridehorse.fail.notnearby", new Object[0]));
                }
                return true;
            }
            case "sethome": {
                ((VillagerEntityMCA)this.entity).getResidency().setHome(player);
                return true;
            }
            case "gohome": {
                ((VillagerEntityMCA)this.entity).getResidency().goHome((class_1657)player);
                this.stopInteracting();
                return false;
            }
            case "setworkplace": {
                ((VillagerEntityMCA)this.entity).getResidency().setWorkplace(player);
                return true;
            }
            case "trade": {
                ((VillagerEntityMCA)this.entity).getInteractions().stopInteracting();
                MixinVillagerEntityInvoker invoker = (MixinVillagerEntityInvoker)this.entity;
                invoker.invokeBeginTradeWith((class_1657)player);
                return false;
            }
            case "inventory": {
                player.method_17355((class_3908)this.entity);
                return false;
            }
            case "gift": {
                ((VillagerEntityMCA)this.entity).getRelationships().giveGift(player, memory);
                return true;
            }
            case "adopt": {
                ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "interaction.adopt.success", new Object[0]);
                FamilyTreeNode parentNode = FamilyTree.get((class_3218)player.method_37908()).getOrCreate((class_1297)player);
                ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent(parentNode);
                Optional<FamilyTreeNode> parentSpouse = FamilyTree.get((class_3218)player.method_37908()).getOrEmpty(parentNode.partner());
                parentSpouse.ifPresent(p -> ((VillagerEntityMCA)this.entity).getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)p));
                break;
            }
            case "procreate": {
                if (memory.getHearts() < 100) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "interaction.procreate.fail.lowhearts", new Object[0]);
                } else if (((VillagerEntityMCA)this.entity).getRelationships().mayProcreateAgain(player.method_37908().method_8510())) {
                    ((VillagerEntityMCA)this.entity).getRelationships().startProcreating(player.method_37908().method_8510());
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "interaction.procreate.fail.toosoon", new Object[0]);
                }
                return true;
            }
            case "divorcePapers": {
                player.method_31548().method_7394(new class_1799((class_1935)ItemsMCA.DIVORCE_PAPERS.get()));
                return true;
            }
            case "divorceConfirm": {
                class_1799 papers = ((class_1792)ItemsMCA.DIVORCE_PAPERS.get()).method_7854();
                Memories memories = ((VillagerEntityMCA)this.entity).getVillagerBrain().getMemoriesForPlayer((class_1657)player);
                if (player.method_31548().method_7379(papers)) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "divorcePaper", new Object[0]);
                    player.method_31548().method_7378(papers);
                    memories.modHearts(-20);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "divorce", new Object[0]);
                    memories.modHearts(-200);
                }
                ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue(-5);
                ((VillagerEntityMCA)this.entity).getRelationships().endRelationShip(RelationshipState.SINGLE);
                PlayerSaveData playerData = PlayerSaveData.get(player);
                playerData.endRelationShip(RelationshipState.SINGLE);
                return true;
            }
            case "execute": {
                ((VillagerEntityMCA)this.entity).setProfession((class_3852)ProfessionsMCA.OUTLAW.get());
                return true;
            }
            case "pardon": {
                ((VillagerEntityMCA)this.entity).setProfession(class_3852.field_17051);
                return true;
            }
            case "stay_in_village": {
                ((VillagerEntityMCA)this.entity).setProfession(class_3852.field_17051);
                ((VillagerEntityMCA)this.entity).setDespawnDelay(0);
                return true;
            }
            case "hire_short": {
                this.payEmeralds(player, 5);
                ((VillagerEntityMCA)this.entity).makeMercenary();
                ((VillagerEntityMCA)this.entity).setDespawnDelay(72000);
                return true;
            }
            case "hire_long": {
                this.payEmeralds(player, 10);
                ((VillagerEntityMCA)this.entity).makeMercenary();
                ((VillagerEntityMCA)this.entity).setDespawnDelay(168000);
                return true;
            }
            case "infected": {
                ((VillagerEntityMCA)this.entity).setInfected(!((VillagerEntityMCA)this.entity).isInfected());
                return true;
            }
            case "stopworking": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().abandonJob();
                return true;
            }
            case "armor": {
                ((VillagerEntityMCA)this.entity).getVillagerBrain().setArmorWear(!((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear());
                if (((VillagerEntityMCA)this.entity).getVillagerBrain().getArmorWear()) {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "armor.enabled", new Object[0]);
                } else {
                    ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "armor.disabled", new Object[0]);
                }
                return true;
            }
            case "profession": {
                switch (arg) {
                    case "none": {
                        ((VillagerEntityMCA)this.entity).setProfession(class_3852.field_17051);
                        ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "profession.set.none", new Object[0]);
                        break;
                    }
                    case "guard": {
                        ((VillagerEntityMCA)this.entity).setProfession((class_3852)ProfessionsMCA.GUARD.get());
                        ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "profession.set.guard", new Object[0]);
                        break;
                    }
                    case "archer": {
                        ((VillagerEntityMCA)this.entity).setProfession((class_3852)ProfessionsMCA.ARCHER.get());
                        ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "profession.set.archer", new Object[0]);
                    }
                }
                return true;
            }
            case "apologize": {
                class_243 pos = ((VillagerEntityMCA)this.entity).method_19538();
                ((VillagerEntityMCA)this.entity).method_37908().method_18467(VillagerEntityMCA.class, new class_238(pos, pos).method_1014(32.0)).forEach(v -> {
                    double d = ((VillagerEntityMCA)this.entity).method_5858((class_1297)v);
                    int n = v.method_5968() == null ? 1024 : 64;
                    if (d <= (double)n) {
                        v.pardonPlayers(99);
                    }
                });
                break;
            }
            case "location": {
                if (Config.getInstance().structuresInRumors.size() > 0) {
                    if (arg.length() == 0) {
                        arg = Config.getInstance().structuresInRumors.get(((VillagerEntityMCA)this.entity).method_6051().method_43048(Config.getInstance().structuresInRumors.size()));
                    }
                    class_3218 world = (class_3218)((VillagerEntityMCA)this.entity).method_37908();
                    String finalArg = arg;
                    MCA.executorService.execute(() -> {
                        class_2960 identifier = new class_2960(finalArg);
                        class_2338 pos = class_5535.method_31541((class_5819)((VillagerEntityMCA)this.entity).method_6051(), (int)1024, (int)0).method_10081((class_2382)((VillagerEntityMCA)this.entity).method_24515());
                        Optional<class_2338> position = WorldUtils.getClosestStructurePosition(world, pos, identifier, 64);
                        if (position.isPresent()) {
                            String posString = position.get().method_10263() + "," + position.get().method_10264() + "," + position.get().method_10260();
                            ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "dialogue.location." + identifier.method_12832(), new Object[]{posString});
                        } else {
                            ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "dialogue.location.forgot", new Object[0]);
                        }
                    });
                    break;
                }
                ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "dialogue.location.forgot", new Object[0]);
                break;
            }
            case "slap": {
                player.method_5643(player.method_37908().method_48963().method_48823(), 1.0f);
            }
        }
        return super.handle(player, command);
    }

    private void payEmeralds(class_3222 player, int emeralds) {
        class_1661 inventory = player.method_31548();
        for (int j = 0; j < inventory.method_5439(); ++j) {
            class_1799 itemStack = inventory.method_5438(j);
            if (!itemStack.method_7909().equals(class_1802.field_8687)) continue;
            int c = Math.min(itemStack.method_7947(), emeralds);
            itemStack.method_7934(c);
            if ((emeralds -= c) > 0) continue;
            return;
        }
    }
}

