/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca;

import com.google.common.collect.ImmutableSet;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import forge.net.mca.entity.ai.PointOfInterestTypeMCA;
import forge.net.mca.mixin.MixinVillagerProfession;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface ProfessionsMCA {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((String)"mca", (ResourceKey)Registries.f_256749_);
    public static final RegistrySupplier<VillagerProfession> OUTLAW = ProfessionsMCA.register("outlaw", false, true, true, PoiType.f_218034_, VillagerProfession.f_219627_, SoundEvents.f_12567_);
    public static final RegistrySupplier<VillagerProfession> GUARD = ProfessionsMCA.register("guard", false, true, false, PoiType.f_218034_, VillagerProfession.f_219627_, SoundEvents.f_12510_);
    public static final RegistrySupplier<VillagerProfession> ARCHER = ProfessionsMCA.register("archer", false, true, false, PoiType.f_218034_, VillagerProfession.f_219627_, SoundEvents.f_12569_);
    public static final RegistrySupplier<VillagerProfession> ADVENTURER = ProfessionsMCA.register("adventurer", true, true, true, PoiType.f_218034_, VillagerProfession.f_219627_, SoundEvents.f_12569_);
    public static final RegistrySupplier<VillagerProfession> MERCENARY = ProfessionsMCA.register("mercenary", false, true, true, PoiType.f_218034_, VillagerProfession.f_219627_, SoundEvents.f_12569_);
    public static final RegistrySupplier<VillagerProfession> CULTIST = ProfessionsMCA.register("cultist", true, true, true, PoiType.f_218034_, VillagerProfession.f_219627_, SoundEvents.f_12569_);
    public static final Set<VillagerProfession> canNotTrade = new HashSet<VillagerProfession>();
    public static final Set<VillagerProfession> isImportant = new HashSet<VillagerProfession>();
    public static final Set<VillagerProfession> needsNoHome = new HashSet<VillagerProfession>();

    public static void bootstrap() {
        PROFESSIONS.register();
        PointOfInterestTypeMCA.bootstrap();
        canNotTrade.add(VillagerProfession.f_35585_);
        canNotTrade.add(VillagerProfession.f_35596_);
    }

    private static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, ResourceKey<PoiType> heldWorkstation, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, important, needsNoHome, entry -> entry.m_203565_(heldWorkstation), entry -> entry.m_203565_(heldWorkstation), workSound);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, Predicate<Holder<PoiType>> heldWorkstation, Predicate<Holder<PoiType>> acquirableWorkstation, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, important, needsNoHome, heldWorkstation, acquirableWorkstation, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), workSound);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, ResourceKey<PoiType> heldWorkstation, ImmutableSet<Item> gatherableItems, ImmutableSet<Block> secondaryJobSites, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, important, needsNoHome, entry -> entry.m_203565_(heldWorkstation), entry -> entry.m_203565_(heldWorkstation), gatherableItems, secondaryJobSites, workSound);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, Predicate<Holder<PoiType>> heldWorkstation, Predicate<Holder<PoiType>> acquirableWorkstation, ImmutableSet<Item> gatherableItems, ImmutableSet<Block> secondaryJobSites, @Nullable SoundEvent workSound) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return PROFESSIONS.register(id, () -> {
            VillagerProfession result = MixinVillagerProfession.init(id.toString().replace(':', '.'), heldWorkstation, acquirableWorkstation, gatherableItems, secondaryJobSites, workSound);
            if (!canTradeWith) {
                canNotTrade.add(result);
            }
            if (important) {
                isImportant.add(result);
            }
            if (needsNoHome) {
                ProfessionsMCA.needsNoHome.add(result);
            }
            return result;
        });
    }

    public static String getFavoredBuilding(VillagerProfession profession) {
        if (VillagerProfession.f_35588_ == profession || VillagerProfession.f_35594_ == profession || VillagerProfession.f_35589_ == profession) {
            return "library";
        }
        if (GUARD.get() == profession || ARCHER.get() == profession) {
            return "inn";
        }
        return null;
    }
}

