/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.ExtendedScreen;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.client.gui.widget.TooltipButtonWidget;
import forge.net.mca.client.gui.widget.WidgetUtils;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.c2s.GetVillageRequest;
import forge.net.mca.network.c2s.RenameVillageMessage;
import forge.net.mca.network.c2s.ReportBuildingMessage;
import forge.net.mca.network.c2s.SaveVillageMessage;
import forge.net.mca.resources.BuildingTypes;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.data.BuildingType;
import forge.net.mca.resources.data.tasks.Task;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.util.compat.ButtonWidget;
import forge.net.mca.util.localization.FlowingText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlueprintScreen
extends ExtendedScreen {
    private static final int POSITION_TAXES = -60;
    private static final int POSITION_BIRTH = -10;
    private static final int POSITION_MARRIAGE = 40;
    private Village village;
    private int reputation;
    private boolean isVillage;
    private Rank rank;
    private Set<String> completedTasks;
    private String page;
    private ButtonWidget[] buttonTaxes;
    private ButtonWidget[] buttonBirths;
    private ButtonWidget[] buttonMarriage;
    private ButtonWidget buttonPage;
    private int pageNumber = 0;
    private final List<Button> catalogButtons = new LinkedList<Button>();
    private static final ResourceLocation ICON_TEXTURES = MCA.locate("textures/buildings.png");
    private BuildingType selectedBuilding;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private Map<Rank, List<Task>> tasks;

    public BlueprintScreen() {
        super((Component)Component.m_237113_((String)"Blueprint"));
    }

    private void saveVillage() {
        NetworkHandler.sendToServer(new SaveVillageMessage(this.village));
    }

    private void changeTaxes(float d) {
        this.village.setTaxes(Math.max(0.0f, Math.min(1.0f, this.village.getTaxes() + d)));
        this.saveVillage();
    }

    private void changePopulationThreshold(float d) {
        this.village.setPopulationThreshold(Math.max(0.0f, Math.min(1.0f, this.village.getPopulationThreshold() + d)));
        this.saveVillage();
    }

    private void changeMarriageThreshold(float d) {
        this.village.setMarriageThreshold(Math.max(0.0f, Math.min(1.0f, this.village.getMarriageThreshold() + d)));
        this.saveVillage();
    }

    private ButtonWidget[] createValueChanger(int x, int y, int w, int h, Consumer<Boolean> onPress, Component tooltip) {
        ButtonWidget[] buttons = new ButtonWidget[3];
        buttons[1] = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(x - w / 2, y, w / 4, h, (Component)Component.m_237113_((String)"<<"), b -> onPress.accept(false)));
        buttons[2] = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(x + w / 4, y, w / 4, h, (Component)Component.m_237113_((String)">>"), b -> onPress.accept(true)));
        buttons[0] = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(x - w / 4, y, w / 2, h, (Component)Component.m_237113_((String)""), b -> {}, tooltip));
        return buttons;
    }

    protected void drawBuildingIcon(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v) {
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_85837_((double)x - 6.6, (double)y - 6.6, 0.0);
        matrices.m_85841_(0.66f, 0.66f, 0.66f);
        context.m_280218_(texture, 0, 0, u, v, 20, 20);
        matrices.m_85849_();
    }

    public void m_7856_() {
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.setPage("waiting");
    }

    private void setPage(String page) {
        if (page.equals("close")) {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
            return;
        }
        this.page = page;
        this.m_169413_();
        this.m_142416_((GuiEventListener)new ButtonWidget(5, 5, 20, 20, (Component)Component.m_237115_((String)"gui.button.backarrow"), b -> this.setPage("close")));
        int bx = this.f_96543_ / 2 - 180;
        int by = this.f_96544_ / 2 - 56;
        if (!(page.equals("rename") || page.equals("empty") || page.equals("waiting"))) {
            for (String p : new String[]{"map", "rank", "catalog", "villagers", "rules", "refresh"}) {
                ButtonWidget widget = new ButtonWidget(bx, by, 80, 20, (Component)Component.m_237115_((String)("gui.blueprint." + p)), b -> this.setPage(p));
                this.m_142416_((GuiEventListener)widget);
                if (page.equals(p)) {
                    widget.f_93623_ = false;
                }
                by += 22;
            }
        }
        switch (page) {
            case "empty": {
                bx = this.f_96543_ / 2 - 48;
                by = this.f_96544_ / 2;
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx - 50, by + 5, 96, 20, "gui.blueprint.addRoom", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                    this.m_7379_();
                }));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx + 50, by + 5, 96, 20, "gui.blueprint.addBuilding", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                    this.m_7379_();
                }));
                break;
            }
            case "refresh": {
                NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FULL_SCAN));
                NetworkHandler.sendToServer(new GetVillageRequest());
                assert (this.f_96541_ != null);
                assert (this.f_96541_.f_91074_ != null);
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"blueprint.refreshed"), true);
                this.setPage("map");
                break;
            }
            case "advanced": {
                bx = this.f_96543_ / 2 + 180 - 64 - 16;
                by = this.f_96544_ / 2 - 56;
                MutableComponent text = Component.m_237115_((String)"gui.blueprint.autoScan");
                if (this.village.isAutoScan()) {
                    text.m_130940_(ChatFormatting.GREEN);
                } else {
                    text.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by, 96, 20, text, Component.m_237115_((String)"gui.blueprint.autoScan.tooltip"), arg_0 -> this.lambda$setPage$7((String)page, arg_0)));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.restrictAccess", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FORCE_TYPE, "blocked"));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.addBuilding", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 66;
                if (this.isVillage) {
                    this.m_142416_((GuiEventListener)new ButtonWidget(bx, by, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.renameVillage"), b -> this.setPage("rename")));
                }
            }
            case "map": {
                bx = this.f_96543_ / 2 + 180 - 64 - 16;
                by = this.f_96544_ / 2 - 56 + 66;
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(bx, by, 96, 20, "gui.blueprint.addRoom", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.m_142416_((GuiEventListener)new ButtonWidget(bx, by += 22, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.removeBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.REMOVE));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 22;
                if (page.equals("advanced")) break;
                this.m_142416_((GuiEventListener)new ButtonWidget(bx, by, 96, 20, (Component)Component.m_237115_((String)"gui.blueprint.advanced"), b -> this.setPage("advanced")));
                break;
            }
            case "rank": {
                break;
            }
            case "catalog": {
                int row = 0;
                int col = 0;
                int size = 21;
                int x = this.f_96543_ / 2 - 4 * size - 8;
                int y = (int)((double)(this.f_96544_ / 2) - 2.0 * (double)size);
                this.catalogButtons.clear();
                for (BuildingType bt : BuildingTypes.getInstance()) {
                    if (!bt.visible()) continue;
                    ImageButton widget = new ImageButton(row * size + x + 10, col * size + y - 10, 20, 20, bt.iconU(), bt.iconV() + 20, 20, ICON_TEXTURES, 256, 256, button -> {
                        this.selectBuilding(bt);
                        button.f_93623_ = false;
                        this.catalogButtons.forEach(b -> {
                            b.f_93623_ = true;
                        });
                    }, (Component)Component.m_237115_((String)("buildingType." + bt.name())));
                    this.catalogButtons.add((Button)this.m_142416_((GuiEventListener)widget));
                    if (++row <= 4) continue;
                    row = 0;
                    ++col;
                }
                break;
            }
            case "villagers": {
                this.m_142416_((GuiEventListener)new ButtonWidget(this.f_96543_ / 2 - 24 - 20, this.f_96544_ / 2 + 54, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
                    if (this.pageNumber > 0) {
                        --this.pageNumber;
                    }
                }));
                this.m_142416_((GuiEventListener)new ButtonWidget(this.f_96543_ / 2 + 24, this.f_96544_ / 2 + 54, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
                    if ((double)this.pageNumber < Math.ceil((double)this.village.getPopulation() / 9.0) - 1.0) {
                        ++this.pageNumber;
                    }
                }));
                this.buttonPage = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(this.f_96543_ / 2 - 24, this.f_96544_ / 2 + 54, 48, 20, (Component)Component.m_237113_((String)"0/0)"), b -> {}));
                break;
            }
            case "rules": {
                this.buttonTaxes = this.createValueChanger(this.f_96543_ / 2, this.f_96544_ / 2 + -60 + 10, 80, 20, b -> this.changeTaxes(b != false ? 0.125f : -0.125f), (Component)Component.m_237115_((String)"gui.blueprint.tooltip.taxes"));
                this.toggleButtons(this.buttonTaxes, false);
                this.buttonBirths = this.createValueChanger(this.f_96543_ / 2, this.f_96544_ / 2 + -10 + 10, 80, 20, b -> this.changePopulationThreshold(b != false ? 0.125f : -0.125f), (Component)Component.m_237115_((String)"gui.blueprint.tooltip.births"));
                this.toggleButtons(this.buttonBirths, false);
                this.buttonMarriage = this.createValueChanger(this.f_96543_ / 2, this.f_96544_ / 2 + 40 + 10, 80, 20, b -> this.changeMarriageThreshold(b != false ? 0.125f : -0.125f), (Component)Component.m_237115_((String)"gui.blueprint.tooltip.marriage"));
                this.toggleButtons(this.buttonMarriage, false);
                break;
            }
            case "rename": {
                EditBox field = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 16, 130, 20, (Component)Component.m_237115_((String)"gui.blueprint.renameVillage")));
                field.m_94199_(32);
                field.m_94144_(this.village.getName());
                this.m_142416_((GuiEventListener)new ButtonWidget(this.f_96543_ / 2 - 66, this.f_96544_ / 2 + 8, 64, 20, (Component)Component.m_237115_((String)"gui.blueprint.cancel"), b -> this.setPage("map")));
                this.m_142416_((GuiEventListener)new ButtonWidget(this.f_96543_ / 2 + 2, this.f_96544_ / 2 + 8, 64, 20, (Component)Component.m_237115_((String)"gui.blueprint.rename"), b -> {
                    NetworkHandler.sendToServer(new RenameVillageMessage(this.village.getId(), field.m_94155_()));
                    this.village.setName(field.m_94155_());
                    this.setPage("map");
                }));
            }
        }
    }

    private void selectBuilding(BuildingType b) {
        this.selectedBuilding = b;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics context, int sizeX, int sizeY, float offset) {
        this.m_280273_(context);
        assert (this.f_96541_ != null);
        this.mouseX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96543_ / (double)this.f_96541_.m_91268_().m_85441_());
        this.mouseY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96544_ / (double)this.f_96541_.m_91268_().m_85442_());
        switch (this.page) {
            case "waiting": {
                context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.waiting"), this.f_96543_ / 2, this.f_96544_ / 2, -5592406);
                break;
            }
            case "empty": {
                context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.empty"), this.f_96543_ / 2, this.f_96544_ / 2 - 20, -5592406);
                break;
            }
            case "map": {
                this.renderStats(context);
                this.renderName(context);
                this.renderMap(context);
                break;
            }
            case "advanced": {
                this.renderName(context);
                this.renderMap(context);
                break;
            }
            case "rank": {
                this.renderTasks(context);
                this.renderStats(context);
                break;
            }
            case "catalog": {
                this.renderCatalog(context);
                break;
            }
            case "villagers": {
                this.renderVillagers(context);
                break;
            }
            case "rules": {
                this.renderRules(context);
            }
        }
        super.m_88315_(context, sizeX, sizeY, offset);
    }

    private void renderName(GuiGraphics context) {
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_85841_(2.0f, 2.0f, 2.0f);
        if (this.isVillage) {
            context.m_280137_(this.f_96547_, this.village.getName(), this.f_96543_ / 4, this.f_96544_ / 4 - 48, -1);
        } else {
            context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.settlement"), this.f_96543_ / 4, this.f_96544_ / 4 - 48, -1);
        }
        matrices.m_85849_();
    }

    private void renderStats(GuiGraphics context) {
        int x = this.f_96543_ / 2 + (this.page.equals("rank") ? -70 : 105);
        int y = this.f_96544_ / 2 - 50;
        MutableComponent rankStr = Component.m_237115_((String)this.rank.getTranslationKey());
        int rankColor = this.rank.ordinal() == 0 ? -65536 : -256;
        context.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.blueprint.currentRank", (Object[])new Object[]{rankStr}), x, y, rankColor);
        context.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.blueprint.reputation", (Object[])new Object[]{String.valueOf(this.reputation)}), x, y + 11, this.rank.ordinal() == 0 ? -65536 : -1);
        context.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.blueprint.buildings", (Object[])new Object[]{this.village.getBuildings().size()}), x, y + 22, -1);
        context.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.blueprint.population", (Object[])new Object[]{this.village.getPopulation(), this.village.getMaxPopulation()}), x, y + 33, -1);
    }

    /*
     * WARNING - void declaration
     */
    private void renderMap(GuiGraphics context) {
        void var11_14;
        PoseStack matrices = context.m_280168_();
        int mapSize = 75;
        int y = this.f_96544_ / 2 + 8;
        WidgetUtils.drawRectangle(context, this.f_96543_ / 2 - mapSize, y - mapSize, this.f_96543_ / 2 + mapSize, y + mapSize, -120);
        if (!this.village.isAutoScan() && this.village.getBuildings().size() <= 1) {
            context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.autoScanDisabled"), this.f_96543_ / 2, this.f_96544_ / 2 + 90, -1426063361);
        }
        matrices.m_85836_();
        float sc = Math.min((float)mapSize / (float)(this.village.getBox().getMaxBlockCount() + 3) * 2.0f, 2.0f);
        int mouseLocalX = (int)(((double)this.mouseX - (double)this.f_96543_ / 2.0) / (double)sc + (double)this.village.getCenter().m_123341_());
        int mouseLocalY = (int)((float)(this.mouseY - y) / sc + (float)this.village.getCenter().m_123343_());
        matrices.m_85837_((double)this.f_96543_ / 2.0, (double)y, 0.0);
        matrices.m_85841_(sc, sc, 0.0f);
        matrices.m_252880_((float)(-this.village.getCenter().m_123341_()), (float)(-this.village.getCenter().m_123343_()), 0.0f);
        assert (this.f_96541_ != null);
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player != null) {
            WidgetUtils.drawRectangle(context, (int)player.m_20185_() - 1, (int)player.m_20189_() - 1, (int)player.m_20185_() + 1, (int)player.m_20189_() + 1, -65281);
        }
        LinkedList<Building> hoverBuildings = new LinkedList<Building>();
        for (Building building : this.village.getBuildings().values()) {
            if (!building.isComplete()) continue;
            BuildingType bt = building.getBuildingType();
            if (bt.isIcon()) {
                BlockPos blockPos = building.getCenter();
                this.drawBuildingIcon(context, ICON_TEXTURES, blockPos.m_123341_(), blockPos.m_123343_(), bt.iconU(), bt.iconV());
                int n = 6;
                Vec3i vec3i = new Vec3i(mouseLocalX, blockPos.m_123342_(), mouseLocalY);
                if (!(blockPos.m_123331_(vec3i) < (double)(n * n))) continue;
                hoverBuildings.add(building);
                continue;
            }
            BlockPos blockPos = building.getPos0();
            BlockPos blockPos2 = building.getPos1();
            WidgetUtils.drawRectangle(context, blockPos.m_123341_(), blockPos.m_123343_(), blockPos2.m_123341_(), blockPos2.m_123343_(), bt.getColor());
            if (bt.visible()) {
                BlockPos c = building.getCenter();
                this.drawBuildingIcon(context, ICON_TEXTURES, c.m_123341_(), c.m_123343_(), bt.iconU(), bt.iconV());
            }
            int margin = 1;
            if (mouseLocalX < blockPos.m_123341_() - margin || mouseLocalX > blockPos2.m_123341_() + margin || mouseLocalY < blockPos.m_123343_() - margin || mouseLocalY > blockPos2.m_123343_() + margin) continue;
            hoverBuildings.add(building);
        }
        matrices.m_85849_();
        hoverBuildings.sort((a, b) -> b.getCenter().m_123342_() - a.getCenter().m_123342_());
        LinkedList<List<Component>> tooltips = new LinkedList<List<Component>>();
        for (Object b2 : hoverBuildings) {
            tooltips.add(this.getBuildingTooltip((Building)b2));
        }
        boolean bl = false;
        for (List list : tooltips) {
            var11_14 += this.getTooltipHeight(list) + 9;
        }
        int py = this.mouseY - var11_14 / 2 + 12;
        for (List list : tooltips) {
            context.m_280666_(this.f_96547_, list, this.mouseX, py);
            py += this.getTooltipHeight(list) + 9;
        }
    }

    private List<Component> getBuildingTooltip(Building hoverBuilding) {
        LinkedList<Component> lines = new LinkedList<Component>();
        BuildingType bt = BuildingTypes.getInstance().getBuildingType(hoverBuilding.getType());
        lines.add((Component)Component.m_237115_((String)("buildingType." + bt.name())));
        for (String string : this.village.getResidents(hoverBuilding.getId())) {
            lines.add((Component)Component.m_237113_((String)string));
        }
        for (Map.Entry entry : hoverBuilding.getBlocks().entrySet()) {
            lines.add((Component)Component.m_237113_((String)(((List)entry.getValue()).size() + " x ")).m_7220_(this.getBlockName((ResourceLocation)entry.getKey())).m_130940_(ChatFormatting.GRAY));
        }
        return lines;
    }

    private void renderTasks(GuiGraphics context) {
        if (this.rank == null) {
            return;
        }
        int y = this.f_96544_ / 2 + 5;
        int x = this.f_96543_ / 2 - 70;
        for (Task task : this.tasks.get((Object)this.rank.promote())) {
            boolean completed = this.completedTasks.contains(task.getId());
            MutableComponent t = task.getTranslatable().m_130940_(completed ? ChatFormatting.STRIKETHROUGH : ChatFormatting.RESET);
            context.m_280430_(this.f_96547_, (Component)t, x, y, completed ? -7798904 : -43691);
            y += 11;
        }
    }

    private void renderCatalog(GuiGraphics context) {
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_85841_(2.0f, 2.0f, 2.0f);
        context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.catalogFull"), this.f_96543_ / 4, this.f_96544_ / 4 - 52, -1);
        matrices.m_85849_();
        context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.catalogHint").m_130940_(ChatFormatting.GRAY), this.f_96543_ / 2, this.f_96544_ / 2 - 82, -1);
        int x = this.f_96543_ / 2 + 35;
        int y = this.f_96544_ / 2 - 50;
        if (this.selectedBuilding != null) {
            context.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)("buildingType." + this.selectedBuilding.name())), x, y, this.selectedBuilding.getColor());
            y += 12;
            List<Component> wrap = FlowingText.wrap((Component)Component.m_237115_((String)("buildingType." + this.selectedBuilding.name() + ".description")).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), 150);
            for (Component component : wrap) {
                context.m_280430_(this.f_96547_, component, x, y, -1);
                y += 10;
            }
            y += 24;
            for (Map.Entry entry : this.selectedBuilding.getGroups().entrySet()) {
                context.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)(entry.getValue() + " x ")).m_7220_(this.getBlockName((ResourceLocation)entry.getKey())), x, y, -1);
                y += 10;
            }
        } else {
            List<Component> wrap = FlowingText.wrap((Component)Component.m_237115_((String)"gui.blueprint.buildingTypes").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), 150);
            for (Component component : wrap) {
                context.m_280430_(this.f_96547_, component, x, y, -1);
                y += 10;
            }
        }
    }

    private void renderVillagers(GuiGraphics context) {
        int index;
        int maxPages = (int)Math.ceil((double)this.village.getPopulation() / 9.0);
        this.buttonPage.m_93666_((Component)Component.m_237113_((String)(this.pageNumber + 1 + "/" + maxPages)));
        List villager = this.village.getResidentNames().entrySet().stream().sorted(Map.Entry.comparingByValue()).toList();
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < villager.size(); ++i) {
            int y = this.f_96544_ / 2 - 51 + i * 11;
            boolean hover = this.isMouseWithin(this.f_96543_ / 2 - 50, y - 1, 100, 11);
            context.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)((String)villager.get(index).getValue())), this.f_96543_ / 2, y, hover ? -2631804 : -1);
            if (!hover) continue;
            this.selectedVillager = (UUID)villager.get(index).getKey();
        }
    }

    private void renderRules(GuiGraphics context) {
        this.buttonTaxes[0].m_93666_((Component)Component.m_237113_((String)((int)(this.village.getTaxes() * 100.0f) + "%")));
        this.buttonMarriage[0].m_93666_((Component)Component.m_237113_((String)((int)(this.village.getMarriageThreshold() * 100.0f) + "%")));
        this.buttonBirths[0].m_93666_((Component)Component.m_237113_((String)((int)(this.village.getPopulationThreshold() * 100.0f) + "%")));
        context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.taxes"), this.f_96543_ / 2, this.f_96544_ / 2 + -60, -1);
        if (!this.rank.isAtLeast(Rank.MERCHANT)) {
            context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.rankTooLow"), this.f_96543_ / 2, this.f_96544_ / 2 + -60 + 15, -1);
            this.toggleButtons(this.buttonTaxes, false);
        } else {
            this.toggleButtons(this.buttonTaxes, true);
        }
        context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.birth"), this.f_96543_ / 2, this.f_96544_ / 2 + -10, -1);
        if (!this.rank.isAtLeast(Rank.NOBLE)) {
            context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.rankTooLow"), this.f_96543_ / 2, this.f_96544_ / 2 + -10 + 15, -1);
            this.toggleButtons(this.buttonBirths, false);
        } else {
            this.toggleButtons(this.buttonBirths, true);
        }
        context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.marriage"), this.f_96543_ / 2, this.f_96544_ / 2 + 40, -1);
        if (!this.rank.isAtLeast(Rank.MAYOR)) {
            context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.blueprint.rankTooLow"), this.f_96543_ / 2, this.f_96544_ / 2 + 40 + 15, -1);
            this.toggleButtons(this.buttonMarriage, false);
        } else {
            this.toggleButtons(this.buttonMarriage, true);
        }
    }

    private Component getBlockName(ResourceLocation id) {
        if (BuiltInRegistries.f_256975_.m_7804_(id)) {
            return Component.m_237115_((String)((Block)BuiltInRegistries.f_256975_.m_7745_(id)).m_7705_());
        }
        return Component.m_237115_((String)("tag." + id.toString()));
    }

    private void toggleButtons(ButtonWidget[] buttons, boolean active) {
        for (ButtonWidget b : buttons) {
            b.f_93623_ = active;
            b.f_93624_ = active;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.page.equals("villagers") && this.selectedVillager != null) {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_((Screen)new FamilyTreeScreen(this.selectedVillager));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public void setVillage(Village village) {
        this.village = village;
        if (village == null) {
            this.setPage("empty");
        } else if (this.page.equals("waiting")) {
            this.setPage("map");
        }
    }

    public void setVillageData(Rank rank, int reputation, boolean isVillage, Set<String> completedTasks, Map<Rank, List<Task>> tasks) {
        this.rank = rank;
        this.reputation = reputation;
        this.isVillage = isVillage;
        this.completedTasks = completedTasks;
        this.tasks = tasks;
    }

    private /* synthetic */ void lambda$setPage$7(String page, Button b) {
        NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.AUTO_SCAN));
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.village.toggleAutoScan();
        this.setPage(page);
    }
}

