/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.chatAI;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.chatAI.ChatAIStrategy;
import forge.net.mca.entity.ai.chatAI.GPT3;
import forge.net.mca.entity.ai.chatAI.InworldAI;
import forge.net.mca.util.WorldUtils;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ChatAI {
    private static final int VILLAGER_SEARCH_RANGE = 32;
    private static final int CONVERSATION_TIME = 1200;
    private static final int CONVERSATION_DISTANCE = 16;
    private static final Map<UUID, ChatAIStrategy> strategies = new HashMap<UUID, ChatAIStrategy>();
    private static final Map<UUID, OpenConversation> currentConversations = new ConcurrentHashMap<UUID, OpenConversation>();

    public static Optional<String> answer(ServerPlayer player, VillagerEntityMCA villager, String msg) {
        ChatAIStrategy strategy = ChatAI.computeStrategyIfAbsent(villager.m_20148_());
        long time = villager.m_9236_().m_46467_();
        currentConversations.put(player.m_20148_(), new OpenConversation(villager.m_20148_(), time));
        return strategy.answer(player, villager, msg);
    }

    private static ChatAIStrategy computeStrategyIfAbsent(UUID villagerID) {
        return strategies.computeIfAbsent(villagerID, v -> {
            String inworldResourceName = Config.getInstance().inworldAIResourceNames.getOrDefault(v, "");
            return inworldResourceName.isEmpty() ? new GPT3() : new InworldAI(inworldResourceName);
        });
    }

    public static void clearStrategy(UUID villagerID) {
        strategies.remove(villagerID);
    }

    public static Optional<VillagerEntityMCA> getVillagerForConversation(ServerPlayer player, String msg) {
        UUID playerUUID = player.m_20148_();
        List<VillagerEntityMCA> nearbyVillagers = WorldUtils.getCloseEntities(player.m_9236_(), (Entity)player, 32.0, VillagerEntityMCA.class);
        String normalizedMsg = ChatAI.normalizeString(msg);
        for (VillagerEntityMCA villager : nearbyVillagers) {
            String normalizedName = ChatAI.normalizeString((String)villager.getTrackedValue(VillagerLike.VILLAGER_NAME));
            if (!normalizedMsg.contains(normalizedName)) continue;
            return Optional.of(villager);
        }
        OpenConversation conv = currentConversations.getOrDefault(playerUUID, new OpenConversation(playerUUID, 0L));
        Optional<VillagerEntityMCA> optionalVillager = nearbyVillagers.stream().filter(v -> conv.villagerUUID.equals(v.m_20148_())).findFirst();
        if (optionalVillager.isPresent() && ChatAI.isInConversationWith(player, optionalVillager.get())) {
            return optionalVillager;
        }
        return Optional.empty();
    }

    private static boolean isInConversationWith(ServerPlayer player, VillagerEntityMCA villager) {
        OpenConversation conversation = currentConversations.getOrDefault(player.m_20148_(), new OpenConversation(villager.m_20148_(), 0L));
        return villager.m_20270_((Entity)player) < 16.0f && villager.m_9236_().m_46467_() < conversation.lastInteractionTime + 1200L;
    }

    public static Optional<VillagerEntityMCA> findVillagerInArea(ServerPlayer player, String searchName) {
        List<VillagerEntityMCA> entities = WorldUtils.getCloseEntities(player.m_9236_(), (Entity)player, 32.0, VillagerEntityMCA.class);
        String normalizedSearchName = ChatAI.normalizeString(searchName);
        for (VillagerEntityMCA villager : entities) {
            String villagerName = ChatAI.normalizeString((String)villager.getTrackedValue(VillagerLike.VILLAGER_NAME));
            if (!normalizedSearchName.equals(villagerName)) continue;
            return Optional.of(villager);
        }
        return Optional.empty();
    }

    private static String normalizeString(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{M}", "").toLowerCase(Locale.ROOT);
    }

    private record OpenConversation(UUID villagerUUID, Long lastInteractionTime) {
    }
}

