/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.chatAI.inworldAIModules;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.chatAI.inworldAIModules.api.Interaction;
import forge.net.mca.entity.ai.chatAI.inworldAIModules.api.TriggerEvent;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TriggerModule {
    private static final Map<String, BiConsumer<ServerPlayer, VillagerEntityMCA>> triggerActions = ImmutableMap.of((Object)"follow-player", (p, v) -> v.getVillagerBrain().setMoveState(MoveState.FOLLOW, (Player)p), (Object)"stay-here", (p, v) -> v.getVillagerBrain().setMoveState(MoveState.STAY, (Player)p), (Object)"move-freely", (p, v) -> v.getVillagerBrain().setMoveState(MoveState.MOVE, (Player)p), (Object)"wear-armor", (p, v) -> v.getVillagerBrain().setArmorWear(true), (Object)"remove-armor", (p, v) -> v.getVillagerBrain().setArmorWear(false), (Object)"try-go-home", (p, v) -> v.getResidency().goHome((Player)p));

    public void processTriggers(Interaction interaction, ServerPlayer player, VillagerEntityMCA villager) {
        TriggerEvent[] triggerEvents;
        for (TriggerEvent event : triggerEvents = interaction.outgoingTriggers()) {
            BiConsumer<ServerPlayer, VillagerEntityMCA> action = triggerActions.get(event.trigger());
            if (action == null) continue;
            action.accept(player, villager);
        }
    }
}

