/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.brain.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4096;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import org.apache.commons.lang3.mutable.MutableLong;

public class LazyFindPointOfInterestTask
extends class_4096 {
    private static final int MIN_DELAY = 200;

    public static class_7893<class_1314> create(Predicate<class_6880<class_4158>> poiPredicate, class_4140<class_4208> poiPosModule, class_4140<class_4208> potentialPoiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus) {
        MutableLong cooldown = new MutableLong(0L);
        Long2ObjectOpenHashMap long2ObjectMap = new Long2ObjectOpenHashMap();
        class_7894 singleTickTask = class_7898.method_47224(arg_0 -> LazyFindPointOfInterestTask.lambda$create$8(potentialPoiPosModule, onlyRunIfChild, cooldown, (Long2ObjectMap)long2ObjectMap, poiPredicate, entityStatus, arg_0));
        return potentialPoiPosModule == poiPosModule ? singleTickTask : class_7898.method_47224(context -> context.group((App)context.method_47245(poiPosModule)).apply((Applicative)context, poiPos -> singleTickTask));
    }

    private static /* synthetic */ App lambda$create$8(class_4140 potentialPoiPosModule, boolean onlyRunIfChild, MutableLong cooldown, Long2ObjectMap long2ObjectMap, Predicate poiPredicate, Optional entityStatus, class_7898.class_7900 taskContext) {
        return taskContext.group((App)taskContext.method_47245(potentialPoiPosModule)).apply((Applicative)taskContext, queryResult -> (world, entity, time) -> {
            if (onlyRunIfChild && entity.method_6109()) {
                return false;
            }
            if (cooldown.getValue() == 0L) {
                cooldown.setValue(world.method_8510() + (long)world.field_9229.method_43048(200));
                return false;
            }
            if (world.method_8510() < cooldown.getValue()) {
                return false;
            }
            cooldown.setValue(time + 200L + (long)world.method_8409().method_43048(200));
            class_4153 pointOfInterestStorage = world.method_19494();
            long2ObjectMap.long2ObjectEntrySet().removeIf(entry -> !((RetryMarker)entry.getValue()).isAttempting(time));
            Predicate<class_2338> predicate2 = pos -> {
                RetryMarker retryMarker = (RetryMarker)long2ObjectMap.get(pos.method_10063());
                if (retryMarker == null) {
                    return true;
                }
                if (!retryMarker.shouldRetry(time)) {
                    return false;
                }
                retryMarker.setAttemptTime(time);
                return true;
            };
            Set set = pointOfInterestStorage.method_30957(poiPredicate, predicate2, entity.method_24515(), 48, class_4153.class_4155.field_18487).limit(5L).collect(Collectors.toSet());
            class_11 path = LazyFindPointOfInterestTask.method_43965((class_1308)entity, set);
            if (path != null && path.method_21655()) {
                class_2338 blockPos = path.method_48();
                pointOfInterestStorage.method_19132(blockPos).ifPresent(poiType -> {
                    pointOfInterestStorage.method_19126(poiPredicate, (registryEntry, blockPos2) -> blockPos2.equals((Object)blockPos), blockPos, 1);
                    queryResult.method_47249((Object)class_4208.method_19443((class_5321)world.method_27983(), (class_2338)blockPos));
                    entityStatus.ifPresent(status -> world.method_8421((class_1297)entity, status.byteValue()));
                    long2ObjectMap.clear();
                    class_4209.method_19778((class_3218)world, (class_2338)blockPos);
                });
            } else {
                for (Pair registryEntryBlockPosPair : set) {
                    long2ObjectMap.computeIfAbsent(((class_2338)registryEntryBlockPosPair.getSecond()).method_10063(), m -> new RetryMarker(world.field_9229, time));
                }
            }
            return true;
        });
    }

    private static class RetryMarker {
        private static final int MIN_DELAY = 40;
        private static final int ATTEMPT_DURATION = 400;
        private final class_5819 random;
        private long previousAttemptAt;
        private long nextScheduledAttemptAt;
        private int currentDelay;

        RetryMarker(class_5819 random, long time) {
            this.random = random;
            this.setAttemptTime(time);
        }

        public void setAttemptTime(long time) {
            this.previousAttemptAt = time;
            int i = this.currentDelay + this.random.method_43048(40) + 40;
            this.currentDelay = Math.min(i, 400);
            this.nextScheduledAttemptAt = time + (long)this.currentDelay;
        }

        public boolean isAttempting(long time) {
            return time - this.previousAttemptAt < 400L;
        }

        public boolean shouldRetry(long time) {
            return time >= this.nextScheduledAttemptAt;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptAt + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptAt + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

