/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.chatAI;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import quilt.net.mca.Config;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.chatAI.ChatAIStrategy;
import quilt.net.mca.entity.ai.chatAI.GPT3;
import quilt.net.mca.entity.ai.chatAI.InworldAI;
import quilt.net.mca.util.WorldUtils;

public class ChatAI {
    private static final int VILLAGER_SEARCH_RANGE = 32;
    private static final int CONVERSATION_TIME = 1200;
    private static final int CONVERSATION_DISTANCE = 16;
    private static final Map<UUID, ChatAIStrategy> strategies = new HashMap<UUID, ChatAIStrategy>();
    private static final Map<UUID, OpenConversation> currentConversations = new ConcurrentHashMap<UUID, OpenConversation>();

    public static Optional<String> answer(class_3222 player, VillagerEntityMCA villager, String msg) {
        ChatAIStrategy strategy = ChatAI.computeStrategyIfAbsent(villager.method_5667());
        long time = villager.method_37908().method_8510();
        currentConversations.put(player.method_5667(), new OpenConversation(villager.method_5667(), time));
        return strategy.answer(player, villager, msg);
    }

    private static ChatAIStrategy computeStrategyIfAbsent(UUID villagerID) {
        return strategies.computeIfAbsent(villagerID, v -> {
            String inworldResourceName = Config.getInstance().inworldAIResourceNames.getOrDefault(v, "");
            return inworldResourceName.isEmpty() ? new GPT3() : new InworldAI(inworldResourceName);
        });
    }

    public static void clearStrategy(UUID villagerID) {
        strategies.remove(villagerID);
    }

    public static Optional<VillagerEntityMCA> getVillagerForConversation(class_3222 player, String msg) {
        UUID playerUUID = player.method_5667();
        List<VillagerEntityMCA> nearbyVillagers = WorldUtils.getCloseEntities(player.method_37908(), (class_1297)player, 32.0, VillagerEntityMCA.class);
        String normalizedMsg = ChatAI.normalizeString(msg);
        for (VillagerEntityMCA villager : nearbyVillagers) {
            String normalizedName = ChatAI.normalizeString((String)villager.getTrackedValue(VillagerLike.VILLAGER_NAME));
            if (!normalizedMsg.contains(normalizedName)) continue;
            return Optional.of(villager);
        }
        OpenConversation conv = currentConversations.getOrDefault(playerUUID, new OpenConversation(playerUUID, 0L));
        Optional<VillagerEntityMCA> optionalVillager = nearbyVillagers.stream().filter(v -> conv.villagerUUID.equals(v.method_5667())).findFirst();
        if (optionalVillager.isPresent() && ChatAI.isInConversationWith(player, optionalVillager.get())) {
            return optionalVillager;
        }
        return Optional.empty();
    }

    private static boolean isInConversationWith(class_3222 player, VillagerEntityMCA villager) {
        OpenConversation conversation = currentConversations.getOrDefault(player.method_5667(), new OpenConversation(villager.method_5667(), 0L));
        return villager.method_5739((class_1297)player) < 16.0f && villager.method_37908().method_8510() < conversation.lastInteractionTime + 1200L;
    }

    public static Optional<VillagerEntityMCA> findVillagerInArea(class_3222 player, String searchName) {
        List<VillagerEntityMCA> entities = WorldUtils.getCloseEntities(player.method_37908(), (class_1297)player, 32.0, VillagerEntityMCA.class);
        String normalizedSearchName = ChatAI.normalizeString(searchName);
        for (VillagerEntityMCA villager : entities) {
            String villagerName = ChatAI.normalizeString((String)villager.getTrackedValue(VillagerLike.VILLAGER_NAME));
            if (!normalizedSearchName.equals(villagerName)) continue;
            return Optional.of(villager);
        }
        return Optional.empty();
    }

    private static String normalizeString(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{M}", "").toLowerCase(Locale.ROOT);
    }

    private record OpenConversation(UUID villagerUUID, Long lastInteractionTime) {
    }
}

