/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedCornerStripModel
extends FramedBlockModel {
    private final Direction dir;
    private final SlopeType type;

    public FramedCornerStripModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
    }

    @Override
    public void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.type == SlopeType.HORIZONTAL) {
            if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.0625f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.0625f)).export(quadMap.get(quadDir));
            } else if (quadDir.m_122434_() == this.dir.m_122434_()) {
                boolean onFace = quadDir == this.dir;
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get(onFace ? quadDir : null));
            } else if (quadDir.m_122434_() == this.dir.m_122427_().m_122434_()) {
                boolean onFace = quadDir == this.dir.m_122428_();
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get(onFace ? quadDir : null));
            }
        } else {
            boolean top;
            boolean bl = top = this.type == SlopeType.TOP;
            if (quadDir.m_122434_() == this.dir.m_122427_().m_122434_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.0625f)).apply(Modifiers.cutSideUpDown(top, 0.0625f)).export(quadMap.get(quadDir));
            } else if (quadDir.m_122434_() == this.dir.m_122434_()) {
                boolean onFace = quadDir == this.dir;
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(top, 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get(onFace ? quadDir : null));
            } else if (Utils.isY(quadDir)) {
                boolean onFace = top ? quadDir == Direction.UP : quadDir == Direction.DOWN;
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get(onFace ? quadDir : null));
            }
        }
    }

    @Override
    public void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        if (ctx.m_269069_()) {
            poseStack.m_252781_(Quaternions.YP_90);
        }
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }
}

