/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.util;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.fml.ModList;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.render.util.AnimationSplitterSourceAV;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class AnimationSplitterSource
implements SpriteSource {
    private static final boolean AV_LOADED = ModList.get().isLoaded("atlasviewer");
    private static SpriteSourceType TYPE = null;
    private static final Codec<AnimationSplitterSource> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("resource").forGetter(s -> s.resource), (App)ExtraCodecs.m_144637_((Codec)Frame.CODEC.listOf()).fieldOf("frames").forGetter(s -> s.frames)).apply((Applicative)inst, AV_LOADED ? AnimationSplitterSourceAV::new : AnimationSplitterSource::new));
    private final ResourceLocation resource;
    private final List<Frame> frames;

    public AnimationSplitterSource(ResourceLocation resource, List<Frame> frames) {
        this.resource = resource;
        this.frames = frames;
    }

    public void m_260891_(ResourceManager mgr, SpriteSource.Output out) {
        ResourceLocation texPath = f_266012_.m_245698_(this.resource);
        Optional optResource = mgr.m_213713_(texPath);
        if (optResource.isPresent()) {
            Resource res = (Resource)optResource.get();
            LazyLoadedImage image = new LazyLoadedImage(texPath, res, this.frames.size());
            this.frames.forEach(frame -> out.m_260840_(frame.outLoc, (SpriteSource.SpriteSupplier)this.createFrameInstance(res, texPath, image, (Frame)frame)));
        } else {
            FramedBlocks.LOGGER.warn("Missing sprite: {}", (Object)texPath);
        }
    }

    FrameInstance createFrameInstance(Resource res, ResourceLocation texPath, LazyLoadedImage image, Frame frame) {
        return new FrameInstance(res, texPath, image, frame);
    }

    public SpriteSourceType m_260850_() {
        Preconditions.checkNotNull((Object)TYPE, (Object)"SpriteSourceType not registered");
        return TYPE;
    }

    public static void register() {
        String name = "framedblocks:anim_splitter";
        TYPE = SpriteSources.m_260887_((String)name, CODEC);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static class FrameInstance
    implements SpriteSource.SpriteSupplier {
        final Resource resource;
        private final ResourceLocation texPath;
        private final LazyLoadedImage lazyImage;
        private final Frame frame;

        FrameInstance(Resource resource, ResourceLocation texPath, LazyLoadedImage lazyImage, Frame frame) {
            this.resource = resource;
            this.texPath = texPath;
            this.lazyImage = lazyImage;
            this.frame = frame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents get() {
            try {
                Optional optAnim = this.resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
                if (optAnim.isEmpty()) {
                    throw new IllegalArgumentException("Texture '%s' is not an animated texture".formatted(this.texPath));
                }
                NativeImage image = this.lazyImage.m_266167_();
                int imgW = image.m_84982_();
                int imgH = image.m_85084_();
                AnimationMetadataSection anim = (AnimationMetadataSection)optAnim.get();
                FrameSize size = anim.m_245821_(imgW, imgH);
                int frameW = size.f_244129_();
                int frameH = size.f_244503_();
                int rowSize = imgW / frameW * (imgH / frameH);
                FrameInstance.checkFrameExists(this.texPath, anim, this.frame.frameIdx, rowSize);
                int srcX = this.frame.frameIdx % rowSize * frameW;
                int srcY = this.frame.frameIdx / rowSize * frameH;
                NativeImage imageOut = new NativeImage(NativeImage.Format.RGBA, frameW, frameH, false);
                image.m_260930_(imageOut, srcX, srcY, 0, 0, frameW, frameH, false, false);
                SpriteContents spriteContents = this.postProcess(new SpriteContents(this.frame.outLoc, new FrameSize(frameW, frameH), imageOut, AnimationMetadataSection.f_119012_, null));
                return spriteContents;
            }
            catch (Exception e) {
                FramedBlocks.LOGGER.error("Failed to split out frame {}", (Object)this.frame, (Object)e);
            }
            finally {
                this.lazyImage.m_266458_();
            }
            return MissingTextureAtlasSprite.m_246104_();
        }

        SpriteContents postProcess(SpriteContents contents) {
            return contents;
        }

        private static void checkFrameExists(ResourceLocation texPath, AnimationMetadataSection anim, int frameIdx, int rowSize) {
            boolean[] frameFound = new boolean[1];
            int[] maxIdx = new int[]{-1};
            anim.m_174861_((idx, time) -> {
                maxIdx[0] = Math.max(maxIdx[0], idx);
                if (idx == frameIdx) {
                    frameFound[0] = true;
                }
            });
            if (!(frameFound[0] || maxIdx[0] == -1 && frameIdx < rowSize)) {
                int max = maxIdx[0] != -1 ? maxIdx[0] : rowSize;
                throw new IllegalArgumentException("Texture '%s' has no frame with index %d, max index is %d".formatted(texPath, frameIdx, max));
            }
        }

        public void m_260986_() {
            this.lazyImage.m_266458_();
        }
    }

    public record Frame(int frameIdx, ResourceLocation outLoc) {
        private static final Codec<Frame> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("frame_idx").forGetter(Frame::frameIdx), (App)ResourceLocation.f_135803_.fieldOf("sprite").forGetter(Frame::outLoc)).apply((Applicative)inst, Frame::new));
    }
}

