/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.net.SignUpdatePacket;

public class FramedSignScreen
extends Screen {
    public static final Component TITLE = Utils.translate("title", "sign.edit");
    private final AbstractFramedSignBlock signBlock;
    private final FramedSignBlockEntity sign;
    private final boolean front;
    private final int textYOffset;
    private SignText text;
    private final String[] lines;
    private int blinkCounter = 0;
    private int currLine = 0;
    private TextFieldHelper inputUtil;

    public FramedSignScreen(FramedSignBlockEntity sign, boolean front) {
        super(TITLE);
        this.signBlock = (AbstractFramedSignBlock)sign.m_58900_().m_60734_();
        this.sign = sign;
        this.front = front;
        this.text = sign.getText(front);
        boolean filtered = Minecraft.m_91087_().m_167974_();
        this.lines = (String[])IntStream.range(0, 4).mapToObj(idx -> this.text.m_277138_(idx, filtered)).map(Component::getString).toArray(String[]::new);
        this.textYOffset = switch ((BlockType)sign.getBlockType()) {
            case BlockType.FRAMED_SIGN -> 67;
            case BlockType.FRAMED_WALL_SIGN -> 30;
            case BlockType.FRAMED_HANGING_SIGN, BlockType.FRAMED_WALL_HANGING_SIGN -> 6;
            default -> throw new IllegalArgumentException("Invalid block type: " + sign.getBlockType());
        };
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, btn -> Minecraft.m_91087_().m_91152_(null)).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 60).m_253046_(200, 20).m_253136_());
        this.inputUtil = new TextFieldHelper(() -> this.lines[this.currLine], this::setLine, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), line -> this.f_96541_.f_91062_.m_92895_(line) <= this.signBlock.getMaxTextLineWidth());
    }

    private void setLine(String line) {
        this.lines[this.currLine] = line;
        this.text = this.text.m_276913_(this.currLine, (Component)Component.m_237113_((String)line));
        this.sign.setText(this.text, this.front);
    }

    public void m_7861_() {
        FramedBlocks.CHANNEL.sendToServer((Object)new SignUpdatePacket(this.sign.m_58899_(), this.front, this.lines));
    }

    public void m_86600_() {
        ++this.blinkCounter;
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && !this.sign.m_58901_() && this.sign.isTooFarAwayToEdit((Player)this.f_96541_.f_91074_)) {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_5534_(char character, int modifiers) {
        this.inputUtil.m_95143_(character);
        return true;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key == 265) {
            this.currLine = this.currLine - 1 & 3;
            this.inputUtil.m_95193_();
            return true;
        }
        if (key == 264 || key == 257 || key == 335) {
            this.currLine = this.currLine + 1 & 3;
            this.inputUtil.m_95193_();
            return true;
        }
        return this.inputUtil.m_95145_(key) || super.m_7933_(key, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Lighting.m_166384_();
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, ChatFormatting.WHITE.m_126665_().intValue());
        this.drawSignBlock(graphics);
        this.drawText(graphics);
        Lighting.m_84931_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void drawSignBlock(GuiGraphics graphics) {
        BlockState state = this.sign.m_58900_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 100.0f);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(this.signBlock.getYRotationDegrees(state)));
        poseStack.m_252781_(Quaternions.ZP_180);
        poseStack.m_85841_(112.0f, 112.0f, 112.0f);
        poseStack.m_85837_(-0.5, -0.25, -0.5);
        BlockRenderDispatcher renderer = this.f_96541_.m_91289_();
        MultiBufferSource.BufferSource buffer = graphics.m_280091_();
        PoseStack.Pose pose = poseStack.m_85850_();
        BakedModel model = renderer.m_110910_(state);
        ModelData modelData = this.sign.getModelData();
        int color = this.f_96541_.m_91298_().m_92577_(state, (BlockAndTintGetter)this.f_96541_.f_91073_, this.sign.m_58899_(), 0);
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
            VertexConsumer consumer = buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false));
            renderer.m_110937_().renderModel(pose, consumer, state, model, red, green, blue, 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
        }
        buffer.m_109911_();
        poseStack.m_85849_();
    }

    private void drawText(GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0 - (double)this.textYOffset, 110.0);
        graphics.m_280168_().m_85841_(1.2f, 1.2f, 1.0f);
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        this.drawLines(graphics.m_280168_().m_85850_().m_252922_(), buffer, this.lines);
        this.drawCursor(graphics, buffer, this.lines);
        graphics.m_280168_().m_85849_();
    }

    private void drawLines(Matrix4f matrix, MultiBufferSource.BufferSource buffer, String[] lines) {
        int color = this.text.m_276773_().m_41071_();
        for (int line = 0; line < lines.length; ++line) {
            String text = lines[line];
            if (text == null) continue;
            if (this.f_96547_.m_92718_()) {
                text = this.f_96547_.m_92801_(text);
            }
            float textX = (float)(-this.f_96547_.m_92895_(text)) / 2.0f;
            this.f_96547_.m_271703_(text, textX, (float)(line * 10 - 20), color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        buffer.m_109911_();
    }

    private void drawCursor(GuiGraphics graphics, MultiBufferSource.BufferSource buffer, String[] lines) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        int color = this.text.m_276773_().m_41071_();
        boolean blink = this.blinkCounter / 6 % 2 == 0;
        int dir = this.f_96547_.m_92718_() ? -1 : 1;
        int y = this.currLine * 10 - 20;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || i != this.currLine || this.inputUtil.m_95194_() < 0) continue;
            int hw = this.f_96547_.m_92895_(line) / 2;
            int selectionEnd = this.f_96547_.m_92895_(line.substring(0, Math.max(Math.min(this.inputUtil.m_95194_(), line.length()), 0)));
            int cursorX = (selectionEnd - hw) * dir;
            if (blink) {
                if (this.inputUtil.m_95194_() < line.length()) {
                    graphics.m_280509_(cursorX, y - 1, cursorX + 1, y + 9, 0xFF000000 | color);
                } else {
                    this.f_96547_.m_271703_("_", (float)cursorX, (float)y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    buffer.m_109911_();
                }
            }
            if (this.inputUtil.m_95197_() == this.inputUtil.m_95194_()) continue;
            int x1 = (this.f_96547_.m_92895_(line.substring(0, this.inputUtil.m_95197_())) - hw) * dir;
            int x2 = (this.f_96547_.m_92895_(line.substring(0, this.inputUtil.m_95194_())) - hw) * dir;
            int xStart = Math.min(x1, x2);
            int xEnd = Math.max(x1, x2);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder tessBuffer = tessellator.m_85915_();
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            tessBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            tessBuffer.m_252986_(matrix, (float)xStart, (float)y + 9.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            tessBuffer.m_252986_(matrix, (float)xEnd, (float)y + 9.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            tessBuffer.m_252986_(matrix, (float)xEnd, (float)y - 1.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            tessBuffer.m_252986_(matrix, (float)xStart, (float)y - 1.0f, 0.0f).m_6122_(0, 0, 255, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)tessBuffer.m_231175_());
            RenderSystem.disableColorLogicOp();
        }
    }
}

