/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.interactive.FramedButtonBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLargeButtonBlock
extends FramedButtonBlock {
    private static final VoxelShape SHAPE_BOTTOM = FramedLargeButtonBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape SHAPE_BOTTOM_PRESSED = FramedLargeButtonBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP = FramedLargeButtonBlock.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP_PRESSED = FramedLargeButtonBlock.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape[] SHAPES_HORIZONTAL = FramedLargeButtonBlock.makeHorizontalShapes();

    private FramedLargeButtonBlock(BlockType type, int pressTime, boolean arrowsCanPress, BlockSetType blockSet) {
        super(type, pressTime, arrowsCanPress, blockSet);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FramedLargeButtonBlock.getShape(state);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return state.m_61143_((Property)f_53179_) != AttachFace.WALL;
    }

    public static VoxelShape getShape(BlockState state) {
        boolean pressed = (Boolean)state.m_61143_((Property)f_51045_);
        return switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> {
                if (pressed) {
                    yield SHAPE_BOTTOM_PRESSED;
                }
                yield SHAPE_BOTTOM;
            }
            case AttachFace.CEILING -> {
                if (pressed) {
                    yield SHAPE_TOP_PRESSED;
                }
                yield SHAPE_TOP;
            }
            case AttachFace.WALL -> {
                int idx = ((Direction)state.m_61143_((Property)f_54117_)).m_122416_() + (pressed ? 4 : 0);
                yield SHAPES_HORIZONTAL[idx];
            }
        };
    }

    private static VoxelShape[] makeHorizontalShapes() {
        VoxelShape shape = FramedLargeButtonBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0);
        VoxelShape shapePressed = FramedLargeButtonBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
        return ShapeUtils.makeHorizontalRotationsWithFlag(shape, shapePressed, Direction.SOUTH);
    }

    public static FramedLargeButtonBlock wood() {
        return new FramedLargeButtonBlock(BlockType.FRAMED_LARGE_BUTTON, 30, true, BlockSetType.f_271198_);
    }

    public static FramedLargeButtonBlock stone() {
        return new FramedLargeButtonBlock(BlockType.FRAMED_LARGE_STONE_BUTTON, 20, false, BlockSetType.f_271479_);
    }
}

