/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import java.util.Arrays;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.PacketDistributor;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.net.OpenSignScreenPacket;

public abstract class AbstractFramedSignBlock
extends FramedBlock {
    private static final Vec3 HITBOX_CENTER = new Vec3(0.5, 0.5, 0.5);

    protected AbstractFramedSignBlock(BlockType type, BlockBehaviour.Properties props) {
        super(type, props);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS || this.preventUse(state, level, pos, player, hand, hit)) {
            return result;
        }
        ItemStack stack = player.m_21120_(hand);
        SignInteraction interaction = SignInteraction.from(stack);
        boolean canInteract = interaction != null && player.m_150110_().f_35938_;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            if (level.m_5776_()) {
                return canInteract || sign.isWaxed() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
            boolean front = sign.isFacingFrontText(player);
            if (sign.isWaxed() && interaction != SignInteraction.REMOVE_WAX) {
                if (sign.canExecuteCommands(front, player) && sign.tryExecuteCommands(player, level, pos, front)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (canInteract && AbstractFramedSignBlock.notBlockedByOtherPlayer(player, sign) && interaction.interact(level, pos, player, stack, front, sign)) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    player.m_150109_().m_6596_();
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                return InteractionResult.SUCCESS;
            }
            if (AbstractFramedSignBlock.notBlockedByOtherPlayer(player, sign) && AbstractFramedSignBlock.canEdit(player, sign, front)) {
                AbstractFramedSignBlock.openEditScreen(player, sign, front);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean preventUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, dir, facingState, level, pos, facingPos);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type != PathComputationType.WATER || level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }

    public abstract float getYRotationDegrees(BlockState var1);

    public Vec3 getSignHitboxCenterPosition(BlockState state) {
        return HITBOX_CENTER;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return FramedSignBlockEntity.normalSign(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return Utils.createBlockEntityTicker(type, FBContent.BE_TYPE_FRAMED_SIGN.get(), FramedSignBlockEntity::tick);
    }

    private static boolean notBlockedByOtherPlayer(Player player, FramedSignBlockEntity sign) {
        UUID uuid = sign.getEditingPlayer();
        return uuid == null || uuid.equals(player.m_20148_());
    }

    private static boolean canEdit(Player player, FramedSignBlockEntity sign, boolean frontText) {
        SignText text = sign.getText(frontText);
        return Arrays.stream(text.m_276945_(player.m_143387_())).allMatch(line -> line.equals(CommonComponents.f_237098_) || line.m_214077_() instanceof LiteralContents);
    }

    public static void openEditScreen(Player player, FramedSignBlockEntity sign, boolean frontText) {
        sign.setEditingPlayer(player.m_20148_());
        FramedBlocks.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenSignScreenPacket(sign.m_58899_(), frontText));
    }

    private static enum SignInteraction {
        APPLY_DYE((level, pos, player, stack, front, sign) -> {
            level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return sign.updateText(text -> text.m_276901_(((DyeItem)stack.m_41720_()).m_41089_()), front);
        }),
        APPLY_INK((level, pos, player, stack, front, sign) -> {
            level.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return sign.updateText(text -> text.m_277132_(false), front);
        }),
        APPLY_GLOW_INK((level, pos, player, stack, front, sign) -> {
            level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, stack);
            }
            return sign.updateText(text -> text.m_277132_(true), front);
        }),
        APPLY_WAX((level, pos, player, stack, front, sign) -> {
            if (sign.setWaxed(true)) {
                level.m_46796_(3003, sign.m_58899_(), 0);
                return true;
            }
            return false;
        }),
        REMOVE_WAX((level, pos, player, stack, front, sign) -> {
            if (sign.setWaxed(false)) {
                level.m_46796_(3004, sign.m_58899_(), 0);
                return true;
            }
            return false;
        });

        private final Action action;

        private SignInteraction(Action action) {
            this.action = action;
        }

        public boolean interact(Level level, BlockPos pos, Player player, ItemStack stack, boolean front, FramedSignBlockEntity sign) {
            return this.action.apply(level, pos, player, stack, front, sign);
        }

        public static SignInteraction from(ItemStack stack) {
            if (stack.m_41720_() instanceof DyeItem) {
                return APPLY_DYE;
            }
            if (stack.m_150930_(Items.f_42532_)) {
                return APPLY_INK;
            }
            if (stack.m_150930_(Items.f_151056_)) {
                return APPLY_GLOW_INK;
            }
            if (stack.m_150930_(Items.f_42784_)) {
                return APPLY_WAX;
            }
            if (stack.canPerformAction(ToolActions.AXE_WAX_OFF)) {
                return REMOVE_WAX;
            }
            return null;
        }
    }

    private static interface Action {
        public boolean apply(Level var1, BlockPos var2, Player var3, ItemStack var4, boolean var5, FramedSignBlockEntity var6);
    }
}

