/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.ICollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCollapsibleCopycatBlockEntity
extends FramedBlockEntity
implements ICollapsibleCopycatBlockEntity {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);
    private static final int MAX_OFFSET_BEACON_OCCLUSION = 5;
    public static final ModelProperty<Integer> OFFSETS = new ModelProperty();
    private int packedOffsets = 0;
    private boolean occludesBeacon = true;

    public FramedCollapsibleCopycatBlockEntity(BlockPos pos, BlockState state) {
        super(FBContent.BE_TYPE_FRAMED_COLLAPSIBLE_COPYCAT_BLOCK.get(), pos, state);
    }

    public void handleDeform(Player player) {
        HitResult hit = player.m_19907_(10.0, 1.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction faceHit = blockHit.m_82434_();
        boolean sneak = player.m_6144_();
        boolean changed = false;
        int offset = this.getFaceOffset(faceHit);
        if (sneak && offset > 0) {
            this.setFaceOffset(faceHit, offset - 1);
            changed = true;
        } else if (!sneak && offset < 15 - this.getFaceOffset(faceHit.m_122424_())) {
            this.setFaceOffset(faceHit, offset + 1);
            changed = true;
        }
        if (changed) {
            this.updateBeaconOcclusion();
            if (!this.updateFaceSolidity()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            this.m_6596_();
        }
    }

    private void setFaceOffset(Direction side, int offset) {
        int idx = side.ordinal() * 4;
        int mask = 15 << idx;
        this.packedOffsets = this.packedOffsets & ~mask | offset << idx;
    }

    public int getFaceOffset(Direction side) {
        return (byte)(this.packedOffsets >> side.ordinal() * 4 & 0xF);
    }

    @Override
    public int getFaceOffset(BlockState state, Direction side) {
        return this.getFaceOffset(side);
    }

    @Override
    public int getPackedOffsets(BlockState state) {
        return this.packedOffsets;
    }

    public boolean doesOccludeBeaconBeam() {
        return this.occludesBeacon;
    }

    public boolean updateFaceSolidity() {
        BlockState state = this.m_58900_();
        int solid = FramedCollapsibleCopycatBlockEntity.computeSolidFaces(this.packedOffsets);
        if ((Integer)state.m_61143_((Property)PropertyHolder.SOLID_FACES) != solid) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)PropertyHolder.SOLID_FACES, (Comparable)Integer.valueOf(solid)));
            return true;
        }
        return false;
    }

    private void updateBeaconOcclusion() {
        this.occludesBeacon = true;
        for (Direction face : HORIZONTAL_DIRECTIONS) {
            if (this.getFaceOffset(face) <= 5) continue;
            this.occludesBeacon = false;
            break;
        }
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(FramedBlockData.PROPERTY, (Object)this.getModelDataInternal()).with(OFFSETS, (Object)this.getPackedOffsets(this.m_58900_())).build();
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128405_("offsets", this.packedOffsets);
        nbt.m_128379_("occludesBeacon", this.occludesBeacon);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean needUpdate = super.readFromDataPacket(nbt);
        int packed = nbt.m_128451_("offsets");
        if (packed != this.packedOffsets) {
            this.packedOffsets = packed;
            needUpdate = true;
            this.updateCulling(true, false);
        }
        this.occludesBeacon = nbt.m_128471_("occludesBeacon");
        return needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("offsets", this.packedOffsets);
        nbt.m_128379_("occludesBeacon", this.occludesBeacon);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        this.packedOffsets = nbt.m_128451_("offsets");
        this.occludesBeacon = nbt.m_128471_("occludesBeacon");
        super.handleUpdateTag(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("offsets", this.packedOffsets);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.packedOffsets = nbt.m_128451_("offsets");
        this.updateBeaconOcclusion();
    }

    public static byte[] unpackOffsets(int packed) {
        byte[] offsets = new byte[DIRECTIONS.length];
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            offsets[i] = (byte)(packed >> i * 4 & 0xF);
        }
        return offsets;
    }

    public static int computeSolidFaces(int packedOffsets) {
        int solid = 0;
        for (Direction face : DIRECTIONS) {
            if ((packedOffsets >> face.ordinal() * 4 & 0xF) != 0) continue;
            solid |= 1 << face.ordinal();
        }
        return solid;
    }
}

