/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopeslab.FlatSlopeSlabCornerShapes;

public final class FlatInverseDoubleSlopeSlabCornerShapes
implements SplitShapeGenerator {
    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return FlatInverseDoubleSlopeSlabCornerShapes.generate(states, FlatSlopeSlabCornerShapes.SHAPES, FlatSlopeSlabCornerShapes.INNER_SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return FlatInverseDoubleSlopeSlabCornerShapes.generate(states, FlatSlopeSlabCornerShapes.OCCLUSION_SHAPES, FlatSlopeSlabCornerShapes.INNER_OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeSlabShape> cache, ShapeCache<SlopeSlabShape> innerCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBot = ShapeUtils.orUnoptimized(cache.get(SlopeSlabShape.BOTTOM_TOP_HALF), ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.SOUTH, innerCache.get(SlopeSlabShape.TOP_BOTTOM_HALF)));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(cache.get(SlopeSlabShape.TOP_BOTTOM_HALF), ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.SOUTH, innerCache.get(SlopeSlabShape.BOTTOM_TOP_HALF)));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBot, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

