/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.elements.ElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.ExtendedElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.ElementCategory;

public abstract class ContainerElementBuilder<T extends ContainerElementBuilder<T>>
extends ExtendedElementBuilder<T> {
    protected final List<ElementBuilder> childElements = new ArrayList<ElementBuilder>();
    private final ElementCategory allowedCat;

    protected ContainerElementBuilder(ElementCategory elemCat, String type, ElementCategory allowedCat) {
        super(elemCat, type);
        this.allowedCat = allowedCat;
    }

    public T element(ElementBuilder element) {
        if (!this.allowedCat.allows(element.getCategory())) {
            throw new IllegalArgumentException("ContainerElement '%s' does not support element '%s' with category '%s'".formatted(new Object[]{this.getClass().getSimpleName(), element.getClass().getSimpleName(), element.getCategory()}));
        }
        this.childElements.add(element);
        return (T)this;
    }

    @Override
    protected void printInternal(Document doc, Element elementElem) {
        this.childElements.forEach(child -> child.print(doc, elementElem));
    }
}

