/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.clearfluidglass.blocks.entity;

import com.scouter.clearfluidglass.blocks.entity.CFGBlockEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ClearFluidGlassBlockEntity
extends BlockEntity {
    protected static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.01, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)0.0, (double)15.99, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.01);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)15.99, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)15.99, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> occlusionShapes = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.DOWN, SHAPE_DOWN);
            this.put(Direction.UP, SHAPE_UP);
            this.put(Direction.NORTH, SHAPE_NORTH);
            this.put(Direction.EAST, SHAPE_EAST);
            this.put(Direction.SOUTH, SHAPE_SOUTH);
            this.put(Direction.WEST, SHAPE_WEST);
        }
    };
    protected VoxelShape occlusionShape = Shapes.m_83040_();
    private final List<Direction> occlusionDirs = new ArrayList<Direction>();

    public ClearFluidGlassBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CFGBlockEntities.CLEAR_FLUID_GLASS.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ListTag occlusionDirStrings = new ListTag();
        for (Direction direction : this.occlusionDirs) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("dir", direction.toString());
            occlusionDirStrings.add((Object)compoundTag);
        }
        pTag.m_128365_("occlusiondirs", (Tag)occlusionDirStrings);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        ListTag occlusionDirTag = pTag.m_128437_("occlusiondirs", 10);
        for (int i = 0; i < occlusionDirTag.size(); ++i) {
            CompoundTag dirCompoundTag = occlusionDirTag.m_128728_(i);
            String dirString = dirCompoundTag.m_128461_("dir");
            Direction direction = Direction.m_122402_((String)dirString);
            if (direction == null) continue;
            this.occlusionDirs.add(direction);
        }
        VoxelShape shape = Shapes.m_83040_();
        for (Direction direction : this.occlusionDirs) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)occlusionShapes.get(direction));
        }
        this.setOcclusionShape(shape);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        ListTag occlusionDirTag = tag.m_128437_("occlusiondirs", 10);
        for (int i = 0; i < occlusionDirTag.size(); ++i) {
            CompoundTag dirCompoundTag = occlusionDirTag.m_128728_(i);
            String dirString = dirCompoundTag.m_128461_("dir");
            Direction direction = Direction.m_122402_((String)dirString);
            if (direction == null) continue;
            this.occlusionDirs.add(direction);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        ListTag occlusionDirStrings = new ListTag();
        for (Direction direction : this.occlusionDirs) {
            CompoundTag dirTag = new CompoundTag();
            dirTag.m_128359_("dir", direction.toString());
            occlusionDirStrings.add((Object)dirTag);
        }
        compoundTag.m_128365_("occlusiondirs", (Tag)occlusionDirStrings);
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        ClearFluidGlassBlockEntity blockEntity = (ClearFluidGlassBlockEntity)this.f_58857_.m_7702_(pkt.m_131704_());
        CompoundTag tag = pkt.m_131708_();
        if (tag != null && tag.m_128425_("occlusiondirs", 10)) {
            ListTag occlusionDirTag = tag.m_128437_("occlusiondirs", 10);
            for (int i = 0; i < occlusionDirTag.size(); ++i) {
                CompoundTag dirCompoundTag = occlusionDirTag.m_128728_(i);
                String dirString = dirCompoundTag.m_128461_("dir");
                Direction direction = Direction.m_122402_((String)dirString);
                if (direction == null) continue;
                this.occlusionDirs.add(direction);
            }
            VoxelShape shape = Shapes.m_83040_();
            for (Direction direction : this.occlusionDirs) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)occlusionShapes.get(direction));
            }
            blockEntity.setOcclusionShape(shape);
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
    }

    public VoxelShape getOcclusionShape() {
        return this.occlusionShape;
    }

    public void setOcclusionShape(VoxelShape shape) {
        this.occlusionShape = shape;
    }

    public void addDirection(Direction direction) {
        this.occlusionDirs.add(direction);
    }

    public List<Direction> getOcclusionDirs() {
        return this.occlusionDirs;
    }
}

