/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.events;

import java.util.List;
import java.util.Objects;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.SlicedGourdBlock;
import net.brnbrd.delightful.common.block.SlicedMelonBlock;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class ForgeEvents {
    @SubscribeEvent
    void onWanderingTrader(WandererTradesEvent e) {
        List trades = e.getGenericTrades();
        if (Util.enabled(DelightfulItems.SALMONBERRIES) && Util.enabled(DelightfulItems.SALMONBERRY_PIPS)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), Util.gs(DelightfulItems.SALMONBERRY_PIPS), 5, 1, 1.0f));
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE) && Util.enabled(DelightfulItems.CANTALOUPE_SLICE)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), Util.gs(DelightfulItems.CANTALOUPE_SLICE, 8), 5, 1, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    void onInteract(PlayerInteractEvent.RightClickBlock e) {
        Level world = e.getLevel();
        BlockPos pos = e.getPos();
        if (e.getItemStack().m_204117_(ForgeTags.TOOLS_KNIVES)) {
            BlockState current = world.m_8055_(pos);
            boolean client = world.m_5776_();
            if (current.m_60734_() == Blocks.f_50186_) {
                SlicedMelonBlock sliced = (SlicedMelonBlock)DelightfulBlocks.SLICED_MELON.get();
                this.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (current.m_60734_() == Blocks.f_50133_ && !e.getEntity().m_6047_()) {
                SlicedGourdBlock sliced = (SlicedGourdBlock)DelightfulBlocks.SLICED_PUMPKIN.get();
                this.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (Mods.loaded("undergardendelight") && Objects.equals(ForgeRegistries.BLOCKS.getKey((Object)current.m_60734_()), Util.rl("undergarden", "gloomgourd"))) {
                SlicedGourdBlock sliced = (SlicedGourdBlock)DelightfulBlocks.SLICED_GLOOMGOURD.get();
                this.slice(sliced.m_49966_(), sliced.getSliceItem(), world, pos, SoundEvents.f_11716_, e, client);
            } else if (Mods.loaded("frozenup", "frozen_delight") && Util.name(current.m_60734_()).equals("truffle_cake") && ForgeRegistries.ITEMS.containsKey(Util.rl("frozen_delight", "truffle_cake_slice"))) {
                int currentBites = (Integer)current.m_61143_((Property)BlockStateProperties.f_61412_);
                ItemStack slice = new ItemStack((ItemLike)Objects.requireNonNull(Util.item("frozen_delight", "truffle_cake_slice")));
                if (currentBites >= 3) {
                    world.m_7471_(pos, false);
                    world.m_142346_((Entity)e.getEntity(), GameEvent.f_157794_, pos);
                    Util.dropOrGive(slice, world, pos, e.getEntity());
                    world.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.PLAYERS, 0.8f, 0.8f);
                    e.getEntity().m_21120_(e.getHand()).m_41622_(1, (LivingEntity)e.getEntity(), onBroken -> {});
                    e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
                    e.setCanceled(true);
                    return;
                }
                this.slice((BlockState)current.m_61124_((Property)BlockStateProperties.f_61412_, (Comparable)Integer.valueOf(currentBites + 1)), slice, world, pos, SoundEvents.f_12642_, e, client);
            }
        }
    }

    void slice(BlockState block, ItemStack slice, Level world, BlockPos pos, SoundEvent sound, PlayerInteractEvent.RightClickBlock e, boolean client) {
        if (!client) {
            world.m_7731_(pos, block, 2);
            Util.dropOrGive(slice, world, pos, e.getEntity());
            world.m_5594_(null, pos, sound, SoundSource.PLAYERS, 0.8f, 0.8f);
            e.getEntity().m_21120_(e.getHand()).m_41622_(1, (LivingEntity)e.getEntity(), onBroken -> {});
        }
        e.setCancellationResult(InteractionResult.m_19078_((boolean)client));
        e.setCanceled(true);
    }
}

