/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.ITradeType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public abstract class TradeProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final Map<EntityType<?>, EnumMap<TradeRarity, List<ITradeType<?>>>> trades = new HashMap();

    protected TradeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "trades");
        this.lookupProvider = lookupProvider;
    }

    protected abstract void registerTrades();

    protected final void addTrade(EntityType<?> type, TradeRarity rarity, ITradeType<?> trade) {
        this.trades.putIfAbsent(type, new EnumMap(TradeRarity.class));
        this.trades.get(type).putIfAbsent(rarity, new ArrayList());
        this.trades.get(type).get((Object)rarity).add(trade);
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return this.lookupProvider.thenCompose(provider -> {
            this.trades.clear();
            this.registerTrades();
            return CompletableFuture.allOf((CompletableFuture[])this.trades.entrySet().stream().map(e1 -> {
                EntityType type = (EntityType)e1.getKey();
                return CompletableFuture.allOf((CompletableFuture[])((EnumMap)e1.getValue()).entrySet().stream().map(e2 -> {
                    JsonObject object = new JsonObject();
                    object.addProperty("replace", Boolean.valueOf(false));
                    JsonArray tradeArray = new JsonArray();
                    ((List)e2.getValue()).forEach(trade -> tradeArray.add((JsonElement)trade.serialize()));
                    object.add("trades", (JsonElement)tradeArray);
                    ResourceLocation id = EntityType.m_20613_((EntityType)type);
                    Path path = this.pathProvider.m_245731_(new ResourceLocation(id.m_135827_(), id.m_135815_() + "/" + ((TradeRarity)((Object)((Object)((Object)((Object)e2.getKey()))))).getKey()));
                    return DataProvider.m_253162_((CachedOutput)output, (JsonElement)object, (Path)path);
                }).toArray(CompletableFuture[]::new));
            }).toArray(CompletableFuture[]::new));
        });
    }

    public String m_6055_() {
        return "Trades: goblintraders";
    }
}

