/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network;

import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Constants;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerPlayHelper {
    public static void sendMessageToOperators(Component message, ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        Preconditions.checkNotNull((Object)server, (Object)"The server was null when broadcasting config changes. This should not be possible...");
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            if (!server.m_6846_().m_11303_(serverPlayer.m_36316_())) continue;
            serverPlayer.m_213846_(message);
        }
    }

    public static boolean canEditServerConfigs(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null || !server.m_6982_() || !Config.isDeveloperEnabled()) {
            Constants.LOG.warn("{} tried to request or update a server config, however developer mode is not enabled", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.unauthorized_request"));
            ServerPlayHelper.sendMessageToOperators((Component)Component.m_237115_((String)"configured.chat.authorized_player").m_130940_(ChatFormatting.RED), player);
            return false;
        }
        if (!Config.getDevelopers().contains(player.m_20149_()) || !server.m_6846_().m_11303_(player.m_36316_())) {
            Constants.LOG.warn("{} tried to request or update a server config, however they are not a developer", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.unauthorized_request"));
            ServerPlayHelper.sendMessageToOperators((Component)Component.m_237115_((String)"configured.chat.authorized_player").m_130940_(ChatFormatting.RED), player);
            return false;
        }
        return true;
    }
}

