/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.common.base.Stopwatch;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.mixin.DatagenModLoaderAccessor;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.data.event.GatherDataEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={DataGenerator.class})
public class DataGeneratorMixin {
    @Shadow
    @Final
    private static Logger f_123905_;
    @Unique
    private ResourceCache resourceCache;
    @Shadow
    @Final
    private Map<String, DataProvider> f_236026_;
    @Shadow
    @Final
    private boolean f_236028_;
    @Shadow
    @Final
    private WorldVersion f_236027_;
    @Shadow
    @Final
    private Set<String> f_252429_;

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lcom/google/common/base/Stopwatch;createStarted()Lcom/google/common/base/Stopwatch;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runHead(CallbackInfo ci, HashCache hashCache) {
        GatherDataEvent.DataGeneratorConfig dataGeneratorConfig = DatagenModLoaderAccessor.getDataGeneratorConfig();
        if (dataGeneratorConfig != null) {
            dataGeneratorConfig.getMods().stream().filter(GeneratorRegistrationHandler::hasHandlerForModid).forEach(modid -> {
                GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get(modid);
                DataGenerator dataGenerator = (DataGenerator)this;
                Path outputFolder = dataGenerator.f_243753_;
                if (this.resourceCache == null) {
                    this.resourceCache = ResourceCache.wrap(DatagenModLoaderAccessor.getExistingFileHelper(), hashCache, outputFolder);
                }
                ((ResourceCache.HashCacheWrapper)this.resourceCache).allowWrites(false);
                handler.registerProviders(dataGenerator, DatagenModLoaderAccessor.getExistingFileHelper(), this.resourceCache);
                for (String provider : this.f_252429_) {
                    Path cachePath = hashCache.m_252859_(provider);
                    hashCache.f_236084_.add(cachePath);
                    HashCache.ProviderCache providerCache = HashCache.m_236092_((Path)outputFolder, (Path)cachePath);
                    hashCache.f_252445_.put(provider, providerCache);
                    hashCache.f_236085_ += providerCache.m_236133_();
                }
            });
        }
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).readHashCache();
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lcom/google/common/base/Stopwatch;createUnstarted()Lcom/google/common/base/Stopwatch;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runBeforeGenerators(CallbackInfo ci, HashCache hashCache) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        for (Map.Entry<String, DataProvider> entry : this.f_236026_.entrySet()) {
            if (!this.f_236028_ && !hashCache.m_253256_(entry.getKey())) {
                f_123905_.debug("Generator {} already run for version {}", (Object)entry.getKey(), (Object)this.f_236027_.m_132493_());
                return;
            }
            if (!(entry.getValue() instanceof ResourceGenerator.DataProviderInstance)) continue;
            f_123905_.info("Running generator: {}", (Object)entry.getKey());
            stopwatch.start();
            ((ResourceGenerator.DataProviderInstance)entry.getValue()).generate();
            stopwatch.stop();
            f_123905_.info("{} finished after {} ms", (Object)entry.getKey(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset();
        }
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).allowWrites(true);
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/HashCache;purgeStaleAndWrite()V", shift=At.Shift.BEFORE)})
    private void runTail(CallbackInfo ci) {
        if (this.resourceCache != null) {
            ((ResourceCache.HashCacheWrapper)this.resourceCache).finish();
        }
    }
}

