/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.util;

import java.util.Objects;

@FunctionalInterface
public interface TriPredicate<X, Y, Z> {
    public boolean test(X var1, Y var2, Z var3);

    default public TriPredicate<X, Y, Z> and(TriPredicate<? super X, ? super Y, ? super Z> other) {
        Objects.requireNonNull(other);
        return (x, y, z) -> this.test(x, y, z) && other.test(x, y, z);
    }

    default public TriPredicate<X, Y, Z> negate() {
        return (x, y, z) -> !this.test(x, y, z);
    }

    default public TriPredicate<X, Y, Z> or(TriPredicate<? super X, ? super Y, ? super Z> other) {
        Objects.requireNonNull(other);
        return (x, y, z) -> this.test(x, y, z) || other.test(x, y, z);
    }
}

