/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.pipez.ModelRegistry;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.corelib.CachedValue;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class PipeRenderer
implements BlockEntityRenderer<PipeTileEntity> {
    protected Minecraft minecraft;
    protected BlockEntityRendererProvider.Context renderer;
    protected CachedValue<BakedModel> cachedModel;

    public PipeRenderer(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
        this.minecraft = Minecraft.m_91087_();
        this.cachedModel = this.getModel().getCachedModel();
    }

    public void render(PipeTileEntity pipe, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BakedModel iBakedModel = this.cachedModel.get();
        List quads = iBakedModel.getQuads(null, null, this.minecraft.f_91073_.f_46441_, ModelData.EMPTY, RenderType.m_110451_());
        VertexConsumer b = buffer.m_6299_(RenderType.m_110451_());
        for (Direction side : Direction.values()) {
            if (!pipe.isExtracting(side)) continue;
            this.renderExtractor(side, matrixStack, b, quads, combinedLight, combinedOverlay);
        }
    }

    private void renderExtractor(Direction direction, PoseStack matrixStack, VertexConsumer b, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)direction.m_122429_() * 0.001, (double)direction.m_122430_() * 0.001, (double)direction.m_122431_() * 0.001);
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_252781_(this.getRotation(direction));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        for (BakedQuad quad : quads) {
            b.m_85987_(matrixStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
        }
        matrixStack.m_85849_();
    }

    private Quaternionf getRotation(Direction direction) {
        Quaternionf q = new Quaternionf();
        switch (direction) {
            case NORTH: {
                return q;
            }
            case SOUTH: {
                q.mul((Quaternionfc)Axis.f_252436_.m_252977_(180.0f));
                return q;
            }
            case WEST: {
                q.mul((Quaternionfc)Axis.f_252436_.m_252977_(90.0f));
                return q;
            }
            case EAST: {
                q.mul((Quaternionfc)Axis.f_252436_.m_252977_(270.0f));
                return q;
            }
            case UP: {
                q.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
                return q;
            }
        }
        q.mul((Quaternionfc)Axis.f_252529_.m_252977_(270.0f));
        return q;
    }

    abstract ModelRegistry.Model getModel();
}

