/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.net;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.net.Message;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.IPipeContainer;
import de.maxhenkel.pipez.gui.containerfactory.PipeContainerProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class UpdateFilterMessage
implements Message<UpdateFilterMessage> {
    private CompoundTag filter;
    private int index;

    public UpdateFilterMessage() {
    }

    public UpdateFilterMessage(Filter<?> filter, int index) {
        this.filter = filter.serializeNBT();
        this.index = index;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        AbstractContainerMenu container = context.getSender().f_36096_;
        if (container instanceof IPipeContainer) {
            IPipeContainer pipeContainer = (IPipeContainer)container;
            PipeType<?>[] pipeTypes = pipeContainer.getPipe().getPipeTypes();
            if (this.index >= pipeTypes.length) {
                return;
            }
            PipeType<?> pipeType = pipeTypes[this.index];
            Filter<?> f = pipeType.createFilter();
            f.deserializeNBT(this.filter);
            List<Filter<?>> filters = pipeContainer.getPipe().getFilters(pipeContainer.getSide(), pipeType);
            Optional<Filter> editFilter = filters.stream().filter(f1 -> f.getId().equals(f1.getId())).findFirst();
            if (editFilter.isPresent()) {
                editFilter.get().deserializeNBT(this.filter);
            } else {
                filters.add(f);
            }
            pipeContainer.getPipe().setFilters(pipeContainer.getSide(), pipeType, filters);
            PipeContainerProvider.openGui((Player)context.getSender(), pipeContainer.getPipe(), pipeContainer.getSide(), this.index, (id, playerInventory, playerEntity) -> new ExtractContainer(id, (Container)playerInventory, pipeContainer.getPipe(), pipeContainer.getSide(), this.index));
        }
    }

    @Override
    public UpdateFilterMessage fromBytes(FriendlyByteBuf packetBuffer) {
        this.filter = packetBuffer.m_130260_();
        this.index = packetBuffer.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.filter);
        packetBuffer.writeInt(this.index);
    }
}

