/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.compat;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Method;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.SodiumBufferBuilder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.apache.logging.log4j.util.TriConsumer;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class SodiumGetBufferInjector {
    private static final TriConsumer<MultiBufferSource, RenderType, VertexConsumer> INSTANCE = SodiumGetBufferInjector.get();

    public static void inject(MultiBufferSource provider, RenderType renderLayer, VertexConsumer vertexConsumer) {
        if (INSTANCE != null) {
            INSTANCE.accept((Object)provider, (Object)renderLayer, (Object)vertexConsumer);
        }
    }

    private static TriConsumer<MultiBufferSource, RenderType, VertexConsumer> get() {
        try {
            return new Impl();
        }
        catch (NoClassDefFoundError | NoSuchMethodError | NullPointerException ignored) {
            ETFUtils2.logWarn("ETF compatibility method for sodium versions prior to 0.5.9 failed, this is fine if you are using a newer sodium or if it isn't installed at all");
            return null;
        }
    }

    private static class Impl
    implements TriConsumer<MultiBufferSource, RenderType, VertexConsumer> {
        Impl() {
            Objects.requireNonNull(ExtendedBufferBuilder.class);
            Method[] methods = ExtendedBufferBuilder.class.getMethods();
            boolean found = false;
            for (Method method : methods) {
                if (!method.getName().equals("sodium$getDelegate")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new NoSuchMethodError("Method sodium$getDelegate not found");
            }
        }

        public void accept(MultiBufferSource vertexConsumerProvider, RenderType renderLayer, VertexConsumer vertexConsumer) {
            ExtendedBufferBuilder buff;
            SodiumBufferBuilder delegate;
            if (vertexConsumer instanceof ExtendedBufferBuilder && (delegate = (buff = (ExtendedBufferBuilder)vertexConsumer).sodium$getDelegate()) instanceof ETFVertexConsumer) {
                ETFRenderContext.insertETFDataIntoVertexConsumer(vertexConsumerProvider, renderLayer, (VertexConsumer)delegate);
            }
        }
    }
}

