/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.armortrim.ArmorTrim;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFArmorHandler {
    private ETFTexture texture = null;
    private ETFTexture trimTexture = null;

    public void start() {
        ETFRenderContext.preventRenderLayerTextureModify();
    }

    public void end() {
        ETFRenderContext.allowRenderLayerTextureModify();
    }

    public ResourceLocation getBaseTexture(ResourceLocation vanilla) {
        if (ETF.config().getConfig().enableArmorAndTrims) {
            this.texture = ETFManager.getInstance().getETFTextureNoVariation(vanilla);
            if (this.texture != null) {
                return this.texture.getTextureIdentifier(null);
            }
        }
        return vanilla;
    }

    public void renderBaseEmissive(PoseStack matrices, MultiBufferSource vertexConsumers, Model model, float red, float green, float blue) {
        ResourceLocation emissive;
        if (this.texture != null && ETF.config().getConfig().canDoEmissiveTextures() && (emissive = this.texture.getEmissiveIdentifierOfCurrentState()) != null) {
            VertexConsumer textureVert = vertexConsumers.m_6299_(RenderType.m_110431_((ResourceLocation)emissive));
            ETFRenderContext.startSpecialRenderOverlayPhase();
            if (ETF.IRIS_DETECTED) {
                matrices.m_85841_(1.001f, 1.001f, 1.001f);
            }
            model.m_7695_(matrices, textureVert, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            ETFRenderContext.startSpecialRenderOverlayPhase();
        }
    }

    public void setTrim(ArmorMaterial armorMaterial, ArmorTrim trim, boolean leggings) {
        if (ETF.config().getConfig().enableArmorAndTrims) {
            ResourceLocation trimBaseId = leggings ? trim.m_267774_(armorMaterial) : trim.m_267606_(armorMaterial);
            ResourceLocation trimMaterialIdentifier = ETFUtils2.res(trimBaseId.m_135827_(), "textures/" + trimBaseId.m_135815_() + ".png");
            this.trimTexture = ETFManager.getInstance().getETFTextureNoVariation(trimMaterialIdentifier);
        }
    }

    public void renderTrimEmissive(PoseStack matrices, MultiBufferSource vertexConsumers, Model model) {
        ResourceLocation emissive;
        if (this.trimTexture != null && ETF.config().getConfig().canDoEmissiveTextures() && (emissive = this.trimTexture.getEmissiveIdentifierOfCurrentState()) != null) {
            VertexConsumer textureVert = vertexConsumers.m_6299_(RenderType.m_110431_((ResourceLocation)emissive));
            ETFRenderContext.startSpecialRenderOverlayPhase();
            if (ETF.IRIS_DETECTED) {
                matrices.m_85841_(1.001f, 1.001f, 1.001f);
            }
            model.m_7695_(matrices, textureVert, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }
}

