/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame.tab;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import org.embeddedt.embeddium.gui.frame.tab.Tab;

public class TabHeaderWidget
extends FlatButtonWidget {
    private static final ResourceLocation FALLBACK_LOCATION = new ResourceLocation("textures/misc/unknown_pack.png");
    private static final Set<String> erroredLogos = new HashSet<String>();
    private final ResourceLocation logoTexture;

    public static MutableComponent getLabel(String modId) {
        return (switch (modId) {
            case "sspb" -> Component.m_237113_((String)"SSPB");
            default -> Tab.idComponent(modId);
        }).m_130938_(s -> s.m_131162_(Boolean.valueOf(true)));
    }

    public TabHeaderWidget(Dim2i dim, String modId) {
        super(dim, (Component)TabHeaderWidget.getLabel(modId), () -> {});
        Optional logoFile = erroredLogos.contains(modId) ? Optional.empty() : ModList.get().getModContainerById(modId).flatMap(c -> c.getModInfo().getLogoFile());
        ResourceLocation texture = null;
        if (logoFile.isPresent()) {
            PathPackResources resourcePack = ResourcePackLoader.getPackFor((String)modId).orElse((PathPackResources)ResourcePackLoader.getPackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                IoSupplier logoResource = resourcePack.m_8017_(new String[]{(String)logoFile.get()});
                if (logoResource != null) {
                    NativeImage logo = NativeImage.m_85058_((InputStream)((InputStream)logoResource.m_247737_()));
                    if (logo.m_84982_() != logo.m_85084_()) {
                        logo.close();
                        throw new IOException("Logo " + (String)logoFile.get() + " for " + modId + " is not square");
                    }
                    texture = new ResourceLocation("xenon", "logo/" + modId);
                    Minecraft.m_91087_().f_90987_.m_118495_(texture, (AbstractTexture)new DynamicTexture(logo));
                }
            }
            catch (IOException e) {
                erroredLogos.add(modId);
                SodiumClientMod.logger().error("Exception reading logo for " + modId, (Throwable)e);
            }
        }
        this.logoTexture = texture;
    }

    @Override
    protected int getLeftAlignedTextOffset() {
        int n = super.getLeftAlignedTextOffset();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return n + 9;
    }

    @Override
    protected boolean isHovered(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.m_88315_(drawContext, mouseX, mouseY, delta);
        ResourceLocation icon = Objects.requireNonNullElse(this.logoTexture, FALLBACK_LOCATION);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int fontHeight = 9;
        int imgY = this.dim.getCenterY() - fontHeight / 2;
        drawContext.m_280163_(icon, this.dim.x() + 5, imgY, 0.0f, 0.0f, fontHeight, fontHeight, fontHeight, fontHeight);
    }
}

