/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import tech.thatgravyboat.creeperoverhaul.common.config.SpawningConfig;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.custom.PufferfishCreeper;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModItems;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSounds;

public class CreeperTypes {
    public static final CreeperType JUNGLE = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/jungle/jungle_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/jungle/jungle_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor.png")).setModel(CreeperTypes.modLoc("geo/jungle.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).setDeathSounds(ModSounds.PLANT_DEATH).setExplosionSounds(ModSounds.PLANT_EXPLOSION).setHurtSounds(ModSounds.PLANT_HURT).setPrimeSounds(ModSounds.PLANT_PRIME).setCanSpawn(() -> SpawningConfig.allowJungleCreeperSpawning).build();
    public static final CreeperType BAMBOO = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/bamboo/bamboo_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/bamboo/bamboo_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor.png")).setModel(CreeperTypes.modLoc("geo/bamboo.geo.json")).setAnimation(CreeperTypes.modLoc("animations/bamboo.animation.json")).setMelee(9).addAfraidOf(EntityType.f_20507_).addAttribute(Attributes.f_22276_, 15.0).addAttribute(Attributes.f_22281_, 2.0).addAttribute("reach_distance", 2.0).setDeathSounds(ModSounds.PLANT_DEATH).setExplosionSounds(ModSounds.PLANT_EXPLOSION).setHitSounds(ModSounds.PLANT_HIT).setHurtSounds(ModSounds.PLANT_HURT).setPrimeSounds(ModSounds.PLANT_PRIME).setCanSpawn(() -> SpawningConfig.allowBambooCreeperSpawning).build();
    public static final CreeperType DESERT = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/desert/desert_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/desert/desert_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/desert.geo.json")).setShearedModel(CreeperTypes.modLoc("geo/desert_sheared.geo.json")).setShearable(() -> new ItemStack((ItemLike)ModItems.TINY_CACTUS.get())).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addAttribute(Attributes.f_22278_, 0.5).setDeathSounds(ModSounds.SAND_DEATH).setExplosionSounds(ModSounds.SAND_EXPLOSION).setHurtSounds(ModSounds.SAND_HURT).setPrimeSounds(ModSounds.SAND_PRIME).setCanSpawn(() -> SpawningConfig.allowDesertCreeperSpawning).build();
    public static final CreeperType BADLANDS = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/badlands/badlands_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/badlands/badlands_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/badlands.geo.json")).setShearedModel(CreeperTypes.modLoc("geo/badlands_sheared.geo.json")).setShearable(() -> new ItemStack((ItemLike)ModItems.TINY_CACTUS.get())).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addAttribute(Attributes.f_22276_, 30.0).addAttribute(Attributes.f_22278_, 1.0).setDeathSounds(ModSounds.SAND_DEATH).setExplosionSounds(ModSounds.SAND_EXPLOSION).setHurtSounds(ModSounds.SAND_HURT).setPrimeSounds(ModSounds.SAND_PRIME).setCanSpawn(() -> SpawningConfig.allowBadlandsCreeperSpawning).build();
    public static final CreeperType HILLS = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/hills/hills_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/hills/hills_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/hills.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAttribute(Attributes.f_22276_, 30.0).addAttribute(Attributes.f_22278_, 0.5).setDeathSounds(ModSounds.STONE_DEATH).setExplosionSounds(ModSounds.STONE_EXPLOSION).setHurtSounds(ModSounds.STONE_HURT).setPrimeSounds(ModSounds.STONE_PRIME).setCanSpawn(() -> SpawningConfig.allowHillsCreeperSpawning).build();
    public static final CreeperType SAVANNAH = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/savannah/savannah_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/savannah/savannah_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_3.png")).setModel(CreeperTypes.modLoc("geo/savannah.geo.json")).setAnimation(CreeperTypes.modLoc("animations/savannah.animation.json")).setMelee(5).addAttribute(Attributes.f_22276_, 25.0).addAttribute(Attributes.f_22278_, 0.5).addAttribute(Attributes.f_22281_, 3.0).setDeathSounds(ModSounds.WOOD_DEATH).setExplosionSounds(ModSounds.WOOD_EXPLOSION).setHurtSounds(ModSounds.WOOD_HURT).setHitSounds(ModSounds.WOOD_HIT).setPrimeSounds(ModSounds.WOOD_PRIME).setCanSpawn(() -> SpawningConfig.allowSavannahCreeperSpawning).build();
    public static final CreeperType MUSHROOM = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/mushroom/mushroom_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/mushroom/mushroom_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_4.png")).setModel(CreeperTypes.modLoc("geo/mushroom.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addPotionsWhenDying(new MobEffectInstance(MobEffects.f_19614_, 100, 1)).addReplacer(state -> state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_), random -> random.m_188503_(3) == 0 ? Blocks.f_50195_.m_49966_() : null).setDeathSounds(ModSounds.PLANT_DEATH).setExplosionSounds(ModSounds.PLANT_EXPLOSION).setHurtSounds(ModSounds.PLANT_HURT).setPrimeSounds(ModSounds.PLANT_PRIME).setCanSpawn(() -> SpawningConfig.allowMushroomCreeperSpawning).build();
    public static final CreeperType SWAMP = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/swamp/swamp_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/swamp/swamp_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor.png")).setModel(CreeperTypes.modLoc("geo/swamp.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addAttribute("swim_speed", 2.0).setDeathSounds(ModSounds.PLANT_DEATH).setExplosionSounds(ModSounds.PLANT_EXPLOSION).setHurtSounds(ModSounds.PLANT_HURT).setPrimeSounds(ModSounds.PLANT_PRIME).setCanSpawn(() -> SpawningConfig.allowSwampCreeperSpawning).build();
    public static final CreeperType DRIPSTONE = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/dripstone/dripstone_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/dripstone/dripstone_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/dripstone.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addAttribute(Attributes.f_22276_, 12.0).setDeathSounds(ModSounds.STONE_DEATH).setExplosionSounds(ModSounds.STONE_EXPLOSION).setHurtSounds(ModSounds.STONE_HURT).setPrimeSounds(ModSounds.STONE_PRIME).setCanSpawn(() -> SpawningConfig.allowDripstoneCreeperSpawning).build();
    public static final CreeperType CAVE = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/cave/cave_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/cave/cave_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/cave.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addAttribute(Attributes.f_22276_, 25.0).addAttribute(Attributes.f_22278_, 0.5).addReplacer(state -> state.m_60713_(Blocks.f_50069_), random -> random.m_188503_(100) == 0 ? Blocks.f_49997_.m_49966_() : null).setDeathSounds(ModSounds.STONE_DEATH).setExplosionSounds(ModSounds.STONE_EXPLOSION).setHurtSounds(ModSounds.STONE_HURT).setPrimeSounds(ModSounds.STONE_PRIME).setCanSpawn(() -> SpawningConfig.allowCaveCreeperSpawning).build();
    public static final CreeperType DARK_OAK = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/dark_oak/dark_oak_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/dark_oak/dark_oak_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_3.png")).setModel(CreeperTypes.modLoc("geo/dark_oak.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addInflictingPotion(new MobEffectInstance(MobEffects.f_19610_, 100, 0)).setDeathSounds(ModSounds.WOOD_DEATH).setExplosionSounds(ModSounds.WOOD_EXPLOSION).setHurtSounds(ModSounds.WOOD_HURT).setPrimeSounds(ModSounds.WOOD_PRIME).setCanSpawn(() -> SpawningConfig.allowDarkOakCreeperSpawning).build();
    public static final CreeperType SPRUCE = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/spruce/spruce_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/spruce/spruce_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/spruce.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addReplacer(state -> state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_), random -> random.m_188503_(3) == 0 ? Blocks.f_50599_.m_49966_() : null).setDeathSounds(ModSounds.STONE_DEATH).setExplosionSounds(ModSounds.STONE_EXPLOSION).setHurtSounds(ModSounds.STONE_HURT).setPrimeSounds(ModSounds.STONE_PRIME).setCanSpawn(() -> SpawningConfig.allowSpruceCreeperSpawning).build();
    public static final CreeperType BEACH = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/beach/beach_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/beach/beach_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_2.png")).setModel(CreeperTypes.modLoc("geo/beach.geo.json")).setAnimation(CreeperTypes.modLoc("animations/creeper.animation.json")).addAfraidOf(EntityType.f_20553_).addAfraidOf(EntityType.f_20505_).addAttribute(Attributes.f_22276_, 15.0).addAttribute("swim_speed", 2.0).setDeathSounds(ModSounds.SAND_DEATH).setExplosionSounds(ModSounds.SAND_EXPLOSION).setHurtSounds(ModSounds.SAND_HURT).setPrimeSounds(ModSounds.SAND_PRIME).setCanSpawn(() -> SpawningConfig.allowBeachCreeperSpawning).build();
    public static final CreeperType SNOWY = new CreeperType.Builder().setTexture(CreeperTypes.modLoc("textures/entity/snowy/snowy_creeper.png")).setGlowingTexture(CreeperTypes.modLoc("textures/entity/snowy/snowy_creeper_glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor.png")).setModel(CreeperTypes.modLoc("geo/snowy.geo.json")).setAnimation(CreeperTypes.modLoc("animations/snowy.animation.json")).setMelee(5).addAttribute(Attributes.f_22281_, 4.0).addAttackingEntities(Stray.class).setCanSpawn(() -> SpawningConfig.allowSnowyCreeperSpawning).build();
    public static final CreeperType OCEAN = new CreeperType.Builder().setTexture(creeper -> {
        if (creeper instanceof PufferfishCreeper) {
            PufferfishCreeper pufferfish = (PufferfishCreeper)((Object)creeper);
            int id = pufferfish.getPuffId();
            PufferfishCreeper.Variant variant = pufferfish.getVariant();
            return CreeperTypes.modLoc("textures/entity/ocean/" + variant.name().toLowerCase(Locale.ROOT) + "_" + id + ".png");
        }
        return CreeperTypes.modLoc("textures/entity/ocean/brown_1.png");
    }).setGlowingTexture(CreeperTypes.modLoc("textures/entity/ocean/glow.png")).setChargedTexture(CreeperTypes.modLoc("textures/entity/armor/creeper_armor_4.png")).setModel(creeper -> {
        if (creeper instanceof PufferfishCreeper) {
            PufferfishCreeper pufferfish = (PufferfishCreeper)((Object)creeper);
            int id = pufferfish.getPuffId();
            return CreeperTypes.modLoc("geo/ocean_" + id + ".geo.json");
        }
        return CreeperTypes.modLoc("geo/ocean_1.geo.json");
    }).setAnimation(CreeperTypes.modLoc("animations/ocean.animation.json")).addAttribute(Attributes.f_22276_, 16.0).addAttribute(Attributes.f_22279_, 1.7).addAttribute("reach_distance", 3.0).addAttribute("swim_speed", 1.7).setDeathSounds(ModSounds.OCEAN_DEATH).setHurtSound(creeper -> {
        PufferfishCreeper fish;
        if (creeper instanceof PufferfishCreeper && (fish = (PufferfishCreeper)((Object)creeper)).getPuffId() == 3) {
            return ModSounds.OCEAN_HURT_INFLATED.get();
        }
        return ModSounds.OCEAN_HURT_DEFLATED.get();
    }).setFlopSounds(() -> SoundEvents.f_12293_).setCanSpawn(() -> SpawningConfig.allowOceanCreeperSpawning).build();

    private static ResourceLocation modLoc(String string) {
        return new ResourceLocation("creeperoverhaul", string);
    }
}

