/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.event;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.event.KeybindHandler;
import com.chaosthedude.notes.gui.SelectNoteScreen;
import com.chaosthedude.notes.util.RenderUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="notes", value={Dist.CLIENT})
public class TickHandler {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (KeybindHandler.OPEN_NOTES.m_90857_()) {
            CLIENT.m_91152_((Screen)new SelectNoteScreen(TickHandler.CLIENT.f_91080_));
        }
    }

    @SubscribeEvent
    public void onRenderTick(RenderGuiEvent.Post event) {
        if (!TickHandler.CLIENT.f_91066_.f_92062_ && (TickHandler.CLIENT.f_91080_ == null || TickHandler.CLIENT.f_91080_ instanceof ChatScreen) && Notes.pinnedNote != null && Notes.pinnedNote.isValidScope()) {
            Notes.pinnedNote.update();
            int maxWidth = Mth.m_14107_((double)((double)CLIENT.m_91268_().m_85445_() * (Double)ConfigHandler.CLIENT.pinnedWidthScale.get()));
            int maxHeight = Mth.m_14107_((double)((double)CLIENT.m_91268_().m_85446_() * (Double)ConfigHandler.CLIENT.pinnedHeightScale.get()));
            String text = Notes.pinnedNote.getFilteredText();
            List<String> widthSplitLines = RenderUtils.splitStringToWidth(text, maxWidth);
            List<String> lines = RenderUtils.splitStringToHeight(widthSplitLines, maxHeight);
            if (widthSplitLines.size() > lines.size()) {
                String lastLine = lines.get(lines.size() - 1);
                lines.set(lines.size() - 1, RenderUtils.addEllipses(lastLine, maxWidth));
            }
            int renderWidth = RenderUtils.getSplitStringWidth(lines);
            int renderHeight = RenderUtils.getSplitStringHeight(lines);
            int renderX = RenderUtils.getPinnedNoteX((String)ConfigHandler.CLIENT.pinnedNotePosition.get(), renderWidth);
            int renderY = RenderUtils.getPinnedNoteY((String)ConfigHandler.CLIENT.pinnedNotePosition.get(), renderHeight);
            int opacity = (int)(255.0 * (Double)TickHandler.CLIENT.f_91066_.m_232104_().m_231551_());
            event.getGuiGraphics().m_280509_(renderX - 5, renderY - 5, renderX + renderWidth + 5, renderY + renderHeight + 5, opacity << 24);
            RenderUtils.renderSplitString(event.getGuiGraphics(), lines, renderX, renderY, 0xFFFFFF);
        }
    }
}

