/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.SelectNoteScreen;
import com.chaosthedude.notes.note.Note;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotesListEntry
extends ObjectSelectionList.Entry<NotesListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private final Minecraft mc;
    private final SelectNoteScreen parentScreen;
    private final Note note;
    private final NotesList notesList;
    private long lastClickTime;

    public NotesListEntry(NotesList notesList, Note note) {
        this.notesList = notesList;
        this.note = note;
        this.parentScreen = notesList.getParentScreen();
        this.mc = Minecraft.m_91087_();
    }

    public void m_6311_(GuiGraphics guiGraphics, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        guiGraphics.m_280488_(this.mc.f_91062_, this.note.getTitle(), par3 + 1, par2 + 1, 0xFFFFFF);
        guiGraphics.m_280488_(this.mc.f_91062_, this.note.getScope().format(), par3 + 4 + this.mc.f_91062_.m_92895_(this.note.getTitle()), par2 + 1, 0x808080);
        if (this.note.isPinned()) {
            guiGraphics.m_280488_(this.mc.f_91062_, I18n.m_118938_((String)"notes.pinned", (Object[])new Object[0]), par3 + 4 + this.mc.f_91062_.m_92895_(this.note.getTitle()) + this.mc.f_91062_.m_92895_(this.note.getScope().format()) + 4, par2 + 1, 0xFFFFFF);
        }
        guiGraphics.m_280488_(this.mc.f_91062_, this.note.getTitle(), par3 + 1, par2 + 1, 0xFFFFFF);
        Font font = this.mc.f_91062_;
        String string = this.note.getPreview(Mth.m_14107_((double)((double)this.notesList.m_5759_() * 0.9)));
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280488_(font, string, par3 + 1, par2 + 9 + 3, 0x808080);
        Font font2 = this.mc.f_91062_;
        String string2 = this.note.getLastModifiedString();
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280488_(font2, string2, par3 + 1, par2 + 9 + 14, 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int button) {
        if (button == 0) {
            this.notesList.selectNote(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.loadNote();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
        }
        return false;
    }

    public void editNote() {
        if (((Boolean)ConfigHandler.CLIENT.useInGameEditor.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.m_91152_((Screen)new EditNoteScreen(this.parentScreen, this.note));
        }
    }

    public void copyNote() {
        this.note.copy();
        this.notesList.refreshList();
    }

    public void loadNote() {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        if (((Boolean)ConfigHandler.CLIENT.useInGameViewer.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.m_91152_((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
        }
    }

    public void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
        } else {
            Notes.pinnedNote = this.note;
            this.mc.m_91152_(null);
        }
    }

    public boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    public Note getNote() {
        return this.note;
    }

    public void deleteNote() {
        this.mc.m_91152_((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.mc.m_91152_((Screen)this.parentScreen);
        }, (Component)Component.m_237115_((String)"notes.confirmDelete"), (Component)Component.m_237113_((String)this.note.getTitle())));
    }

    public Component m_142172_() {
        return Component.m_237113_((String)this.note.getTitle());
    }
}

