/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.NotesListEntry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectNoteScreen
extends Screen {
    private Screen prevScreen;
    private NotesButton newButton;
    private NotesButton selectButton;
    private NotesButton editButton;
    private NotesButton copyButton;
    private NotesButton deleteButton;
    private NotesButton pinButton;
    private NotesButton cancelButton;
    private NotesList selectionList;

    public SelectNoteScreen(Screen prevScreen) {
        super((Component)Component.m_237115_((String)"notes.selectNote"));
        this.prevScreen = prevScreen;
    }

    public void m_7856_() {
        this.setupButtons();
        this.selectionList = new NotesList(this, this.f_96541_, this.f_96543_ + 110, this.f_96544_, 40, this.f_96544_ - 64, 36);
        this.m_142416_((GuiEventListener)this.selectionList);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.selectionList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"notes.selectNote", (Object[])new Object[0]), this.f_96543_ / 2 + 60, 15, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        if (this.selectionList.m_93511_() != null) {
            this.pinButton.m_93666_((Component)(((NotesListEntry)this.selectionList.m_93511_()).isPinned() ? Component.m_237115_((String)"notes.unpin") : Component.m_237115_((String)"notes.pin")));
        }
    }

    public void selectNote(NotesListEntry entry) {
        boolean enable;
        this.selectButton.f_93623_ = enable = entry != null;
        this.deleteButton.f_93623_ = enable;
        this.editButton.f_93623_ = enable;
        this.copyButton.f_93623_ = enable;
        this.pinButton.f_93623_ = enable;
    }

    private void setupButtons() {
        this.newButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)Component.m_237115_((String)"notes.new"), onPress -> this.f_96541_.m_91152_((Screen)new EditNoteScreen(this, null))));
        this.selectButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 75, 110, 20, (Component)Component.m_237115_((String)"notes.select"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            if (notesEntry != null) {
                notesEntry.loadNote();
            }
        }));
        this.editButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 100, 110, 20, (Component)Component.m_237115_((String)"notes.edit"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            if (notesEntry != null) {
                notesEntry.editNote();
            }
        }));
        this.copyButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 125, 110, 20, (Component)Component.m_237115_((String)"notes.copy"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            notesEntry.copyNote();
        }));
        this.deleteButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 150, 110, 20, (Component)Component.m_237115_((String)"notes.delete"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            if (notesEntry != null) {
                notesEntry.deleteNote();
            }
        }));
        this.pinButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 175, 110, 20, (Component)Component.m_237115_((String)"notes.pin"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.m_93511_();
            notesEntry.togglePin();
        }));
        this.cancelButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, this.f_96544_ - 30, 110, 20, (Component)Component.m_237115_((String)"gui.cancel"), onPress -> this.f_96541_.m_91152_(this.prevScreen)));
        this.selectButton.f_93623_ = false;
        this.deleteButton.f_93623_ = false;
        this.editButton.f_93623_ = false;
        this.copyButton.f_93623_ = false;
        this.pinButton.f_93623_ = false;
    }
}

