/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class RenderUtils {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static List<String> splitStringToWidth(String str, int maxWidth) {
        ArrayList<String> splitStrings = new ArrayList<String>();
        for (FormattedText text : RenderUtils.CLIENT.f_91062_.m_92865_().m_92432_(str, maxWidth, Style.f_131099_)) {
            splitStrings.add(text.getString());
        }
        return splitStrings;
    }

    public static List<String> splitStringToHeight(List<String> widthSplitStrings, int maxHeight) {
        ArrayList<String> splitStrings = new ArrayList<String>();
        int height = 0;
        for (String line : widthSplitStrings) {
            Objects.requireNonNull(RenderUtils.CLIENT.f_91062_);
            if ((height += 9) > maxHeight) break;
            splitStrings.add(line);
        }
        return splitStrings;
    }

    public static List<String> splitStringToWidthAndHeight(String str, int maxWidth, int maxHeight) {
        return RenderUtils.splitStringToHeight(RenderUtils.splitStringToWidth(str, maxWidth), maxHeight);
    }

    public static void renderSplitString(GuiGraphics guiGraphics, List<String> splitString, int x, int y, int color) {
        for (String s : splitString) {
            guiGraphics.m_280056_(RenderUtils.CLIENT.f_91062_, s, x, y, color, true);
            Objects.requireNonNull(RenderUtils.CLIENT.f_91062_);
            y += 9;
        }
    }

    public static int getSplitStringWidth(List<String> splitString) {
        int width = 0;
        for (String line : splitString) {
            int stringWidth = RenderUtils.CLIENT.f_91062_.m_92895_(line);
            if (stringWidth <= width) continue;
            width = stringWidth;
        }
        return width;
    }

    public static int getSplitStringHeight(List<String> splitString) {
        Objects.requireNonNull(RenderUtils.CLIENT.f_91062_);
        return 9 * splitString.size();
    }

    public static int getPinnedNoteX(String position, int noteWidth) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("center_left") || positionLower.equals("bottom_left")) {
            return 5;
        }
        return CLIENT.m_91268_().m_85445_() - noteWidth - 5;
    }

    public static int getPinnedNoteY(String position, int noteHeight) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("top_right")) {
            return 5;
        }
        if (positionLower.equals("bottom_left") || positionLower.equals("bottom_right")) {
            return CLIENT.m_91268_().m_85446_() - noteHeight - 5;
        }
        return CLIENT.m_91268_().m_85446_() / 2 - noteHeight / 2;
    }

    public static String addEllipses(String str, int maxWidth) {
        return RenderUtils.CLIENT.f_91062_.m_92834_(str, Math.max(0, maxWidth - RenderUtils.CLIENT.f_91062_.m_92895_("..."))) + "...";
    }
}

