/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.util;

import com.chaosthedude.notes.util.WrappedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public final class StringUtils {
    public static final char[] FILTER_CHARS = new char[]{'\r', '\f'};
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Font font = StringUtils.mc.f_91062_;

    public static String insertStringAt(String insert, String insertTo, int pos) {
        return insertTo.substring(0, pos) + insert + insertTo.substring(pos, insertTo.length());
    }

    public static List<String> wrapToWidth(String str, int wrapWidth) {
        ArrayList<String> strings = new ArrayList<String>();
        Object temp = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n' || font.m_92895_((String)temp + String.valueOf(c)) >= wrapWidth) {
                strings.add((String)temp);
                temp = "";
            }
            if (c == '\n') continue;
            temp = (String)temp + String.valueOf(c);
        }
        strings.add((String)temp);
        return strings;
    }

    public static List<WrappedString> wrapToWidthWithIndication(String str, int wrapWidth) {
        ArrayList<WrappedString> strings = new ArrayList<WrappedString>();
        Object temp = "";
        boolean wrapped = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                strings.add(new WrappedString((String)temp, wrapped));
                temp = "";
                wrapped = false;
            } else if (font.m_92895_((String)temp + String.valueOf(c)) >= wrapWidth) {
                strings.add(new WrappedString((String)temp, wrapped));
                temp = "";
                wrapped = true;
            }
            if (c == '\n') continue;
            temp = (String)temp + String.valueOf(c);
        }
        strings.add(new WrappedString((String)temp, wrapped));
        return strings;
    }

    public static String filter(String s) {
        String filtered = s.replace(String.valueOf('\t'), "    ");
        for (char c : FILTER_CHARS) {
            filtered = filtered.replace(String.valueOf(c), "");
        }
        return filtered;
    }

    public static String filterFileName(String s) {
        String filtered = s;
        for (char c : SharedConstants.f_136184_) {
            filtered = filtered.replace(String.valueOf(c), "~");
        }
        return filtered;
    }

    public static String trimStringNewline(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static String fixBiomeName(Level world, Biome biome) {
        Optional<ResourceLocation> optionalKey = StringUtils.getKeyForBiome(world, biome);
        if (optionalKey.isPresent()) {
            String original = I18n.m_118938_((String)Util.m_137492_((String)"biome", (ResourceLocation)optionalKey.get()), (Object[])new Object[0]);
            Object fixed = "";
            char pre = ' ';
            for (int i = 0; i < original.length(); ++i) {
                char c = original.charAt(i);
                if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                    fixed = (String)fixed + " ";
                }
                fixed = (String)fixed + String.valueOf(c);
                pre = c;
            }
            return fixed;
        }
        return "";
    }

    private static Optional<? extends Registry<Biome>> getBiomeRegistry(Level level) {
        return level.m_9598_().m_6632_(ForgeRegistries.Keys.BIOMES);
    }

    private static Optional<ResourceLocation> getKeyForBiome(Level level, Biome biome) {
        return StringUtils.getBiomeRegistry(level).isPresent() ? Optional.of(StringUtils.getBiomeRegistry(level).get().m_7981_((Object)biome)) : Optional.empty();
    }
}

