/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;

public final class ConfigTombstone {
    public static final Client client;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final PlayerDeath player_death;
    public static final Alignment alignment;
    public static final General general;
    public static final VillageSiege village_siege;
    public static final MagicItem magic_item;
    public static final DecorativeGrave decorative_grave;
    public static final Enchantments enchantments;
    public static final Recovery recovery;
    public static final Loot loot;
    public static final Compatibility compatibility;
    public static final ForgeConfigSpec GENERAL_SPEC;

    private static String getTranslation(String name) {
        return "tombstone.config." + name;
    }

    static {
        BuilderHandler BUILDER = new BuilderHandler();
        client = new Client(BUILDER);
        CLIENT_SPEC = BUILDER.build();
        BUILDER = new BuilderHandler();
        player_death = new PlayerDeath(BUILDER);
        alignment = new Alignment(BUILDER);
        general = new General(BUILDER);
        village_siege = new VillageSiege(BUILDER);
        magic_item = new MagicItem(BUILDER);
        decorative_grave = new DecorativeGrave(BUILDER);
        enchantments = new Enchantments(BUILDER);
        recovery = new Recovery(BUILDER);
        loot = new Loot(BUILDER);
        compatibility = new Compatibility(BUILDER);
        GENERAL_SPEC = BUILDER.build();
    }

    private static class BuilderHandler
    extends ForgeConfigSpec.Builder {
        private BuilderHandler() {
        }

        private ForgeConfigSpec.ConfigValue<List<String>> add(String name, String comment, List<String> defaultVal) {
            return this.comment(comment).translation(ConfigTombstone.getTranslation(name)).define(name.replace(".", "_"), defaultVal);
        }

        private <T extends Enum<T>> ForgeConfigSpec.EnumValue<T> addEnum(String name, String comment, T defaultVal) {
            return this.comment(comment).translation(ConfigTombstone.getTranslation(name)).defineEnum(name.replace(".", "_"), defaultVal);
        }

        private ForgeConfigSpec.ConfigValue<Boolean> add(String name, String comment, boolean defaultVal) {
            return this.add(name, comment, ConfigTombstone.getTranslation(name), defaultVal);
        }

        private ForgeConfigSpec.ConfigValue<Boolean> add(String name, String comment, String translation, boolean defaultVal) {
            return this.comment(comment).translation(translation).define(name.replace(".", "_"), defaultVal);
        }

        private ForgeConfigSpec.ConfigValue<Integer> add(String name, String comment, int defaultVal, int minVal, int maxVal) {
            return this.comment(comment).translation(ConfigTombstone.getTranslation(name)).defineInRange(name.replace(".", "_"), defaultVal, minVal, maxVal);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> showMagicCircle;
        public final ForgeConfigSpec.ConfigValue<Boolean> showEnhancedTooltips;
        public final ForgeConfigSpec.ConfigValue<Boolean> highlight;
        public final ForgeConfigSpec.ConfigValue<Boolean> skipRespawnScreen;
        public final ForgeConfigSpec.ConfigValue<Boolean> showShieldParticle;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableHalloweenGhost;
        public final ForgeConfigSpec.ConfigValue<Boolean> dateInMCTime;
        public final ForgeConfigSpec.ConfigValue<Boolean> displayKnowledgeMessage;
        public final ForgeConfigSpec.ConfigValue<Boolean> displayAlignmentMessage;
        public final ForgeConfigSpec.ConfigValue<Boolean> equipElytraInPriority;
        public final ForgeConfigSpec.ConfigValue<Boolean> equipShieldInPriority;
        public final ForgeConfigSpec.ConfigValue<Boolean> reverseInventorySorting;
        public final ForgeConfigSpec.ConfigValue<Boolean> equipCurioSlotMagicBook;
        public final ForgeConfigSpec.ConfigValue<Boolean> showInfoOnEnchantment;
        public final ForgeConfigSpec.ConfigValue<Boolean> priorizeToolOnHotbar;
        public final ForgeConfigSpec.ConfigValue<Boolean> activateGraveBySneaking;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveInWater;
        public final ForgeConfigSpec.ConfigValue<Boolean> showTooltipCombine;
        public final ForgeConfigSpec.ConfigValue<Boolean> noBlinkingNightvision;
        public final ForgeConfigSpec.ConfigValue<Integer> particleCastingColor;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorDeathDate;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorRIP;
        public final ForgeConfigSpec.ConfigValue<Integer> textColorOwner;
        public final ForgeConfigSpec.ConfigValue<Integer> fogColor;
        public final ForgeConfigSpec.ConfigValue<FogDensity> fogDensity;
        public final ForgeConfigSpec.ConfigValue<GraveModel> favoriteGrave;
        public final ForgeConfigSpec.ConfigValue<BlockGraveMarble.MarbleType> favoriteGraveMarble;
        public final ForgeConfigSpec.ConfigValue<GraveSkinRule> graveSkinRule;
        public final ForgeConfigSpec.ConfigValue<AutoEquipRule> autoEquipRule;
        public final ForgeConfigSpec.ConfigValue<MarkerType> markerType;
        public final ForgeConfigSpec.ConfigValue<FontRule> fontRule;

        Client(BuilderHandler builder) {
            builder.comment("Personal Options that can be edited even on server").push("client");
            this.showMagicCircle = builder.add("show_magic_circle", "Shows the magic circles when using some items [false/true|default:true]", true);
            this.showEnhancedTooltips = builder.add("show_enhanced_tooltips", "Shows all the infos in the tooltip of items [false/true|default:true]", true);
            this.highlight = builder.add("highlight", "Highlights the tomb from far when holding the key [false/true|default:true]", true);
            this.skipRespawnScreen = builder.add("skip_respawn_screen", "Skips the Respawn Screen [false/true|default:false]", false);
            this.showShieldParticle = builder.add("show_shield_particle", "Shows shield particles on villager [false/true|default:true]", true);
            this.enableHalloweenGhost = builder.add("allow_halloween_ghost", "Allows the ghost to appear around you during Halloween [false/true|default:true]", true);
            this.dateInMCTime = builder.add("date_in_mc_time", "Shows only the elapsed minecraft days since the death on graves [false/true|default:false]", false);
            this.displayKnowledgeMessage = builder.add("display_knowledge_message", "Display or not the messages of gain of points in knowledge of death [false/true|default:true]", true);
            this.displayAlignmentMessage = builder.add("display_alignment_message", "Display or not the messages of earned of points in Alignment [false/true|default:true]", true);
            this.equipElytraInPriority = builder.add("equip_elytra_in_priority", "Equips elytra in priority when recovering your lost items [false/true|default:false]", false);
            this.equipShieldInPriority = builder.add("equip_shield_in_priority", "Equips shield in priority when recovering your lost items [false/true|default:false]", false);
            this.reverseInventorySorting = builder.add("reverse_inventory_sorting", "Sorts the inventory by filling the last slots first [false/true|default:false]", false);
            this.equipCurioSlotMagicBook = builder.add("equip_curio_slot_magic_book", "Automatically equip magic books in Curios slot [false/true|default:false]", false);
            this.showInfoOnEnchantment = builder.add("show_info_on_enchantment", "Shows the use of the Tombstone's enchantments in tooltip [false/true|default:true]", true);
            this.priorizeToolOnHotbar = builder.add("priorize_tool_on_hotbar", "Favor the tools on the hotbar when recovering a grave [false/true|default:false]", false);
            this.activateGraveBySneaking = builder.add("activate_grave_by_sneaking", "Allows to activate a grave by sneaking [false/true|default:true]", true);
            this.allowGraveInWater = builder.add("allow_grave_in_water", "Allows your grave to appear in water [false/true|default:true]", true);
            this.particleCastingColor = builder.add("particle_casting_color", "Decimal value for the color of the particles when using magic items [0..16777215|default:125656]", 14937088, 0, 0xFFFFFF);
            this.textColorDeathDate = builder.add("text_color_death_date", "Decimal value for the color of the grave text <Death Date> [0..16777215|default:2962496]", 2962496, 0, 0xFFFFFF);
            this.textColorRIP = builder.add("text_color_rip", "Decimal value for the color of the grave text <R.I.P.> [0..16777215|default:2962496]", 2962496, 0, 0xFFFFFF);
            this.textColorOwner = builder.add("text_color_owner", "Decimal value for the color of the grave text <Owner Name> [0..16777215|default:5991302]", 5991302, 0, 0xFFFFFF);
            this.fogColor = builder.add("fog_color", "Decimal value of the fog color [0..16777215|default:125656]", 0xFFFFFF, 0, 0xFFFFFF);
            this.fogDensity = builder.addEnum("fog_density", "Fog density around the graves [NONE/LOW/NORMAL/HIGH|default:LOW]", FogDensity.LOW);
            this.favoriteGrave = builder.addEnum("favorite_grave", "Favorite grave", GraveModel.GRAVE_SIMPLE);
            this.favoriteGraveMarble = builder.addEnum("favorite_grave_marble", "Favorite grave marble", BlockGraveMarble.MarbleType.DARK);
            this.graveSkinRule = builder.addEnum("grave_skin_rule", "Defines the rule to use for grave's skin [DEFAULT/FORCE_NORMAL/FORCE_HALLOWEEN|default:DEFAULT]", GraveSkinRule.DEFAULT);
            this.autoEquipRule = builder.addEnum("auto_equip_rule", "Defines when to automatically equip your items [NEVER/GRAVE_RECOVERY/DEATH_RESPAWN/ALWAYS|default:ALWAYS]", AutoEquipRule.getDefault());
            this.markerType = builder.addEnum("marker_type", "Defines the type of marker when holding in hand some items like the Grave's Key [WING/SPARK/NOTE/BOX|default:WING]", MarkerType.getDefault());
            this.fontRule = builder.addEnum("font_rule", "Defines the font to use in Tombstone's screens (only for english, french and spanish languages) [FANTASY/VANILLA|default:FANTASY]", FontRule.getDefault());
            this.showTooltipCombine = builder.add("show_tooltip_combine", "Display the combinations in item tooltip [false/true|default:true]", true);
            this.noBlinkingNightvision = builder.add("no_blinking_nightvision", "Prevent night vision from flashing when less than 5 seconds left [false/true|default:true]", true);
            builder.pop();
        }

        public static enum FogDensity {
            NONE,
            LOW,
            NORMAL,
            HIGH;

            private final String translation = Helper.capitalizeWord(this.name());

            public String getTranslation() {
                return this.translation;
            }
        }

        public static enum GraveSkinRule {
            DEFAULT,
            FORCE_NORMAL,
            FORCE_HALLOWEEN,
            FORCE_CHRISTMAS;

            private final String translation = Helper.capitalizeWord(this.name());

            public String getTranslation() {
                return this.translation;
            }
        }

        public static enum AutoEquipRule {
            NEVER,
            GRAVE_RECOVERY,
            DEATH_RESPAWN,
            ALWAYS;

            private final String translation = Helper.capitalizeWord(this.name());

            public static AutoEquipRule getDefault() {
                return ALWAYS;
            }

            public static AutoEquipRule byId(int id) {
                return id >= 0 && id < AutoEquipRule.values().length ? AutoEquipRule.values()[id] : AutoEquipRule.getDefault();
            }

            public boolean equipOnRespawn() {
                return this == DEATH_RESPAWN || this == ALWAYS;
            }

            public boolean equipOnGraveRecovery() {
                return this == GRAVE_RECOVERY || this == ALWAYS;
            }

            public String getTranslation() {
                return this.translation;
            }
        }

        public static enum MarkerType {
            WING,
            SPARK,
            NOTE,
            BOX;

            private final String translation = Helper.capitalizeWord(this.name());

            public static MarkerType getDefault() {
                return WING;
            }

            public String getTranslation() {
                return this.translation;
            }
        }

        public static enum FontRule {
            FANTASY,
            VANILLA;

            private final String translation = Helper.capitalizeWord(this.name());

            public boolean isVanilla() {
                return this == VANILLA;
            }

            public String getTranslation() {
                return this.translation;
            }

            public static FontRule getDefault() {
                return FANTASY;
            }
        }
    }

    public static class PlayerDeath {
        public final ForgeConfigSpec.ConfigValue<Boolean> pvpUnlockGrave;
        public final ForgeConfigSpec.ConfigValue<Boolean> restoreEffectsOnDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> lossOnDeathOnlyForAbandonedGrave;
        public final ForgeConfigSpec.ConfigValue<Boolean> lossOnDeathOnlyForStackableItems;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventDeathOutsideWorldBorder;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventDeathOutsideBuildHeight;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowToFillExistingGrave;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfGhostlyShapeTeleportWithKey;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfGhostlyShapeEnemyCollision;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfGhostlyShapeOpenChest;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfGhostlyShapeBreakBlock;
        public final ForgeConfigSpec.ConfigValue<Integer> snifferRange;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceMobOnGraveRecovery;
        public final ForgeConfigSpec.ConfigValue<Integer> pvpStolenXp;
        public final ForgeConfigSpec.ConfigValue<Integer> knowledgeLoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceLossOnDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> percentLossOnDeath;
        public final ForgeConfigSpec.ConfigValue<List<String>> noGraveLocation;

        PlayerDeath(BuilderHandler builder) {
            builder.comment("Options related to player's death").push("player_death");
            this.pvpUnlockGrave = builder.add("pvp_unlock_grave", "Whether to unlock access to a grave if the player has been killed by another player [false/true|default:true]", true);
            this.restoreEffectsOnDeath = builder.add("restore_effects_on_death", "Whether to restore beneficial effects after a player dies [false/true|default:true]", false);
            this.lossOnDeathOnlyForAbandonedGrave = builder.add("loss_on_death_only_for_abandoned_grave", "Only abandoned graves can have losses of items (based on the decay_time) [false/true|default:true]", true);
            this.lossOnDeathOnlyForStackableItems = builder.add("loss_on_death_only_for_stackable_items", "Only stackable items can be lost on death [false/true|default:true]", true);
            this.preventDeathOutsideWorldBorder = builder.add("prevent_death_outside_world_border", "Prevents death outside the borders of the world [false/true|default:true]", true);
            this.preventDeathOutsideBuildHeight = builder.add("prevent_death_outside_build_height", "Prevents death outside the build height [false/true|default:false]", false);
            this.allowToFillExistingGrave = builder.add("allow_to_fill_existing_grave", "Allows to fill an existing grave instead of creating a new one [false/true|default:true]", true);
            this.nerfGhostlyShapeTeleportWithKey = builder.add("nerf_ghostly_shape.teleport_with_key", "Caps the duration of Ghostly Shape effect to 10 seconds when teleporting with a Grave's Key [false/true|default:true]", true);
            this.nerfGhostlyShapeEnemyCollision = builder.add("nerf_ghostly_shape.enemy_collision", "Cancel the Ghostly Shape effect when colliding an enemy [false/true|default:true]", true);
            this.nerfGhostlyShapeOpenChest = builder.add("nerf_ghostly_shape.open_chest", "Cancel the Ghostly Shape effect when opening a chest [false/true|default:true]", true);
            this.nerfGhostlyShapeBreakBlock = builder.add("nerf_ghostly_shape.break_block", "Cancel the Ghostly Shape effect when breaking a block [false/true|default:true]", true);
            this.snifferRange = builder.add("sniffer_range", "The radius in which items should be collected when a grave is spawned [1..10|default:5]", 5, 1, 10);
            this.chanceMobOnGraveRecovery = builder.add("chance_mob_on_grave_recovery", "The chance that creatures appear after the contents of a grave are retrieved [0..100|default:0]", 0, 0, 100);
            this.pvpStolenXp = builder.add("pvp_stolen_xp", "Percent of stolen experience by killing a player when PvP mode is enabled [0..100|default:30]", 30, 0, 100);
            this.knowledgeLoss = builder.add("knowledge_loss", "Knowledge of Death loss on death [0..500|default:0]", 0, 0, 500);
            this.chanceLossOnDeath = builder.add("chance_loss_on_death", "The chance that some items are lost on death [0..100|default:0]", 0, 0, 100);
            this.percentLossOnDeath = builder.add("percent_loss_on_death", "The percentage of items that are lost on death [0..100|default:0]", 0, 0, 100);
            this.noGraveLocation = builder.add("no_grave_location", "Graveless Areas", Lists.newArrayList((Object[])new String[]{"0, -300, 0, minecraft:overworld, 20"}));
            builder.pop();
        }
    }

    public static class Alignment {
        public final ForgeConfigSpec.ConfigValue<Integer> pointsFreeSoulReceptacle;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsPlunderPlayerGrave;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsExorcismZombieVillager;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsZombifyVillager;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsKillVillager;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsKillRaider;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsTabletOfCupidity;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsPrayOfProtection;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsEarthlyGarden;
        public final ForgeConfigSpec.ConfigValue<Integer> pointsKillTamedCreature;

        Alignment(BuilderHandler builder) {
            builder.comment("Options related to player's alignment").push("alignment");
            this.pointsFreeSoulReceptacle = builder.add("points_free_soul_receptacle", "Points for freeing a soul in a receptacle [0..500|default:50]", 50, 0, 500);
            this.pointsPlunderPlayerGrave = builder.add("points_plunder_player_grave", "Points for plundering a player's grave [-500..0|default:-10]", -10, -500, 0);
            this.pointsExorcismZombieVillager = builder.add("points_exorcism_zombie_villager", "Points for zombie villager exorcism [0..500|default:20]", 20, 0, 500);
            this.pointsZombifyVillager = builder.add("points_zombify_villager", "Points for zombifying a villager [-500..0|default:-20]", -20, -500, 0);
            this.pointsKillVillager = builder.add("points_kill_villager", "Points for killing a villager [-500..0|default:-15]", -15, -500, 0);
            this.pointsKillRaider = builder.add("points_kill_raider", "Points for killing a raider [0..500|default:5]", 5, 0, 500);
            this.pointsTabletOfCupidity = builder.add("points_tablet_of_cupidity", "Points for tablet of cupidity [-500..0|default:-10]", -10, -500, 0);
            this.pointsPrayOfProtection = builder.add("points_pray_of_protection", "Points for Pray of Protection [0..500|default:20]", 20, 0, 500);
            this.pointsEarthlyGarden = builder.add("points_earthly_garden", "Points for using a Potion of Earthly Garden [0..500|default:10]", 10, 0, 500);
            this.pointsKillTamedCreature = builder.add("points_kill_tamed_creature", "Points for killing one of your tamed creatures [-500..0|default:-10]", -10, -500, 0);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> teleportDim;
        public final ForgeConfigSpec.ConfigValue<Boolean> knowledgeReducePhantomSpawn;
        public final ForgeConfigSpec.ConfigValue<Integer> timeForPhantomSpawn;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownRequestTeleport;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownTeleportDeath;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownTeleportBind;
        public final ForgeConfigSpec.ConfigValue<Integer> easterEggSpawnRarity;
        public final ForgeConfigSpec.ConfigValue<List<String>> unhandledBeneficialEffects;
        public final ForgeConfigSpec.ConfigValue<List<String>> unhandledHarmfulEffects;

        General(BuilderHandler builder) {
            builder.comment("Miscellaneous options").push("general");
            this.teleportDim = builder.add("teleport_dim", "Allows teleportation to other dimensions [false/true|default:true]", true);
            this.knowledgeReducePhantomSpawn = builder.add("knowledge_reduce_phantom_spawn", "Increases the minimum time without sleeping for phantom spawn around player based on their level in Knowledge of Death [false/true|default:true]", true);
            this.timeForPhantomSpawn = builder.add("time_for_phantom_spawn", "Minimum time without sleeping for phantom to spawn around players [1200..MAX|default:72000]", 72000, 1200, Integer.MAX_VALUE);
            this.cooldownRequestTeleport = builder.add("cooldown_request_teleport", "Cooldown in minutes to use the command tbrequestteleport [-1..1440|default:-1]", -1, -1, 1440);
            this.cooldownTeleportDeath = builder.add("cooldown_teleport_death", "Cooldown in minutes to use the command tbteleportdeath [-1..1440|default:-1]", -1, -1, 1440);
            this.cooldownTeleportBind = builder.add("cooldown_teleport_bind", "Cooldown in minutes to use the command tbbind [-1..1440|default:-1]", -1, -1, 1440);
            this.unhandledBeneficialEffects = builder.add("unhandled_beneficial_effects", "Beneficial effects that can't used by certain features such as ankh of prayer, lollipop, scroll of preservation, alchemy perk and magic siphon enchantment", Lists.newArrayList((Object[])new String[]{"astralsorcery:potiontimefreeze"}));
            this.unhandledHarmfulEffects = builder.add("unhandled_harmful_effects", "Harmful effects that can't used by certain features such as tablet of cupidity and the enchantment plague bringer", Lists.newArrayList((Object[])new String[]{"minecraft:nausea"}));
            this.easterEggSpawnRarity = builder.add("easter_egg_spawn_rarity", "Rarity for Easter Eggs to spawn during Easter [1000..100000|default:5000]", 5000, 1000, 100000);
            builder.pop();
        }
    }

    public static class VillageSiege {
        public final ForgeConfigSpec.ConfigValue<Boolean> handleVillageSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> logSiegeState;
        public final ForgeConfigSpec.ConfigValue<Boolean> glowingCreatureTest;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowCreativePlayersForSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> undeadWearHelmInSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistentMobInSiege;
        public final ForgeConfigSpec.ConfigValue<Boolean> shufflePlayersForSiege;
        public final ForgeConfigSpec.ConfigValue<Integer> siegeChance;
        public final ForgeConfigSpec.ConfigValue<Integer> siegeMaxCreature;
        public final ForgeConfigSpec.ConfigValue<Integer> delaySiegeTest;

        VillageSiege(BuilderHandler builder) {
            builder.comment("Allows to define the conditions for a village siege to begin").push("village_siege");
            this.handleVillageSiege = builder.add("handle_village_siege", "Allows to handle village sieges [false/true|default:true]", true);
            this.logSiegeState = builder.add("log_siege_state", "Logs the different states of a village siege while searching for an adequate place [false/true|default:false]", false);
            this.glowingCreatureTest = builder.add("glowing_creature_test", "The creatures of the siege have a glowing effect (only uses this for test purposes) [false/true|default:false]", false);
            this.allowCreativePlayersForSiege = builder.add("allow_creative_players_for_siege", "Allows to use the positions of creative players to define the siege location [false/true|default:true]", true);
            this.undeadWearHelmInSiege = builder.add("undead_wear_helm_in_siege", "Undeads always wear a helm when sieging [false/true|default:false]", false);
            this.persistentMobInSiege = builder.add("persistent_mob_in_siege", "Mobs in siege are persistent [false/true|default:false]", false);
            this.shufflePlayersForSiege = builder.add("shuffle_players_for_siege", "Shuffles the list of players before testing the siege location [false/true|default:true]", true);
            this.siegeChance = builder.add("siege_chance", "Chance for a siege to occur [0..100|default:10]", 10, 0, 100);
            this.siegeMaxCreature = builder.add("siege_max_creature", "Maximum of creatures appearing in a siege [0..100|default:20]", 20, 0, 100);
            this.delaySiegeTest = builder.add("delay_siege_test", "Delay in seconds for a second test of siege when the first failed [0..1200|default:200]", 200, 0, 1200);
            builder.pop();
        }
    }

    public static class MagicItem {
        public final ForgeConfigSpec.ConfigValue<Boolean> canRecycleDamagedItem;
        public final ForgeConfigSpec.ConfigValue<List<String>> deniedItemToRecycle;
        public final ForgeConfigSpec.ConfigValue<Boolean> canDisenchantEnchantedBook;
        public final ForgeConfigSpec.ConfigValue<Boolean> lostTabletSearchOutsideWorld;
        public final ForgeConfigSpec.ConfigValue<Boolean> lostTabletSearchModdedStructure;
        public final ForgeConfigSpec.ConfigValue<List<String>> lostTabletDeniedStructures;
        public final ForgeConfigSpec.ConfigValue<List<String>> lostTabletDeniedWorlds;
        public final ForgeConfigSpec.ConfigValue<Integer> durationVoodooPoppetEffects;

        MagicItem(BuilderHandler builder) {
            builder.comment("For settings related to magic items").push("magic_item");
            this.canRecycleDamagedItem = builder.add("can_recycle_damaged_item", "Damaged items can be recycled with the Book of Recycling", true);
            this.deniedItemToRecycle = builder.add("denied_item_to_recycle", "The items that can't be recycled by the Book of Recycling", new ArrayList<String>());
            this.canDisenchantEnchantedBook = builder.add("can_disenchant_enchanted_book", "Allows to disenchant enchanted books with the Book of Disenchantment", false);
            this.lostTabletSearchOutsideWorld = builder.add("lost_tablet_search_outside_world", "Allows lost tablets to find locations outside the current world [false/true|default:true]", true);
            this.lostTabletSearchModdedStructure = builder.add("lost_tablet_modded_structure", "Allows lost tablets to find modded structures [false/true|default:true]", true);
            this.lostTabletDeniedStructures = builder.add("lost_tablet_denied_structures", "The structures that can't be discovered by lost tablets", new ArrayList<String>());
            this.lostTabletDeniedWorlds = builder.add("lost_tablet_denied_worlds", "The worlds that can't be discovered by lost tablets", new ArrayList<String>());
            this.durationVoodooPoppetEffects = builder.add("duration_voodoo_poppet_effects", "Duration of voodoo poppet's effects in seconds when preventing death [5..60000|default:60]", 60, 5, 60000);
            builder.pop();
        }
    }

    public static class DecorativeGrave {
        public final ForgeConfigSpec.ConfigValue<Boolean> canReplaceGravePlate;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowGraveGardian;
        public final ForgeConfigSpec.ConfigValue<Integer> distanceBetweenGraveGuardian;
        public final ForgeConfigSpec.ConfigValue<Integer> restockTimeGraveGuardian;
        public final ForgeConfigSpec.ConfigValue<Integer> timeSoul;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceSoul;
        public final ForgeConfigSpec.ConfigValue<Integer> chancePrayReward;

        DecorativeGrave(BuilderHandler builder) {
            builder.comment("For settings related to decorative tombs and magic items").push("decorative_grave");
            this.canReplaceGravePlate = builder.add("can_replace_grave_plate", "Allows to replace a grave plate already set on a grave [false/true|default:true]", true);
            this.allowGraveGardian = builder.add("allow_grave_gardian", "Allows the merchant grave gardian [false/true|default:true]", true);
            this.distanceBetweenGraveGuardian = builder.add("distance_between_grave_guardian", "Minimum distance between Grave Gardians to spawn [10..200|default:100]", 100, 10, 200);
            this.restockTimeGraveGuardian = builder.add("restock_time_grave_guardian", "Time in minutes for a Grave Guardian to restock its offers [1..1000|default:60]", 60, 1, 1000);
            this.timeSoul = builder.add("time_soul", "Time in minutes to check if a soul appears on a grave [1..10000|default:30]", 30, 1, 10000);
            this.chanceSoul = builder.add("chance_soul", "Chance on 1000 that a soul appears on a grave [0..1000|default:100]", 100, 0, 1000);
            this.chancePrayReward = builder.add("chance_pray_reward", "Chance to receive a random beneficial spell effect when praying near a grave [0..100|default:30]", 30, 0, 100);
            builder.pop();
        }
    }

    public static class Enchantments {
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfPlagueBringer;
        public final ForgeConfigSpec.ConfigValue<Boolean> nerfCurseOfBones;
        public final ForgeConfigSpec.ConfigValue<Integer> maxDurationMagicSiphon;
        public final ForgeConfigSpec.ConfigValue<Integer> durationPlagueBringer;
        public final ForgeConfigSpec.ConfigValue<Integer> cooldownBlessing;
        public final ForgeConfigSpec.ConfigValue<Integer> minCooldownCurseOfBones;
        public final ForgeConfigSpec.ConfigValue<Integer> maxCooldownCurseOfBones;
        public final ForgeConfigSpec.ConfigValue<Integer> minCooldownSpectralBite;
        public final ForgeConfigSpec.ConfigValue<Integer> maxCooldownSpectralBite;
        public final ForgeConfigSpec.ConfigValue<Integer> minCooldownSpectralConjurer;
        public final ForgeConfigSpec.ConfigValue<Integer> maxCooldownSpectralConjurer;
        public final ForgeConfigSpec.ConfigValue<Integer> maxDurationSpectralConjurer;
        public final ForgeConfigSpec.ConfigValue<MagicSiphonOnPlayerRule> magicSiphonOnPlayerRule;

        Enchantments(BuilderHandler builder) {
            builder.comment("Allows to customize or disable the enchantments").push("enchantments");
            this.nerfPlagueBringer = builder.add("nerf_plague_bringer", "The wearer is also affected by the effect if his alignment is not bad [false/true|default:true]", true);
            this.maxDurationMagicSiphon = builder.add("max_duration_magic_siphon", "Maximum duration of stolen effects in minutes [1..MAX|default:10]", 10, 1, Integer.MAX_VALUE);
            this.durationPlagueBringer = builder.add("duration_plague_bringer", "Duration of applied effects in seconds [1..MAX|default:10]", 10, 1, Integer.MAX_VALUE);
            this.magicSiphonOnPlayerRule = builder.addEnum("magic_siphon_on_player_rule", "Defines if players can steal effects to others players. If nerfed, the stolen effect duration is limited to 10% of the initial effect [ALLOW/NERFED/DISALLOW|default:ALLOW]", MagicSiphonOnPlayerRule.ALLOW);
            this.nerfCurseOfBones = builder.add("nerf_curse_of_bones", "Halves the reflected damages of Bone Shield [false/true|default:false]", false);
            this.cooldownBlessing = builder.add("cooldown_blessing", "Cooldown in seconds to have a chance to obtain a new effect [0..60|default:10]", 10, 0, 60);
            this.minCooldownCurseOfBones = builder.add("min_cooldown_curse_of_bones", "Minimum cooldown in seconds to have a chance to obtain Bone Shield [10..40|default:20]", 20, 10, 40);
            this.maxCooldownCurseOfBones = builder.add("max_cooldown_curse_of_bones", "Maximum cooldown in seconds to have a chance to obtain Bone Shield [60..120|default:60]", 60, 60, 120);
            this.minCooldownSpectralBite = builder.add("min_cooldown_spectral_bite", "Minimum cooldown in seconds to have a chance to obtain Spectral Bite [3..20|default:3]", 3, 3, 20);
            this.maxCooldownSpectralBite = builder.add("max_cooldown_spectral_bite", "Maximum cooldown in seconds to have a chance to obtain Spectral Bite [30..60|default:30]", 30, 30, 60);
            this.minCooldownSpectralConjurer = builder.add("min_cooldown_spectral_conjurer", "Minimum cooldown in seconds to have a chance to spawn a Spectral Wolf [3..20|default:3]", 60, 20, 90);
            this.maxCooldownSpectralConjurer = builder.add("max_cooldown_spectral_conjurer", "Maximum cooldown in seconds to have a chance to spawn a Spectral Wolf [30..60|default:30]", 240, 120, 600);
            this.maxDurationSpectralConjurer = builder.add("max_duration_spectral_conjurer", "Maximum duration of conjured Spectral Wolf [10..300|default:120]", 60, 10, 300);
            builder.pop();
        }

        public static enum MagicSiphonOnPlayerRule {
            ALLOW,
            NERFED,
            DISALLOW;

        }
    }

    public static class Recovery {
        public final ForgeConfigSpec.ConfigValue<Boolean> recoveryPlayerEnable;
        public final ForgeConfigSpec.ConfigValue<Boolean> backupOnDeath;
        public final ForgeConfigSpec.ConfigValue<Boolean> logAutoBackup;
        public final ForgeConfigSpec.ConfigValue<Integer> recoveryPlayerTimer;
        public final ForgeConfigSpec.ConfigValue<Integer> recoveryPlayerMaxSaves;

        Recovery(BuilderHandler builder) {
            builder.comment("Options related to the command recovery and auto-save of players").push("recovery");
            this.recoveryPlayerEnable = builder.add("recovery_player_enable", "Enables to backup automatically players [false/true|default:true]", true);
            this.backupOnDeath = builder.add("backup_on_death", "Backup players on death [false/true|default:false]", true);
            this.recoveryPlayerTimer = builder.add("recovery_player_timer", "Time in minutes between players' backups [10..1000|default:40]", 19, 5, 1000);
            this.recoveryPlayerMaxSaves = builder.add("recovery_player_max_saves", "Maximum number of backups per player [5..100|default:15]", 15, 5, 100);
            this.logAutoBackup = builder.add("log_auto_backup", "Log when players are automatically back up [false/true|default:false]", false);
            builder.pop();
        }
    }

    public static class Loot {
        public final ForgeConfigSpec.ConfigValue<Integer> maxXpLostPage;

        Loot(BuilderHandler builder) {
            builder.comment("Options related to looted items").push("loot");
            this.maxXpLostPage = builder.add("max_xp_lost_page", "Maximum xp rewarded with a Lost Page of Erd\u00f6s [1..200000|default:2000]", 2000, 1, 200000);
            builder.pop();
        }
    }

    public static class Compatibility {
        public final ForgeConfigSpec.ConfigValue<Boolean> curioAutoEquip;
        public final ForgeConfigSpec.ConfigValue<Boolean> curioBundleSupport;
        public final ForgeConfigSpec.ConfigValue<Boolean> curioMagicBookSupport;
        public final ForgeConfigSpec.ConfigValue<Boolean> keepCosmeticArmor;
        public final ForgeConfigSpec.ConfigValue<Boolean> preserveEffectsOnReturnEndConquered;

        Compatibility(BuilderHandler builder) {
            builder.comment("Allows to enable some features related to others mods").push("compatibility");
            this.curioAutoEquip = builder.add("curio_auto_equip", "Allows to auto-equip the slots from Curio mod [false/true|default:true]", true);
            this.curioBundleSupport = builder.add("curio_bundle_support", "Allows to provide a default support for bundle in Curio mod [false/true|default:true]", true);
            this.curioMagicBookSupport = builder.add("curio_magic_book_support", "Allows to provide a magic book slot in Curio mod used to enchant with a soul [false/true|default:true]", true);
            this.keepCosmeticArmor = builder.add("keep_cosmetic_armor", "Keeps the cosmetic armor when you die [false/true|default:true]", true);
            this.preserveEffectsOnReturnEndConquered = builder.add("preserve_effects_on_return_end_conquered", "Ensure the potion effects to stay on the player after returning from end conquered [false/true|default:true]", true);
            builder.pop();
        }
    }

    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ConfigEvent {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onReloadConfig(ModConfigEvent.Reloading event) {
            if (event.getConfig().getModId().equals("tombstone")) {
                if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                    DeathHandler.INSTANCE.updateNoGraveLocations();
                } else {
                    ModTombstone.PROXY.markConfigDirty();
                }
            }
        }
    }
}

