/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import ovh.corail.tombstone.api.event.CaptureSoulEvent;
import ovh.corail.tombstone.api.event.MerchantOffersEvent;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.api.event.RestoreInventoryEvent;
import ovh.corail.tombstone.api.event.VillageSiegeEvent;
import ovh.corail.tombstone.entity.AbstractMerchant;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public class EventFactory {
    public static boolean onVillageSiegeStart(ServerLevel level, BlockPos spawnPos) {
        return MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent.Start(level, spawnPos));
    }

    public static boolean onVillageSiegeZombieSpawn(ServerLevel level, Zombie entity) {
        return MinecraftForge.EVENT_BUS.post((Event)new VillageSiegeEvent.SpawnZombie(level, entity));
    }

    public static void onRestoreInventory(Player player, BlockEntityPlayerGrave tileGrave) {
        MinecraftForge.EVENT_BUS.post((Event)new RestoreInventoryEvent(player, tileGrave.m_58899_(), tileGrave.getInventory(), tileGrave.getOwnerName(), tileGrave.getOwnerDeathTime()));
    }

    public static boolean onCaptureSoul(Player player, LivingEntity capturedEntity) {
        return MinecraftForge.EVENT_BUS.post((Event)new CaptureSoulEvent(player, capturedEntity));
    }

    public static int onPhantomTime(Player player, int timeForCheck) {
        PhantomSpawnerEvent.TimeForCheck event = new PhantomSpawnerEvent.TimeForCheck(player, timeForCheck);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getTimeForCheck();
    }

    public static boolean onCheckPhantomSpawn(Player player, int timeForCheck, int timeSinceRest, boolean result) {
        PhantomSpawnerEvent.CheckPhantomSpawn event = new PhantomSpawnerEvent.CheckPhantomSpawn(player, timeForCheck, timeSinceRest);
        event.setResult(result ? Event.Result.ALLOW : Event.Result.DENY);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() != Event.Result.DENY;
    }

    public static void onInitGraveGuardianOffers(AbstractMerchant merchant) {
        MinecraftForge.EVENT_BUS.post((Event)new MerchantOffersEvent(merchant, merchant.getTradeLevel(), merchant.m_6616_()));
    }
}

