/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.combine.ClientTooltipCombineCraft;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ICombineCraft;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTags;

@OnlyIn(value=Dist.CLIENT)
public final class CompendiumData {
    private static final int LINES_BY_PAGE = 13;
    private static final int DESCRIPTION_WIDTH = 210;
    private final CompendiumLabel info;
    private final ItemStack icon;
    private final List<FormattedCharSequence> description;
    private final int pageMax;
    private final List<CompendiumLabel> links;
    private final List<CompendiumRecipe> recipes;

    CompendiumData(CompendiumLabel info, ItemStack icon, Component description, List<CompendiumLabel> links, List<CompendiumRecipe> recipes) {
        this.info = info;
        this.icon = icon;
        this.description = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)FontHelper.withFantasyFont(description), 210);
        this.pageMax = Mth.m_14167_((float)((float)this.description.size() / 13.0f));
        this.links = links;
        this.recipes = recipes;
    }

    boolean isIndex() {
        return this.info == CompendiumLabel.COMPENDIUM;
    }

    ItemStack getIcon() {
        return this.icon;
    }

    Component getTitle() {
        return this.info.getTitle();
    }

    List<FormattedCharSequence> getPage(int pageNum) {
        int indexStart = Math.min(pageNum * 13, this.description.size() - 1);
        if (indexStart >= 0) {
            return this.description.subList(indexStart, Math.min(indexStart + 13 - 1, this.description.size() - 1) + 1);
        }
        return Collections.emptyList();
    }

    int getPageMax() {
        return this.pageMax;
    }

    List<CompendiumLabel> getLinks() {
        return this.links;
    }

    List<CompendiumRecipe> getRecipes() {
        return this.recipes;
    }

    static CompendiumData getInfo(CompendiumLabel info) {
        Builder builder = new Builder(info);
        switch (info) {
            case COMPENDIUM: {
                builder.withIcon((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE)).withDescription("tombstone.compendium.intro");
                break;
            }
            case SPECIAL_THANKS: {
                builder.withIcon((ItemLike)Items.f_42716_).withDescriptionAsText("Special thanks to some people for past discussions that helped in the creation and evolution of this mod:\n- Gegy\n- Tterag\n- KidsDontPlay\n- Runemoro\n- Barteks2x\n- H3lay");
                break;
            }
            case DEATH: {
                builder.withIcon(ItemAdvancement.IconType.FIRST_KNOWLEDGE);
                break;
            }
            case DECORATIVE_GRAVE: {
                builder.withIcon((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.GRAVE_SIMPLE)).withRecipe("tombstone:black_grave_simple").withRecipe("tombstone:black_grave_normal").withRecipe("tombstone:black_grave_cross").withRecipe("tombstone:black_grave_original").withRecipe("tombstone:black_subaraki_grave").withRecipe("tombstone:black_tombstone");
                break;
            }
            case COMBINATION: {
                builder.withIcon(ItemAdvancement.IconType.COMBINATION);
                break;
            }
            case MAGIC_ITEMS: {
                builder.withIcon(ItemAdvancement.IconType.TELEPORT_TO_GRAVE);
                break;
            }
            case ENCHANTMENTS: {
                builder.withIcon((ItemLike)Items.f_42690_);
                break;
            }
            case PRAYER: {
                builder.withIcon(ItemAdvancement.IconType.TELEPORT_TO_GRAVE);
                break;
            }
            case KNOWLEDGE_OF_DEATH: {
                builder.withIcon((ItemLike)ModItems.ankh_of_prayer);
                break;
            }
            case SPECIAL_BONUS: {
                break;
            }
            case SPECTRAL_BITE: 
            case SOULBOUND: 
            case MAGIC_SIPHON: 
            case PLAGUE_BRINGER: 
            case CURSE_OF_BONES: 
            case BLESSING: 
            case FROSTBITE: 
            case SPECTRAL_CONJURER: {
                builder.withIcon((ItemLike)Items.f_42690_);
                break;
            }
            case ALIGNMENT: {
                builder.withIcon(ItemAdvancement.IconType.REVIVE);
                break;
            }
            case ANKH_OF_PRAYER: {
                builder.withIcon((ItemLike)ModItems.ankh_of_prayer).withRecipe("tombstone:ankh_of_prayer");
                break;
            }
            case BONE_NEEDLE: {
                builder.withIcon((ItemLike)ModItems.bone_needle).withRecipe("tombstone:bone_needle");
                break;
            }
            case BOOK_OF_DISENCHANTMENT: {
                builder.withIcon((ItemLike)ModItems.book_of_disenchantment).withRecipe("tombstone:book_of_disenchantment");
                break;
            }
            case BOOK_OF_RECYCLING: {
                builder.withIcon((ItemLike)ModItems.book_of_recycling).withRecipe("tombstone:book_of_recycling");
                break;
            }
            case BOOK_OF_REPAIRING: {
                builder.withIcon((ItemLike)ModItems.book_of_repairing).withRecipe("tombstone:book_of_repairing");
                break;
            }
            case BOOK_OF_SCRIBE: {
                builder.withIcon((ItemLike)ModItems.book_of_scribe).withRecipe("tombstone:book_of_scribe");
                break;
            }
            case BOOK_OF_MAGIC_IMPREGNATION: {
                builder.withIcon((ItemLike)ModItems.book_of_magic_impregnation).withRecipe("tombstone:book_of_magic_impregnation");
                break;
            }
            case BOOK_OF_SOULBOUND: {
                builder.withIcon((ItemLike)ModItems.book_of_soulbound).withRecipe("tombstone:book_of_soulbound");
                break;
            }
            case BOOK_OF_OBLIVION: {
                builder.withIcon((ItemLike)ModItems.book_of_oblivion).withRecipe("tombstone:book_of_oblivion");
                break;
            }
            case MAGIC_BOOKS: {
                builder.withIcon((ItemLike)Items.f_41997_);
                break;
            }
            case ENCHANTED_BUNDLE: {
                builder.withIcon(NBTStackHelper.setBoolean(new ItemStack((ItemLike)Items.f_151058_), "enchant", true));
                break;
            }
            case GRAVE_MARBLE: {
                builder.withIcon((ItemLike)ModBlocks.dark_marble).withRecipe("tombstone:dark_marble").withRecipe("tombstone:white_marble");
                break;
            }
            case DUST_OF_VANISHING: {
                builder.withIcon((ItemLike)ModItems.dust_of_vanishing).withRecipe(ModItems.grave_dust, ModItems.dust_of_vanishing);
                break;
            }
            case DUST_OF_FROST: {
                builder.withIcon((ItemLike)ModItems.dust_of_frost).withRecipe(ModItems.grave_dust, ModItems.dust_of_frost);
                break;
            }
            case ESSENCE_OF_UNDEATH: {
                builder.withIcon((ItemLike)ModItems.essence_of_undeath);
                break;
            }
            case RECEPTACLE_OF_FAMILIAR: {
                builder.withIcon((ItemLike)ModItems.receptacle_of_familiar).withRecipe("tombstone:receptacle_of_familiar");
                break;
            }
            case FISHING_ROD_OF_MISADVENTURE: {
                builder.withIcon((ItemLike)ModItems.fishing_rod_of_misadventure).withRecipe("tombstone:fishing_rod_of_misadventure");
                break;
            }
            case GHOSTLY_SHAPE: {
                builder.withIcon(ItemAdvancement.IconType.CANCEL_GHOSTLY_SHAPE);
                break;
            }
            case GRAVE_DUST: {
                builder.withIcon((ItemLike)ModItems.grave_dust);
                break;
            }
            case GRAVE_KEY: {
                builder.withIcon((ItemLike)ModItems.grave_key).withRecipe("tombstone:enchanted_grave_key");
                break;
            }
            case GRAVE_PLATE: {
                builder.withIcon(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "named")).withRecipe("tombstone:grave_plate");
                break;
            }
            case HALLOWEEN: {
                builder.withIcon(ItemAdvancement.IconType.GHOST);
                break;
            }
            case APRIL_FOOLS_DAY: {
                builder.withIcon((ItemLike)Items.f_42528_);
                break;
            }
            case CHRISTMAS: {
                builder.withIcon(NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.gift), "enchant", true));
                break;
            }
            case IMPREGNATED_DIAMOND: {
                builder.withIcon((ItemLike)ModItems.impregnated_diamond).withRecipe("tombstone:impregnated_diamond");
                break;
            }
            case LOLLIPOP: {
                builder.withIcon(ModItems.lollipop.getRandomItemStack());
                break;
            }
            case EASTER_EGG: {
                builder.withIcon(ModItems.easter_egg.getRandomItemStack());
                break;
            }
            case LOST_TABLET: {
                builder.withIcon((ItemLike)ModItems.lost_tablet);
                break;
            }
            case PERK: {
                break;
            }
            case SCROLL_OF_FEATHER_FALL: {
                builder.withIcon(ItemScrollBuff.SpellBuff.FEATHER_FALL).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.FEATHER_FALL.getItem());
                break;
            }
            case SCROLL_OF_KNOWLEDGE: {
                builder.withIcon((ItemLike)ModItems.scroll_of_knowledge).withRecipe(ModItems.strange_scroll, ModItems.scroll_of_knowledge);
                break;
            }
            case SCROLL_OF_PRESERVATION: {
                builder.withIcon(ItemScrollBuff.SpellBuff.PRESERVATION).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.PRESERVATION.getItem());
                break;
            }
            case SCROLL_OF_PURIFICATION: {
                builder.withIcon(ItemScrollBuff.SpellBuff.PURIFICATION).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.PURIFICATION.getItem());
                break;
            }
            case SCROLL_OF_TRUE_SIGHT: {
                builder.withIcon(ItemScrollBuff.SpellBuff.TRUE_SIGHT).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.TRUE_SIGHT.getItem());
                break;
            }
            case SCROLL_OF_UNSTABLE_INTANGIBILITY: {
                builder.withIcon(ItemScrollBuff.SpellBuff.UNSTABLE_INTANGIBILITY).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.UNSTABLE_INTANGIBILITY.getItem());
                break;
            }
            case SCROLL_OF_REACH: {
                builder.withIcon(ItemScrollBuff.SpellBuff.REACH).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.REACH.getItem());
                break;
            }
            case SCROLL_OF_LIGHTNING_RESISTANCE: {
                builder.withIcon(ItemScrollBuff.SpellBuff.LIGHTNING_RESISTANCE).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.LIGHTNING_RESISTANCE.getItem());
                break;
            }
            case SCROLL_OF_FROST_RESISTANCE: {
                builder.withIcon(ItemScrollBuff.SpellBuff.FROST_RESISTANCE).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.FROST_RESISTANCE.getItem());
                break;
            }
            case SCROLL_OF_AQUATIC_LIFE: {
                builder.withIcon(ItemScrollBuff.SpellBuff.AQUATIC_LIFE).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.AQUATIC_LIFE.getItem());
                break;
            }
            case SCROLL_OF_MERCY: {
                builder.withIcon(ItemScrollBuff.SpellBuff.MERCY).withRecipe(ModItems.strange_scroll, ItemScrollBuff.SpellBuff.MERCY.getItem());
                break;
            }
            case MAGIC_SCROLLS: {
                builder.withIcon((ItemLike)ModItems.strange_scroll);
                break;
            }
            case GRAVE_GUARDIAN: {
                builder.withIcon((ItemLike)Items.f_42678_);
                break;
            }
            case SOUL: {
                builder.withIcon(ItemAdvancement.IconType.ACTIVATE_MAGIC_ITEM);
                break;
            }
            case RECEPTACLE_OF_SOUL: {
                builder.withIcon((ItemLike)ModItems.receptacle_of_soul);
                break;
            }
            case STRANGE_SCROLL: {
                builder.withIcon((ItemLike)ModItems.strange_scroll).withRecipe("tombstone:strange_scroll");
                break;
            }
            case STRANGE_TABLET: {
                builder.withIcon((ItemLike)ModItems.strange_tablet).withRecipe("tombstone:strange_tablet");
                break;
            }
            case TABLET_OF_HOME: {
                builder.withIcon((ItemLike)ModItems.tablet_of_home).withRecipe(ModItems.strange_tablet, ModItems.tablet_of_home);
                break;
            }
            case TABLET_OF_RECALL: {
                builder.withIcon((ItemLike)ModItems.tablet_of_recall).withRecipe(ModItems.strange_tablet, ModItems.tablet_of_recall);
                break;
            }
            case TABLET_OF_ASSISTANCE: {
                builder.withIcon((ItemLike)ModItems.tablet_of_assistance).withRecipe(ModItems.strange_tablet, ModItems.tablet_of_assistance);
                break;
            }
            case TABLET_OF_CUPIDITY: {
                builder.withIcon((ItemLike)ModItems.tablet_of_cupidity).withRecipe(ModItems.strange_tablet, ModItems.tablet_of_cupidity);
                break;
            }
            case TABLET_OF_GUARD: {
                builder.withIcon((ItemLike)ModItems.tablet_of_guard).withRecipe(ModItems.strange_tablet, ModItems.tablet_of_guard);
                break;
            }
            case MAGIC_TABLETS: {
                builder.withIcon((ItemLike)ModItems.strange_tablet);
                break;
            }
            case VOODOO_POPPET: {
                builder.withIcon((ItemLike)ModItems.voodoo_poppet).withRecipe("tombstone:voodoo_poppet");
            }
        }
        switch (info) {
            case COMPENDIUM: {
                builder.withLinks(CompendiumLabel.DEATH, CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.COMBINATION, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.ENCHANTMENTS, CompendiumLabel.PRAYER, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.SPECIAL_THANKS);
                break;
            }
            case ALIGNMENT: {
                builder.withLinks(CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.PRAYER);
                break;
            }
            case ANKH_OF_PRAYER: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.ALIGNMENT, CompendiumLabel.PRAYER);
                break;
            }
            case BONE_NEEDLE: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.IMPREGNATED_DIAMOND, CompendiumLabel.RECEPTACLE_OF_FAMILIAR);
                break;
            }
            case COMBINATION: {
                break;
            }
            case HALLOWEEN: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.CHRISTMAS, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.LOLLIPOP);
                break;
            }
            case CHRISTMAS: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.HALLOWEEN, CompendiumLabel.LOLLIPOP);
                break;
            }
            case APRIL_FOOLS_DAY: {
                builder.withLinks(CompendiumLabel.SPECIAL_BONUS, CompendiumLabel.CHRISTMAS, CompendiumLabel.HALLOWEEN);
                break;
            }
            case GRAVE_MARBLE: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.GRAVE_DUST);
                break;
            }
            case DEATH: {
                builder.withLinks(CompendiumLabel.GHOSTLY_SHAPE, CompendiumLabel.GRAVE_KEY, CompendiumLabel.PERK);
                break;
            }
            case DECORATIVE_GRAVE: {
                builder.withLinks(CompendiumLabel.GRAVE_MARBLE, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL, CompendiumLabel.GRAVE_PLATE, CompendiumLabel.ESSENCE_OF_UNDEATH, CompendiumLabel.GRAVE_GUARDIAN, CompendiumLabel.PRAYER);
                break;
            }
            case DUST_OF_VANISHING: 
            case DUST_OF_FROST: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case ENCHANTMENTS: {
                builder.withLinks(CompendiumLabel.SPECTRAL_BITE, CompendiumLabel.SOULBOUND, CompendiumLabel.MAGIC_SIPHON, CompendiumLabel.PLAGUE_BRINGER, CompendiumLabel.CURSE_OF_BONES, CompendiumLabel.BLESSING, CompendiumLabel.FROSTBITE, CompendiumLabel.SPECTRAL_CONJURER);
                break;
            }
            case SPECTRAL_BITE: 
            case SOULBOUND: 
            case MAGIC_SIPHON: 
            case PLAGUE_BRINGER: 
            case CURSE_OF_BONES: 
            case BLESSING: 
            case FROSTBITE: 
            case SPECTRAL_CONJURER: {
                builder.withLinks(CompendiumLabel.ENCHANTMENTS);
                break;
            }
            case ESSENCE_OF_UNDEATH: 
            case GRAVE_PLATE: 
            case GRAVE_GUARDIAN: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE);
                break;
            }
            case RECEPTACLE_OF_FAMILIAR: {
                builder.withLinks(CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.IMPREGNATED_DIAMOND, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL, CompendiumLabel.BONE_NEEDLE);
                break;
            }
            case FISHING_ROD_OF_MISADVENTURE: {
                builder.withLinks(CompendiumLabel.LOST_TABLET, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL);
                break;
            }
            case GHOSTLY_SHAPE: {
                builder.withLinks(CompendiumLabel.DEATH);
                break;
            }
            case GRAVE_DUST: {
                builder.withLinks(CompendiumLabel.GRAVE_MARBLE, CompendiumLabel.DUST_OF_VANISHING, CompendiumLabel.DUST_OF_FROST, CompendiumLabel.IMPREGNATED_DIAMOND, CompendiumLabel.BONE_NEEDLE);
                break;
            }
            case GRAVE_KEY: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.DEATH, CompendiumLabel.SOUL);
                break;
            }
            case KNOWLEDGE_OF_DEATH: {
                builder.withLinks(CompendiumLabel.ALIGNMENT, CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.SOUL, CompendiumLabel.RECEPTACLE_OF_SOUL);
                break;
            }
            case IMPREGNATED_DIAMOND: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.BONE_NEEDLE);
                break;
            }
            case LOLLIPOP: {
                builder.withLinks(CompendiumLabel.HALLOWEEN, CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case EASTER_EGG: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case LOST_TABLET: {
                builder.withLinks(CompendiumLabel.FISHING_ROD_OF_MISADVENTURE, CompendiumLabel.MAGIC_TABLETS, CompendiumLabel.PERK, CompendiumLabel.SOUL);
                break;
            }
            case MAGIC_ITEMS: {
                builder.withLinks(CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.MAGIC_BOOKS, CompendiumLabel.DUST_OF_VANISHING, CompendiumLabel.DUST_OF_FROST, CompendiumLabel.ENCHANTED_BUNDLE, CompendiumLabel.RECEPTACLE_OF_FAMILIAR, CompendiumLabel.FISHING_ROD_OF_MISADVENTURE, CompendiumLabel.GRAVE_KEY, CompendiumLabel.LOLLIPOP, CompendiumLabel.EASTER_EGG, CompendiumLabel.MAGIC_SCROLLS, CompendiumLabel.MAGIC_TABLETS, CompendiumLabel.RECEPTACLE_OF_SOUL, CompendiumLabel.VOODOO_POPPET);
                break;
            }
            case MAGIC_BOOKS: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.BOOK_OF_DISENCHANTMENT, CompendiumLabel.BOOK_OF_RECYCLING, CompendiumLabel.BOOK_OF_REPAIRING, CompendiumLabel.BOOK_OF_SCRIBE, CompendiumLabel.BOOK_OF_MAGIC_IMPREGNATION, CompendiumLabel.BOOK_OF_SOULBOUND, CompendiumLabel.BOOK_OF_OBLIVION);
                break;
            }
            case BOOK_OF_DISENCHANTMENT: 
            case BOOK_OF_RECYCLING: 
            case BOOK_OF_REPAIRING: 
            case BOOK_OF_SCRIBE: 
            case BOOK_OF_MAGIC_IMPREGNATION: 
            case BOOK_OF_SOULBOUND: 
            case BOOK_OF_OBLIVION: {
                builder.withLinks(CompendiumLabel.MAGIC_BOOKS);
                break;
            }
            case MAGIC_SCROLLS: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.STRANGE_SCROLL, CompendiumLabel.SCROLL_OF_AQUATIC_LIFE, CompendiumLabel.SCROLL_OF_FEATHER_FALL, CompendiumLabel.SCROLL_OF_FROST_RESISTANCE, CompendiumLabel.SCROLL_OF_KNOWLEDGE, CompendiumLabel.SCROLL_OF_LIGHTNING_RESISTANCE, CompendiumLabel.SCROLL_OF_PRESERVATION, CompendiumLabel.SCROLL_OF_PURIFICATION, CompendiumLabel.SCROLL_OF_REACH, CompendiumLabel.SCROLL_OF_TRUE_SIGHT, CompendiumLabel.SCROLL_OF_UNSTABLE_INTANGIBILITY, CompendiumLabel.SCROLL_OF_MERCY);
                break;
            }
            case SCROLL_OF_FEATHER_FALL: 
            case SCROLL_OF_KNOWLEDGE: 
            case SCROLL_OF_PRESERVATION: 
            case SCROLL_OF_PURIFICATION: 
            case SCROLL_OF_TRUE_SIGHT: 
            case SCROLL_OF_UNSTABLE_INTANGIBILITY: 
            case SCROLL_OF_REACH: 
            case SCROLL_OF_LIGHTNING_RESISTANCE: 
            case SCROLL_OF_FROST_RESISTANCE: 
            case SCROLL_OF_AQUATIC_LIFE: 
            case SCROLL_OF_MERCY: {
                builder.withLinks(CompendiumLabel.MAGIC_SCROLLS);
                break;
            }
            case STRANGE_SCROLL: {
                builder.withLinks(CompendiumLabel.GRAVE_DUST, CompendiumLabel.MAGIC_SCROLLS);
                break;
            }
            case MAGIC_TABLETS: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.PERK, CompendiumLabel.SOUL, CompendiumLabel.STRANGE_TABLET, CompendiumLabel.LOST_TABLET, CompendiumLabel.TABLET_OF_ASSISTANCE, CompendiumLabel.TABLET_OF_CUPIDITY, CompendiumLabel.TABLET_OF_HOME, CompendiumLabel.TABLET_OF_RECALL, CompendiumLabel.TABLET_OF_GUARD);
                break;
            }
            case TABLET_OF_HOME: 
            case TABLET_OF_RECALL: 
            case TABLET_OF_ASSISTANCE: 
            case TABLET_OF_CUPIDITY: 
            case TABLET_OF_GUARD: {
                builder.withLinks(CompendiumLabel.MAGIC_TABLETS);
                break;
            }
            case STRANGE_TABLET: {
                builder.withLinks(CompendiumLabel.GRAVE_MARBLE, CompendiumLabel.GRAVE_DUST, CompendiumLabel.MAGIC_TABLETS);
                break;
            }
            case PERK: {
                builder.withLinks(CompendiumLabel.DEATH, CompendiumLabel.GHOSTLY_SHAPE, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS);
                break;
            }
            case PRAYER: {
                builder.withLinks(CompendiumLabel.ANKH_OF_PRAYER, CompendiumLabel.ALIGNMENT, CompendiumLabel.DECORATIVE_GRAVE);
                break;
            }
            case SOUL: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.RECEPTACLE_OF_SOUL);
                break;
            }
            case RECEPTACLE_OF_SOUL: {
                builder.withLinks(CompendiumLabel.DECORATIVE_GRAVE, CompendiumLabel.KNOWLEDGE_OF_DEATH, CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL);
                break;
            }
            case SPECIAL_BONUS: {
                builder.withLinks(CompendiumLabel.HALLOWEEN, CompendiumLabel.APRIL_FOOLS_DAY, CompendiumLabel.CHRISTMAS);
                break;
            }
            case ENCHANTED_BUNDLE: 
            case VOODOO_POPPET: {
                builder.withLinks(CompendiumLabel.MAGIC_ITEMS, CompendiumLabel.SOUL);
            }
        }
        return builder.build();
    }

    public static enum CompendiumLabel {
        ALIGNMENT("tombstone.message.alignment"),
        ANKH_OF_PRAYER("tombstone.item.ankh_of_prayer"),
        APRIL_FOOLS_DAY,
        BLESSING("enchantment.tombstone.blessing"),
        BONE_NEEDLE("tombstone.item.bone_needle"),
        BOOK_OF_DISENCHANTMENT("tombstone.item.book_of_disenchantment"),
        BOOK_OF_RECYCLING("tombstone.item.book_of_recycling"),
        BOOK_OF_REPAIRING("tombstone.item.book_of_repairing"),
        BOOK_OF_SCRIBE("tombstone.item.book_of_scribe"),
        BOOK_OF_MAGIC_IMPREGNATION("tombstone.item.book_of_magic_impregnation"),
        BOOK_OF_SOULBOUND("tombstone.item.book_of_soulbound"),
        BOOK_OF_OBLIVION("tombstone.item.book_of_oblivion"),
        CHRISTMAS("tombstone.advancement.christmas.title"),
        COMBINATION,
        COMPENDIUM(LangKey.MESSAGE_COMPENDIUM.getKey()),
        CURSE_OF_BONES("enchantment.tombstone.curse_of_bones"),
        DECORATIVE_GRAVE("tombstone.config_cat.decorative_grave"),
        DEATH,
        DUST_OF_VANISHING("tombstone.item.dust_of_vanishing"),
        DUST_OF_FROST("tombstone.item.dust_of_frost"),
        ENCHANTED_BUNDLE("tombstone.item.enchanted_bundle"),
        ENCHANTMENTS,
        ESSENCE_OF_UNDEATH("tombstone.item.essence_of_undeath"),
        RECEPTACLE_OF_FAMILIAR("tombstone.item.receptacle_of_familiar"),
        FISHING_ROD_OF_MISADVENTURE("tombstone.item.fishing_rod_of_misadventure"),
        FROSTBITE("enchantment.tombstone.frostbite"),
        GHOSTLY_SHAPE("effect.tombstone.ghostly_shape"),
        GRAVE_DUST("tombstone.item.grave_dust"),
        GRAVE_GUARDIAN("entity.tombstone.grave_guardian"),
        GRAVE_KEY("tombstone.item.grave_key"),
        GRAVE_MARBLE("tombstone.block.dark_marble"),
        GRAVE_PLATE("tombstone.item.grave_plate"),
        HALLOWEEN,
        IMPREGNATED_DIAMOND("tombstone.item.impregnated_diamond"),
        KNOWLEDGE_OF_DEATH("tombstone.message.knowledge_of_death"),
        LOLLIPOP("tombstone.item.lollipop"),
        EASTER_EGG("tombstone.item.easter_egg"),
        LOST_TABLET("tombstone.item.lost_tablet"),
        MAGIC_BOOKS,
        MAGIC_ITEMS,
        MAGIC_SCROLLS,
        MAGIC_SIPHON("enchantment.tombstone.magic_siphon"),
        MAGIC_TABLETS,
        PERK,
        PLAGUE_BRINGER("enchantment.tombstone.plague_bringer"),
        PRAYER,
        SCROLL_OF_AQUATIC_LIFE("tombstone.item.scroll_of_aquatic_life"),
        SCROLL_OF_FEATHER_FALL("tombstone.item.scroll_of_feather_fall"),
        SCROLL_OF_FROST_RESISTANCE("tombstone.item.scroll_of_frost_resistance"),
        SCROLL_OF_KNOWLEDGE("tombstone.item.scroll_of_knowledge"),
        SCROLL_OF_LIGHTNING_RESISTANCE("tombstone.item.scroll_of_lightning_resistance"),
        SCROLL_OF_MERCY("tombstone.item.scroll_of_mercy"),
        SCROLL_OF_PRESERVATION("tombstone.item.scroll_of_preservation"),
        SCROLL_OF_PURIFICATION("tombstone.item.scroll_of_purification"),
        SCROLL_OF_REACH("tombstone.item.scroll_of_reach"),
        SCROLL_OF_TRUE_SIGHT("tombstone.item.scroll_of_true_sight"),
        SCROLL_OF_UNSTABLE_INTANGIBILITY("tombstone.item.scroll_of_unstable_intangibility"),
        SPECTRAL_BITE("enchantment.tombstone.spectral_bite"),
        SPECTRAL_CONJURER("enchantment.tombstone.spectral_conjurer"),
        SOUL,
        RECEPTACLE_OF_SOUL("tombstone.item.receptacle_of_soul"),
        SOULBOUND("enchantment.tombstone.soulbound"),
        SPECIAL_BONUS,
        SPECIAL_THANKS((Component)Component.m_237113_((String)"Special Thanks")),
        STRANGE_SCROLL("tombstone.item.strange_scroll"),
        STRANGE_TABLET("tombstone.item.strange_tablet"),
        TABLET_OF_ASSISTANCE("tombstone.item.tablet_of_assistance"),
        TABLET_OF_CUPIDITY("tombstone.item.tablet_of_cupidity"),
        TABLET_OF_HOME("tombstone.item.tablet_of_home"),
        TABLET_OF_RECALL("tombstone.item.tablet_of_recall"),
        TABLET_OF_GUARD("tombstone.item.tablet_of_guard"),
        VOODOO_POPPET("tombstone.item.voodoo_poppet");

        private final Component title;

        private CompendiumLabel(String translation) {
            this((Component)Component.m_237115_((String)translation));
        }

        private CompendiumLabel(Component compo) {
            this.title = compo;
        }

        private CompendiumLabel() {
            this.title = Component.m_237115_((String)("tombstone.compendium." + this.name().toLowerCase(Locale.US) + ".title"));
        }

        Component getTitle() {
            return FontHelper.withFantasyFont(this.title);
        }

        @Nullable
        public static CompendiumLabel fromString(String label) {
            return Arrays.stream(CompendiumLabel.values()).filter(l -> l.name().equalsIgnoreCase(label)).findFirst().orElse(null);
        }
    }

    static final class Builder {
        private final CompendiumLabel info;
        private ItemStack icon = ItemStack.f_41583_;
        private Component description;
        private List<CompendiumLabel> links = Collections.emptyList();
        private final List<CompendiumRecipe> recipes = new ArrayList<CompendiumRecipe>();

        Builder(CompendiumLabel info) {
            this.info = info;
            this.description = Component.m_237115_((String)("tombstone.compendium." + info.name().toLowerCase(Locale.US) + ".desc"));
        }

        Builder withIcon(ItemScrollBuff.SpellBuff spellBuff) {
            return this.withIcon((ItemLike)spellBuff.getItem());
        }

        Builder withIcon(ItemAdvancement.IconType iconType) {
            return this.withIcon(iconType.getItemStack());
        }

        Builder withIcon(ItemLike item) {
            return this.withIcon(new ItemStack((ItemLike)item.m_5456_()));
        }

        Builder withIcon(ItemStack icon) {
            this.icon = icon;
            return this;
        }

        Builder withDescription(String description) {
            this.description = Component.m_237115_((String)description);
            return this;
        }

        Builder withDescriptionAsText(String description) {
            this.description = Component.m_237113_((String)description);
            return this;
        }

        Builder withLinks(CompendiumLabel ... links) {
            this.links = this.info == CompendiumLabel.COMPENDIUM ? Arrays.stream(links).toList() : Arrays.stream(links).sorted(Comparator.comparing(p -> Normalizer.normalize(p.getTitle().getString(), Normalizer.Form.NFD))).toList();
            return this;
        }

        Builder withRecipe(String recipeRL) {
            Optional.ofNullable(Minecraft.m_91087_().f_91073_).map(l -> l.m_7465_().m_44043_(new ResourceLocation(recipeRL))).filter(Optional::isPresent).map(Optional::get).ifPresent(recipe -> this.recipes.add(new CompendiumCraftingRecipe((Recipe<?>)recipe)));
            return this;
        }

        <T extends Item> Builder withRecipe(T combinable, Item result) {
            Optional.ofNullable(((ICombineCraft)combinable).fromResult(result)).ifPresent(recipe -> this.recipes.add(new CompendiumCombinationRecipe(combinable, (CombineCraft)recipe)));
            return this;
        }

        CompendiumData build() {
            return new CompendiumData(this.info, this.icon, this.description, this.links, this.recipes);
        }
    }

    static abstract class CompendiumRecipe {
        final ItemStack result;
        final List<Ingredient> ingredients;

        CompendiumRecipe(ItemStack result, List<Ingredient> ingredients) {
            this.result = result;
            this.ingredients = ingredients;
        }

        abstract void render(GuiGraphics var1, int var2, int var3);
    }

    static final class CompendiumCombinationRecipe
    extends CompendiumRecipe {
        private final CombineCraft combine;

        <T extends Item> CompendiumCombinationRecipe(T combinable, CombineCraft combine) {
            super(combine.result(), Arrays.asList(Ingredient.m_43929_((ItemLike[])new ItemLike[]{combinable}), combine.ingredient()));
            this.combine = combine;
        }

        @Override
        void render(GuiGraphics guiGraphics, int minX, int minY) {
            ClientTooltipCombineCraft.render(guiGraphics, minX, minY, ((Ingredient)this.ingredients.get(0)).m_43908_()[0], List.of(this.combine), false);
        }
    }

    static final class CompendiumCraftingRecipe
    extends CompendiumRecipe {
        CompendiumCraftingRecipe(Recipe<?> recipe) {
            super(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), (List<Ingredient>)recipe.m_7527_());
        }

        @Override
        void render(GuiGraphics guiGraphics, int minX, int minY) {
            List ingredients = this.ingredients;
            guiGraphics.m_280509_(minX, minY, minX + 53, minY + 53, 1082163455);
            guiGraphics.m_280656_(minX, minX + 53, minY + 17, -1);
            guiGraphics.m_280656_(minX, minX + 53, minY + 35, -1);
            guiGraphics.m_280315_(minX + 17, minY, minY + 53, -1);
            guiGraphics.m_280315_(minX + 35, minY, minY + 53, -1);
            boolean isDecorativeGrave = this.result.m_204117_(ModTags.Items.decorative_graves) && TimeHelper.inIntervalBefore(TimeHelper.systemTime() / 50L, 60, 30);
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (ingredient.m_43947_()) continue;
                ItemStack firstItem = ingredient.m_43908_()[0];
                if (isDecorativeGrave && firstItem.m_150930_(ModBlocks.dark_marble.m_5456_())) {
                    firstItem = new ItemStack((ItemLike)ModBlocks.white_marble);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int x = minX + i % 3 * 18;
                int y = minY + i / 3 * 18;
                guiGraphics.m_280480_(firstItem, x, y);
            }
        }
    }
}

