/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfCupidity.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        this.addItemDesc(tooltip, this.isAncient(stack) ? "_ancient" : "_not_ancient", new Object[0]);
        this.addItemUse(tooltip, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    protected int getUseMax() {
        return 1;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            this.setUseCount(stack, this.getUseMax());
            NBTStackHelper.setBoolean(stack, "enchant", true);
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                return ISoulConsumer.ConsumeResult.success(2);
            }
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        boolean isAncient = this.isAncient(stack);
        BlockPos spawnerPos = Helper.getRandomInList(world.f_151512_.stream().filter(tileTicker -> {
            try {
                BlockEntity blockEntity = ((LevelChunk.BoundTickingBlockEntity)((LevelChunk.RebindableTickingBlockEntityWrapper)tileTicker).f_156444_).f_156428_;
                if (!isAncient) {
                    if (blockEntity instanceof SpawnerBlockEntity) return true;
                }
                if (!(blockEntity instanceof ChestBlockEntity)) return false;
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                if (chestBlockEntity.f_59605_ == null) return false;
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }).map(TickingBlockEntity::m_142689_).collect(Collectors.toList())).orElse(null);
        if (spawnerPos != null && Helper.isValidPos((Level)world, spawnerPos)) {
            world.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(spawnerPos), 1, (Object)player.m_19879_());
            Location spawnPos = new SpawnHelper(world, spawnerPos).findSpawnPlace();
            if (!spawnPos.isOrigin()) {
                CallbackHandler.addFastCallback(() -> {
                    ServerPlayer newPlayer = Helper.teleport(player, spawnPos, world);
                    LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
                    if (isAncient) {
                        EffectHelper.addRandomEffect((Player)newPlayer, 6000, true, false, true);
                    } else {
                        newPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.rewardAlignment(newPlayer, (Integer)ConfigTombstone.alignment.pointsTabletOfCupidity.get()));
                        EffectHelper.addRandomEffect((Player)newPlayer, 1200, true, true, false);
                        if (Helper.RANDOM.nextInt(5) == 0 && world.m_6106_().m_5472_() != Difficulty.PEACEFUL) {
                            IntStream.range(0, Helper.RANDOM.nextInt(3) + 1).forEach(i -> Helper.spawnRandomMob(world, spawnPos.getPos()));
                        }
                    }
                    ModTriggers.USE_CUPIDITY.trigger(newPlayer);
                });
                return true;
            }
        }
        LangKey.MESSAGE_TABLET_SEARCH_FAILED.sendMessage((Player)player, new Object[0]);
        return false;
    }
}

