/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.capability.SoulConsumerBundle;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.item.ITab;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

public final class ModTabs {
    public static final ResourceLocation TAB_ID = new ResourceLocation("tombstone");
    public static final ResourceLocation TAB_MAGIC_SCROLLS = new ResourceLocation("tombstone", "magic_scrolls");

    public static void onRegisterCreativeTab(RegisterEvent event) {
        event.register(Registries.f_279569_, TAB_ID, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237113_((String)"Corail Tombstone")).m_257737_(() -> new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE))).m_257501_((params, output) -> {
            Arrays.stream(GraveModel.values()).forEach(graveModel -> IntStream.range(0, BlockGraveMarble.MarbleType.values().length).mapToObj(textureId -> ItemBlockGrave.createDecorativeStack(graveModel, textureId)).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0)));
            output.m_246326_((ItemLike)ModBlocks.dark_marble);
            output.m_246326_((ItemLike)ModBlocks.white_marble);
            output.m_246326_((ItemLike)ModBlocks.blue_marble);
            output.m_246326_((ItemLike)ModBlocks.green_marble);
            output.m_246326_((ItemLike)ModBlocks.carmin_marble);
            output.m_246326_((ItemLike)ModBlocks.dark_marble_slab);
            output.m_246326_((ItemLike)ModBlocks.white_marble_slab);
            output.m_246326_((ItemLike)ModBlocks.blue_marble_slab);
            output.m_246326_((ItemLike)ModBlocks.green_marble_slab);
            output.m_246326_((ItemLike)ModBlocks.carmin_marble_slab);
            output.m_246326_((ItemLike)ModBlocks.dark_marble_stairs);
            output.m_246326_((ItemLike)ModBlocks.white_marble_stairs);
            output.m_246326_((ItemLike)ModBlocks.blue_marble_stairs);
            output.m_246326_((ItemLike)ModBlocks.green_marble_stairs);
            output.m_246326_((ItemLike)ModBlocks.carmin_marble_stairs);
            output.m_246326_((ItemLike)ModBlocks.dark_marble_wall);
            output.m_246326_((ItemLike)ModBlocks.white_marble_wall);
            output.m_246326_((ItemLike)ModBlocks.blue_marble_wall);
            output.m_246326_((ItemLike)ModBlocks.green_marble_wall);
            output.m_246326_((ItemLike)ModBlocks.carmin_marble_wall);
            ModItems.ITEMS.forEach(item -> {
                if (item instanceof ITab) {
                    ((ITab)item).fillItemCategory(output);
                } else {
                    output.m_246326_((ItemLike)item);
                }
            });
            output.m_246342_(SoulConsumerBundle.setEnchanted(new ItemStack((ItemLike)Items.f_151058_)));
            output.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.bait));
            output.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.frostbite));
            output.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.frostbite, 2));
            output.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.frostbite, 4));
            output.m_246342_(EffectHelper.createMagicArrows(1, MobEffects.f_216964_));
            output.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.restoration));
            output.m_246342_(EffectHelper.createCursedArrows(1));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.spectral));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.earthly_garden));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.discretion));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.restoration));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.bait));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.frostbite));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.darkness));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.restoration));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.bait));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.frostbite));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.darkness));
            output.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.restoration));
            ModTabs.fillWithEnchantedBook(output);
        }).withSearchBar().m_257652_());
        event.register(Registries.f_279569_, TAB_MAGIC_SCROLLS, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237113_((String)"Magic Scrolls")).m_257737_(() -> ModItems.magic_scroll.setRandomMagicEffect(ModItems.magic_scroll.createAncient())).m_257501_((params, output) -> {
            if (ModItems.magic_scroll.isEnabled()) {
                ForgeRegistries.MOB_EFFECTS.getEntries().stream().filter(entry -> !((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("tombstone")).map(Map.Entry::getValue).filter(EffectHelper::isAllowedEffect).forEach(effect -> {
                    output.m_246342_(ModItems.magic_scroll.setMagicEffect(new ItemStack((ItemLike)ModItems.magic_scroll), (MobEffect)effect, 4));
                    output.m_246342_(ModItems.magic_scroll.setMagicEffect(ModItems.magic_scroll.createAncient(), (MobEffect)effect, 4));
                });
            }
        }).withSearchBar().withTabsBefore(new ResourceLocation[]{TAB_ID}).m_257652_());
    }

    private static void fillWithEnchantedBook(CreativeModeTab.Output items) {
        ModEnchantments.getEnchantments().values().stream().filter(TombstoneEnchantment::isEnabled).forEach(enchantment -> {
            items.m_246342_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment, 1)));
            int maxLevel = Helper.getMaxLevel(enchantment);
            for (int level = 5; level <= maxLevel; level += 5) {
                items.m_246342_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment, level)));
            }
            if (maxLevel > 1 && maxLevel % 5 != 0) {
                items.m_246342_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment, maxLevel)));
            }
        });
    }
}

