/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.networkstats;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import com.connectivity.networkstats.IWrappedPacket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NetworkStatGatherer {
    private static volatile Map<String, ConcurrentHashMap<String, PacketData>> connectionPacketData = new ConcurrentHashMap<String, ConcurrentHashMap<String, PacketData>>();
    private static final int recordingDuration = ((CommonConfiguration)Connectivity.config.getCommonConfig()).packetHistoryMinutes;
    private static List<Map<String, ConcurrentHashMap<String, PacketData>>> minuteData = new ArrayList<Map<String, ConcurrentHashMap<String, PacketData>>>(recordingDuration);
    static int index = 0;

    public static void add(String remoteAddress, Packet packet, int packetSize) {
        String packetName = packet.getClass().getSimpleName();
        if (packet instanceof IWrappedPacket && ((IWrappedPacket)packet).getOriginalMsg() != null) {
            packetName = ((IWrappedPacket)packet).getOriginalMsg().getClass().getSimpleName();
        }
        PacketData data = connectionPacketData.computeIfAbsent(remoteAddress, remote -> new ConcurrentHashMap()).computeIfAbsent(packetName, name -> new PacketData((String)name));
        if (data.maxPacketBytes < packetSize) {
            data.largestPacket = packet;
        }
        data.add(packetSize);
    }

    public static void saveData() {
        if (++index >= recordingDuration) {
            index = 0;
        }
        minuteData.set(index, connectionPacketData);
        connectionPacketData = new ConcurrentHashMap<String, ConcurrentHashMap<String, PacketData>>();
    }

    public static PlayerPacketDataEntry getDataForPlayer(ServerPlayer playerEntity, int minutes) {
        String id = playerEntity.f_8906_.m_264262_().toString();
        HashMap<String, PacketData> gatherMap = new HashMap<String, PacketData>();
        int timeMinutes = minutes;
        for (int i = 0; i < minutes; ++i) {
            int preIndex = Math.abs((index - i) % recordingDuration);
            Map<String, ConcurrentHashMap<String, PacketData>> data2 = minuteData.get(preIndex);
            if (data2 != null && data2.containsKey(id)) {
                NetworkStatGatherer.condenseDataToMap(data2.get(id).values(), gatherMap);
            }
            if (data2 != null) continue;
            --timeMinutes;
        }
        ArrayList<PacketData> dataList = new ArrayList<PacketData>(gatherMap.values());
        dataList.sort(Comparator.comparingLong(data -> data.totalPacketBytes).reversed());
        NetworkStatGatherer.calculateThroughput(dataList, timeMinutes);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData entry : dataList) {
            totalBytes += entry.totalPacketBytes;
            totalRate += entry.rate;
        }
        return new PlayerPacketDataEntry(dataList, totalBytes, totalRate, playerEntity);
    }

    public static List<PacketData> getDataByPacket(int minutes) {
        HashMap<String, PacketData> gatherMap = new HashMap<String, PacketData>();
        int timeMinutes = minutes;
        for (int i = 0; i < minutes; ++i) {
            int preIndex = Math.abs((index - i) % recordingDuration);
            Map<String, ConcurrentHashMap<String, PacketData>> data2 = minuteData.get(preIndex);
            if (data2 != null) {
                for (Map.Entry<String, ConcurrentHashMap<String, PacketData>> entry : data2.entrySet()) {
                    NetworkStatGatherer.condenseDataToMap(entry.getValue().values(), gatherMap);
                }
                continue;
            }
            --timeMinutes;
        }
        ArrayList<PacketData> result = new ArrayList<PacketData>(gatherMap.values());
        result.sort(Comparator.comparingLong(data -> data.totalPacketBytes).reversed());
        NetworkStatGatherer.calculateThroughput(result, timeMinutes);
        return result;
    }

    private static void calculateThroughput(Collection<PacketData> data, int minutes) {
        if (minutes <= 0) {
            return;
        }
        for (PacketData packetData : data) {
            packetData.rate = (double)((float)packetData.totalPacketBytes / ((float)minutes * 60.0f)) / 1000.0;
        }
    }

    private static void condenseDataToMap(Collection<PacketData> insertData, Map<String, PacketData> dataMap) {
        if (insertData == null) {
            return;
        }
        for (PacketData data : insertData) {
            if (dataMap.containsKey(data.packetName)) {
                PacketData existing = dataMap.get(data.packetName);
                existing.totalPacketBytes += data.totalPacketBytes;
                existing.packetCount += data.packetCount;
                if (existing.maxPacketBytes < data.maxPacketBytes && data.largestPacket != null) {
                    existing.largestPacket = data.largestPacket;
                }
                existing.maxPacketBytes = Math.max(existing.maxPacketBytes, data.maxPacketBytes);
                continue;
            }
            PacketData newData = new PacketData(data.packetName);
            newData.totalPacketBytes = data.totalPacketBytes;
            newData.maxPacketBytes = data.maxPacketBytes;
            newData.packetCount = data.packetCount;
            newData.largestPacket = data.largestPacket;
            dataMap.put(data.packetName, newData);
        }
    }

    public static void reportAllPlayerSummary(CommandSourceStack source, int minutes, int startIndex) {
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
        Style BLUE = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
        Style RED = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
        ArrayList<PlayerPacketDataEntry> playerData = new ArrayList<PlayerPacketDataEntry>();
        for (ServerPlayer player : source.m_81372_().m_7654_().m_6846_().m_11314_()) {
            playerData.add(NetworkStatGatherer.getDataForPlayer(player, minutes));
        }
        playerData.sort(Comparator.comparingLong(data -> data.totalBytes).reversed());
        source.m_243053_((Component)Component.m_237113_((String)("Network players summary of last " + minutes + " minutes.")));
        long byteSum = 0L;
        for (PlayerPacketDataEntry packetData : playerData) {
            byteSum += packetData.totalBytes;
        }
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < playerData.size(); ++i) {
            PlayerPacketDataEntry playerPacketDataEntry = (PlayerPacketDataEntry)playerData.get(i);
            source.m_243053_((Component)Component.m_237113_((String)(percent.format((double)playerPacketDataEntry.totalBytes / (double)byteSum * 100.0) + "% ")).m_7220_((Component)Component.m_237113_((String)(playerPacketDataEntry.playerEntity.m_7755_().getString() + " "))).m_6270_(GREEN_BOLD).m_7220_((Component)Component.m_237113_((String)("r: " + percent.format(playerPacketDataEntry.totalRate) + "kb/s ")).m_6270_(BLUE)).m_7220_((Component)Component.m_237113_((String)("total sent: " + percent.format((double)playerPacketDataEntry.totalBytes / 1000.0) + "kb")).m_6270_(RED)));
        }
        if (i + 1 < playerData.size()) {
            source.m_243053_((Component)Component.m_237113_((String)"next --->").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsAllPlayers %d %d", minutes, i)))));
        }
    }

    public static void reportStatsSummary(CommandSourceStack source, int minutes, int startIndex) {
        List<PacketData> data = NetworkStatGatherer.getDataByPacket(minutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
        Style BLUE = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
        Style YELLOW = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW));
        Style RED = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
        Style GOLD = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
        source.m_243053_((Component)Component.m_237113_((String)("Network packet summary of last " + minutes + " minutes.")));
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        source.m_243053_((Component)Component.m_237113_((String)("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate))).m_6270_(GOLD));
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            source.m_243053_((Component)Component.m_237113_((String)(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ")).m_7220_((Component)Component.m_237113_((String)(packetData.packetName + " "))).m_6270_(GREEN_BOLD).m_7220_((Component)Component.m_237113_((String)("r: " + percent.format(packetData.rate) + "kb/s ")).m_6270_(BLUE)).m_7220_((Component)Component.m_237113_((String)("count:" + packetData.packetCount + " ")).m_6270_(YELLOW)).m_7220_((Component)Component.m_237113_((String)("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb")).m_6270_(RED)));
        }
        if (i + 1 < data.size()) {
            source.m_243053_((Component)Component.m_237113_((String)"next --->").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsSummary %d %d", minutes, i)))));
        }
    }

    public static void reportPlayerSummary(CommandSourceStack source, ServerPlayer playerEntity, int minutes, int startIndex) {
        if (playerEntity == null) {
            source.m_243053_((Component)Component.m_237113_((String)"Player not found"));
            return;
        }
        PlayerPacketDataEntry playerPacketData = NetworkStatGatherer.getDataForPlayer(playerEntity, minutes);
        List<PacketData> data = playerPacketData.packetData;
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
        Style BLUE = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
        Style YELLOW = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW));
        Style RED = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
        Style GOLD = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
        source.m_243053_((Component)Component.m_237113_((String)("Network packet summary for " + playerEntity.m_7755_().getString() + " of last " + minutes + " minutes.")));
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        source.m_243053_((Component)Component.m_237113_((String)("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate))).m_6270_(GOLD));
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            source.m_243053_((Component)Component.m_237113_((String)(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ")).m_7220_((Component)Component.m_237113_((String)(packetData.packetName + " "))).m_6270_(GREEN_BOLD).m_7220_((Component)Component.m_237113_((String)("r: " + percent.format(packetData.rate) + "kb/s ")).m_6270_(BLUE)).m_7220_((Component)Component.m_237113_((String)("count:" + packetData.packetCount + " ")).m_6270_(YELLOW)).m_7220_((Component)Component.m_237113_((String)("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb")).m_6270_(RED)));
        }
        if (i + 1 < data.size()) {
            source.m_243053_((Component)Component.m_237113_((String)"next --->").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsPlayer %s %d %d", playerEntity.m_7755_().getString(), minutes, i)))));
        }
    }

    public static void reportClientStatsSummary(Player playerEntity, int minutes, int startIndex) {
        if (playerEntity == null) {
            return;
        }
        List<PacketData> data = NetworkStatGatherer.getDataByPacket(minutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
        Style BLUE = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
        Style YELLOW = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW));
        Style RED = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
        Style GOLD = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
        playerEntity.m_5661_((Component)Component.m_237113_((String)("Network outgoing packet summary of last " + minutes + " minutes.")), false);
        long totalBytes = 0L;
        double totalRate = 0.0;
        for (PacketData packetData : data) {
            totalBytes += packetData.totalPacketBytes;
            totalRate += packetData.rate;
        }
        playerEntity.m_5661_((Component)Component.m_237113_((String)("Total kb:" + percent.format((double)totalBytes / 1000.0) + " total rate:" + percent.format(totalRate))).m_6270_(GOLD), false);
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < data.size(); ++i) {
            PacketData packetData;
            packetData = data.get(i);
            playerEntity.m_5661_((Component)Component.m_237113_((String)(percent.format((double)packetData.totalPacketBytes / (double)totalBytes * 100.0) + "% ")).m_7220_((Component)Component.m_237113_((String)(packetData.packetName + " "))).m_6270_(GREEN_BOLD).m_7220_((Component)Component.m_237113_((String)("r: " + percent.format(packetData.rate) + "kb/s ")).m_6270_(BLUE)).m_7220_((Component)Component.m_237113_((String)("count:" + packetData.packetCount + " ")).m_6270_(YELLOW)).m_7220_((Component)Component.m_237113_((String)("maxSize: " + percent.format((double)packetData.maxPacketBytes / 1000.0) + "kb")).m_6270_(RED)), false);
        }
        if (i + 1 < data.size()) {
            playerEntity.m_5661_((Component)Component.m_237113_((String)"next --->").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/connectivity packetsClient %d %d", minutes, i)))), false);
        }
    }

    public static void printPacketsFittingName(CommandSourceStack source, String name) {
        if (name == null || name.isEmpty()) {
            source.m_243053_((Component)Component.m_237113_((String)"Invalid name"));
            return;
        }
        List<PacketData> packetData = NetworkStatGatherer.getDataByPacket(((CommonConfiguration)Connectivity.config.getCommonConfig()).packetHistoryMinutes);
        DecimalFormat percent = new DecimalFormat("########.##");
        Style GREEN_BOLD = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
        Style BLUE = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE));
        Style YELLOW = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW));
        Style RED = Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
        source.m_243053_((Component)Component.m_237113_((String)("Printing biggest packets fitting " + name + " to latest.log")));
        for (PacketData data : packetData) {
            if (data.largestPacket == null || !data.packetName.toLowerCase().contains(name.toLowerCase())) continue;
            source.m_243053_((Component)Component.m_237113_((String)("Printed: " + data.packetName + " ")).m_6270_(GREEN_BOLD).m_7220_((Component)Component.m_237113_((String)("r: " + percent.format(data.rate) + "kb/s ")).m_6270_(BLUE)).m_7220_((Component)Component.m_237113_((String)("count:" + data.packetCount + " ")).m_6270_(YELLOW)).m_7220_((Component)Component.m_237113_((String)("maxSize: " + percent.format((double)data.maxPacketBytes / 1000.0) + "kb")).m_6270_(RED)));
            PacketLogging.logPacket(data.largestPacket, "Print triggered by command");
        }
    }

    static {
        for (int i = 0; i < recordingDuration; ++i) {
            minuteData.add(null);
        }
    }

    private static class PacketData {
        public final String packetName;
        public int maxPacketBytes = 0;
        public long totalPacketBytes = 0L;
        public int packetCount = 0;
        public Object largestPacket = null;
        public double rate = 0.0;

        private PacketData(String packetName) {
            this.packetName = packetName;
        }

        void add(int packetSize) {
            if (this.maxPacketBytes < packetSize) {
                this.maxPacketBytes = packetSize;
            }
            ++this.packetCount;
            this.totalPacketBytes += (long)packetSize;
        }
    }

    private static class PlayerPacketDataEntry {
        final List<PacketData> packetData;
        final long totalBytes;
        final double totalRate;
        final ServerPlayer playerEntity;

        private PlayerPacketDataEntry(List<PacketData> packetData, long totalBytes, double totalRate, ServerPlayer playerEntity) {
            this.packetData = packetData;
            this.totalBytes = totalBytes;
            this.totalRate = totalRate;
            this.playerEntity = playerEntity;
        }
    }
}

