/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm;

import com.mojang.logging.LogUtils;
import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.block.custom.entities.ModBlockEntities;
import net.lyof.phantasm.client.particles.ModParticles;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.config.ModConfig;
import net.lyof.phantasm.entities.ModEntities;
import net.lyof.phantasm.item.ModItems;
import net.lyof.phantasm.item.ModTabs;
import net.lyof.phantasm.world.ModFeatures;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.lyof.phantasm.world.feature.tree.ModFoliageTypes;
import net.lyof.phantasm.world.feature.tree.ModTrunkTypes;
import net.lyof.phantasm.world.gen.TheEndBiomes;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="phantasm")
public class Phantasm {
    public static final String MOD_ID = "phantasm";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Phantasm() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModTrunkTypes.TRUNK_TYPE_REGISTRY.register(modEventBus);
        ModFoliageTypes.FOLIAGE_PLACER_REGISTRY.register(modEventBus);
        ModTabs.CREATIVE_TAB.register(modEventBus);
        ModFeatures.REGISTRY.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        ModConfig.register();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (ConfigEntries.doDreamingDenBiome) {
            event.enqueueWork(() -> TheEndBiomes.addHighlandsBiome(ModBiomes.DREAMING_DEN, ConfigEntries.dreamingDenWeight));
        }
        if (ModList.get().isLoaded("nullscape")) {
            Phantasm.log("NullScape detected, mod's biomes might not be generated!");
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.CRYSTAL_SHARD.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.VOID_CRYSTAL_SHARD.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.CRYSTAL_GLASS.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.CRYSTAL_GLASS_PANE.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.VOID_CRYSTAL_GLASS.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.VOID_CRYSTAL_GLASS_PANE.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.PREAM_LEAVES.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.HANGING_PREAM_LEAVES.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.PREAM_DOOR.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.PREAM_TRAPDOOR.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.PREAM_SAPLING.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.VIVID_NIHILIS.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.TALL_VIVID_NIHILIS.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.STARFLOWER.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.OBLIVINE.get());
        ModBlocks.BLOCK_CUTOUT.add((Block)ModBlocks.CRYSTALILY.get());
        for (Block block : ModBlocks.BLOCK_CUTOUT) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
        }
    }

    public static <T> T log(T message) {
        LOGGER.info(String.valueOf(message));
        return message;
    }
}

