/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.feature;

import com.mojang.serialization.Codec;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.utils.VanillaLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;

public class ObsidianTowerStructure
extends Feature<CountConfiguration> {
    public static final Feature<CountConfiguration> INSTANCE = new ObsidianTowerStructure((Codec<CountConfiguration>)CountConfiguration.f_67568_);

    public ObsidianTowerStructure(Codec<CountConfiguration> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<CountConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        CountConfiguration config = (CountConfiguration)context.m_159778_();
        origin = world.m_46865_(origin).m_7697_().m_151394_(origin.m_123342_());
        Phantasm.log("Hi " + origin);
        int maxy = config.m_160725_().m_214085_(random) + origin.m_123342_();
        for (int sy = maxy = maxy + 7 - maxy % 7; sy >= 0; --sy) {
            for (int sx = -8; sx < 9; ++sx) {
                for (int sz = -8; sz < 9; ++sz) {
                    if (sx * sx + sz * sz < 64 && (sx * sx + sz * sz >= 49 || sy == maxy || sy == 0)) {
                        Block block = Blocks.f_50080_;
                        double crying = (double)(sy - 60) / ((double)maxy - 60.0);
                        if (Math.random() + 0.1 < crying * crying && crying > 0.0) {
                            block = Blocks.f_50723_;
                        } else if (Math.random() < 0.2) {
                            block = Math.random() < 0.5 ? (Block)ModBlocks.POLISHED_OBSIDIAN.get() : (Block)ModBlocks.POLISHED_OBSIDIAN_BRICKS.get();
                        }
                        world.m_7731_(origin.m_175288_(sy).m_122030_(sx).m_122013_(sz), block.m_49966_(), 3);
                        continue;
                    }
                    if (sx * sx + sz * sz >= 49) continue;
                    world.m_7731_(origin.m_175288_(sy).m_122030_(sx).m_122013_(sz), Blocks.f_50016_.m_49966_(), 3);
                }
            }
            if (world.m_8055_(origin.m_175288_(sy)).m_60795_()) {
                world.m_7731_(origin.m_175288_(sy), Blocks.f_50184_.m_49966_(), 3);
            }
            if (sy < maxy && sy > 0) {
                ObsidianTowerStructure.putStairs(world, origin.m_175288_(sy));
            }
            if (sy % 7 != 0 || sy == maxy || sy == 0) continue;
            ObsidianTowerStructure.putPlatform(world, origin.m_175288_(sy), random.m_188503_(7));
        }
        return true;
    }

    public static void putStairs(WorldGenLevel world, BlockPos center) {
        int y = center.m_123342_();
        for (int sx = -7; sx < 8; ++sx) {
            for (int sz = -7; sz < 8; ++sz) {
                if (sx * sx + sz * sz < 36 || sx * sx + sz * sz >= 49 || !(sx >= 5 && y % 4 == 0 || sx <= -5 && y % 4 == 2 || sz >= 5 && y % 4 == 1) && (sz > -5 || y % 4 != 3)) continue;
                world.m_7731_(center.m_122030_(sx).m_122013_(sz), (BlockState)Blocks.f_50469_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), 3);
            }
        }
        if (Math.random() < 0.2 || center.m_123342_() == 1) {
            BlockPos.MutableBlockPos door = center.m_122032_();
            door = y % 4 == 0 ? door.m_122030_(7) : (y % 4 == 2 ? door.m_122025_(7) : (y % 4 == 1 ? door.m_122013_(7) : door.m_122020_(7)));
            door = door.m_7494_();
            world.m_7731_((BlockPos)door, Blocks.f_50016_.m_49966_(), 3);
            world.m_7731_(door.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static void putPlatform(WorldGenLevel world, BlockPos center, int roomtype) {
        if (roomtype == 0) {
            for (int sx = -5; sx < 6; ++sx) {
                for (int sz = -5; sz < 6; ++sz) {
                    if (sx * sx + sz * sz >= 16) continue;
                    world.m_7731_(center.m_122030_(sx).m_122013_(sz), Blocks.f_50492_.m_49966_(), 3);
                }
            }
        } else if (roomtype == 1) {
            for (int sx = -5; sx < 6; ++sx) {
                for (int sz = -5; sz < 6; ++sz) {
                    if (sx * sx + sz * sz >= 16) continue;
                    world.m_7731_(center.m_122030_(sx).m_122013_(sz), Blocks.f_50492_.m_49966_(), 3);
                }
            }
            world.m_7731_(center.m_7494_(), Blocks.f_50087_.m_49966_(), 3);
            BlockEntity sz = world.m_7702_(center.m_7494_());
            if (sz instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)sz;
                chest.m_59626_(VanillaLootTables.STRONGHOLD_CORRIDOR_CHEST, world.m_213780_().m_188505_());
            }
        } else if (roomtype == 2) {
            world.m_7731_(center, Blocks.f_50085_.m_49966_(), 3);
            BlockEntity sz = world.m_7702_(center);
            if (sz instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)sz;
                CompoundTag nbt = spawner.m_59801_().m_186381_(new CompoundTag());
                nbt.m_128376_("MinSpawnDelay", (short)200);
                nbt.m_128376_("SpawnCount", (short)1);
                nbt.m_128376_("MaxNearbyEntities", (short)2);
                nbt.m_128473_("SpawnData");
                Phantasm.log(nbt);
                spawner.m_59801_().m_151328_(null, center, nbt);
                spawner.m_252803_(EntityType.f_20491_, world.m_213780_());
            }
        } else if (roomtype == 3) {
            center = center.m_122013_(world.m_213780_().m_216332_(-3, 3)).m_122030_(world.m_213780_().m_216332_(-3, 3));
            BlockPos.m_121935_((BlockPos)center, (int)2, (Direction)Direction.NORTH, (Direction)Direction.EAST).forEach(pos -> world.m_7731_((BlockPos)pos, Blocks.f_50080_.m_49966_(), 3));
            world.m_7731_(center.m_7494_(), Blocks.f_50087_.m_49966_(), 3);
            BlockEntity blockEntity = world.m_7702_(center.m_7494_());
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                chest.m_59626_(VanillaLootTables.END_CITY_TREASURE_CHEST, world.m_213780_().m_188505_());
            }
        }
    }

    public static void generateRoom(WorldGenLevel world, BlockPos center) {
        if (Math.random() < 0.5 || center.m_123342_() == 1) {
            BlockPos.MutableBlockPos door = center.m_122032_();
            door = Math.random() <= 0.25 ? door.m_122030_(7) : (Math.random() <= 0.25 ? door.m_122025_(7) : (Math.random() <= 0.25 ? door.m_122013_(7) : door.m_122020_(7)));
            world.m_7731_((BlockPos)door, Blocks.f_50016_.m_49966_(), 3);
            world.m_7731_(door.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        }
        if (Math.random() < 0.3) {
            world.m_7731_(center, Blocks.f_50085_.m_49966_(), 3);
            BlockEntity blockEntity = world.m_7702_(center);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                spawner.m_252803_(EntityType.f_20501_, world.m_213780_());
            }
            world.m_7731_(center.m_7494_(), Blocks.f_50087_.m_49966_(), 3);
            blockEntity = world.m_7702_(center.m_7494_());
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                chest.m_59626_(VanillaLootTables.STRONGHOLD_CORRIDOR_CHEST, world.m_213780_().m_188505_());
            }
        }
    }
}

