/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.google.common.math.DoubleMath;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.labels.integration.SuppCompat;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LabelEntity
extends HangingEntity
implements IExtraClientSpawnData {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Byte> DATA_DYE_COLOR = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_GLOWING = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_TEXT = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AttachFace attachFace = null;
    private boolean needsVisualRefresh = true;
    @Nullable
    private ResourceLocation textureId;
    private float scale;
    private FormattedCharSequence[] labelText;
    private BlockState clientSupportStateHack = null;

    public LabelEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public LabelEntity(Level level, BlockPos pos, Direction clickedFace, Direction horizontalFacing) {
        super(LabelsMod.LABEL.get(), level, pos);
        this.m_20343_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        this.f_31698_ = pos;
        if (clickedFace.m_122434_().m_122479_()) {
            this.setOrientation(clickedFace, AttachFace.WALL);
        } else {
            this.setOrientation(horizontalFacing.m_122424_(), clickedFace == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING);
        }
    }

    public void setOrientation(Direction horizontalOrientation, AttachFace face) {
        this.attachFace = face;
        super.m_6022_(horizontalOrientation);
        if (face != AttachFace.WALL) {
            this.m_146926_(90.0f * (float)(face == AttachFace.FLOOR ? -1 : 1));
            this.m_146922_(horizontalOrientation.m_122416_() * 90);
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
        }
    }

    @Deprecated(since="use the one with 2 param")
    protected void m_6022_(Direction facingDirection) {
        super.m_6022_(facingDirection);
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.m_130064_(this.f_31698_);
        buf.m_130130_(Block.f_49791_.m_7447_((Object)this.m_9236_().m_8055_(this.m_31748_())));
        buf.m_130130_(this.f_31699_.m_122416_());
        buf.m_130130_(this.attachFace.ordinal());
        if (PlatHelper.getPlatform().isFabric()) {
            DyeColor col = this.getColor();
            boolean text = this.hasText();
            boolean glow = this.hasGlowInk();
            ItemStack item = this.getItem();
            this.m_20088_().m_135381_(DATA_DYE_COLOR, (Object)-1);
            this.m_20088_().m_135381_(DATA_GLOWING, (Object)false);
            this.m_20088_().m_135381_(DATA_TEXT, (Object)false);
            this.m_20088_().m_135381_(DATA_ITEM, (Object)ItemStack.f_41583_);
            this.setColor(col);
            this.setHasGlowInk(glow);
            this.setHasText(text);
            this.m_20088_().m_135381_(DATA_ITEM, (Object)item);
        }
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.f_31698_ = buf.m_130135_();
        this.clientSupportStateHack = (BlockState)Block.f_49791_.m_7942_(buf.m_130242_());
        this.setOrientation(Direction.m_122407_((int)buf.m_130242_()), AttachFace.values()[buf.m_130242_()]);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_DYE_COLOR, (Object)-1);
        this.f_19804_.m_135372_(DATA_GLOWING, (Object)false);
        this.f_19804_.m_135372_(DATA_TEXT, (Object)false);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return 0.0f;
    }

    public int m_7076_() {
        return 10;
    }

    public int m_7068_() {
        return 10;
    }

    public void m_5553_(@Nullable Entity entity) {
        block2: {
            block3: {
                if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) break block2;
                this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) break block2;
            }
            this.m_19998_((ItemLike)LabelsMod.LABEL_ITEM.get());
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
    }

    public void setItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
            stack.m_41636_((Entity)this);
        }
        this.m_20088_().m_135381_(DATA_ITEM, (Object)stack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (this.m_9236_().f_46443_) {
            if (pKey.equals(DATA_ITEM)) {
                ItemStack itemstack = this.getItem();
                if (!itemstack.m_41619_() && itemstack.m_41609_() != this) {
                    itemstack.m_41636_((Entity)this);
                }
                this.recomputeTexture(itemstack);
                this.needsVisualRefresh = true;
            } else if (pKey.equals(DATA_DYE_COLOR)) {
                this.recomputeTexture(this.getItem());
            }
        }
    }

    private void recomputeTexture(ItemStack itemstack) {
        Object s = Utils.getID((Item)itemstack.m_41720_()).toString().replace(":", "/");
        DyeColor color = this.getColor();
        if (color != null) {
            s = (String)s + "_" + color.m_41065_();
        }
        this.textureId = LabelsMod.res((String)s);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ItemStack item = this.getItem();
        if (!item.m_41619_()) {
            tag.m_128365_("Item", (Tag)item.m_41739_(new CompoundTag()));
        }
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        tag.m_128344_("AttachFace", (byte)this.attachFace.ordinal());
        tag.m_128379_("Glowing", this.hasGlowInk());
        tag.m_128379_("Text", this.hasText());
        DyeColor c = this.getColor();
        if (c != null) {
            tag.m_128344_("DyeColor", (byte)c.ordinal());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag compound = tag.m_128469_("Item");
        if (!compound.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compound);
            if (itemstack.m_41619_()) {
                LabelsMod.LOGGER.warn("Unable to load item from: {}", (Object)compound);
            }
            this.setItem(itemstack);
        }
        this.setOrientation(Direction.m_122407_((int)tag.m_128445_("Facing")), AttachFace.values()[tag.m_128445_("AttachFace")]);
        this.setHasGlowInk(tag.m_128471_("Glowing"));
        this.setHasText(tag.m_128471_("Text"));
        if (tag.m_128441_("DyeColor")) {
            this.m_20088_().m_135381_(DATA_DYE_COLOR, (Object)tag.m_128445_("DyeColor"));
        }
    }

    public boolean m_142038_() {
        return false;
    }

    @Nullable
    public ItemStack m_142340_() {
        return LabelsMod.LABEL_ITEM.get().m_7968_();
    }

    public void m_6034_(double x, double y, double z) {
        this.m_20343_(x, y, z);
        this.m_7087_();
        this.f_19812_ = true;
    }

    protected void m_7087_() {
        if (this.attachFace != null) {
            BlockState support;
            Level level = this.m_9236_();
            BlockPos supportPos = this.f_31698_;
            if (level.f_46443_ && this.clientSupportStateHack != null) {
                support = this.clientSupportStateHack;
                this.clientSupportStateHack = null;
            } else {
                support = level.m_8055_(supportPos);
            }
            VoxelShape shape = support.m_60816_((BlockGetter)level, supportPos);
            if (shape.m_83281_()) {
                return;
            }
            Direction dir = this.getBehindDirection();
            double offset = dir.m_122421_() != Direction.AxisDirection.POSITIVE ? 0.5 - shape.m_83297_(dir.m_122434_()) : -0.5 + shape.m_83288_(dir.m_122434_());
            Vec3 v = Vec3.m_82512_((Vec3i)this.f_31698_);
            offset -= 0.03125;
            if (LabelsMod.SUPP && dir.m_122434_() != Direction.Axis.Y && SuppCompat.isSack(support)) {
                v = v.m_82520_(0.0, -0.125, 0.0);
            }
            v = v.m_82520_((double)dir.m_122429_() * offset, (double)dir.m_122430_() * offset, (double)dir.m_122431_() * offset);
            this.m_20343_(v.f_82479_, v.f_82480_, v.f_82481_);
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            double width = this.m_7076_();
            double height = this.m_7068_();
            double zWidth = this.m_7076_();
            Direction.Axis axis = dir.m_122434_();
            switch (axis) {
                case X: {
                    width = 1.0;
                    break;
                }
                case Y: {
                    height = 1.0;
                    break;
                }
                case Z: {
                    zWidth = 1.0;
                }
            }
            this.m_20011_(new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (zWidth /= 32.0), x + width, y + height, z + zWidth));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_213877_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        Level level = this.m_9236_();
        if (player.m_36341_() && !itemstack.m_41619_()) {
            if (!level.f_46443_) {
                this.setItem(itemstack);
                if (!itemstack.m_41619_()) {
                    this.m_5496_(SoundEvents.f_144181_, 1.0f, 1.0f);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        boolean consume = true;
        boolean success = false;
        boolean glowInk = this.hasGlowInk();
        if (itemstack.m_41720_() == Items.f_42402_) {
            this.cycleText();
            consume = false;
            success = true;
        } else if (itemstack.m_41720_() == Items.f_151056_ && !glowInk) {
            level.m_5594_(null, this.f_31698_, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setHasGlowInk(true);
            success = true;
        } else if (itemstack.m_41720_() == Items.f_42532_ && glowInk) {
            level.m_5594_(null, this.f_31698_, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setHasGlowInk(false);
            success = true;
        } else if (ForgeHelper.getColor((ItemStack)itemstack) != null) {
            level.m_5594_(null, this.f_31698_, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            DyeColor color = ForgeHelper.getColor((ItemStack)itemstack);
            this.setColor(color);
            this.recomputeTexture(this.getItem());
            success = true;
        }
        if (success) {
            if (consume && !player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, this.f_31698_, itemstack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockPos p = this.m_31748_();
            InteractionResult interactionresult = sp.f_8941_.m_7179_(sp, level, itemstack, hand, new BlockHitResult(Vec3.m_82512_((Vec3i)p), this.f_31699_, p, false));
            return interactionresult;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7088_() {
        Level level = this.m_9236_();
        if (!level.m_45786_((Entity)this)) {
            return false;
        }
        BlockPos supportingPos = this.m_31748_();
        Direction behindDIr = this.getBehindDirection();
        BlockState state = level.m_8055_(supportingPos);
        VoxelShape blockShape = state.m_60816_((BlockGetter)level, supportingPos);
        if (blockShape.m_83281_() || !state.m_280296_()) {
            return false;
        }
        AABB bbShape = this.m_20191_();
        blockShape = blockShape.m_83216_((double)supportingPos.m_123341_(), (double)supportingPos.m_123342_(), (double)supportingPos.m_123343_());
        if (behindDIr.m_122421_() == Direction.AxisDirection.POSITIVE ? !DoubleMath.fuzzyEquals((double)bbShape.m_82374_(behindDIr.m_122434_()), (double)blockShape.m_83288_(behindDIr.m_122434_()), (double)1.0E-7) : !DoubleMath.fuzzyEquals((double)bbShape.m_82340_(behindDIr.m_122434_()), (double)blockShape.m_83297_(behindDIr.m_122434_()), (double)1.0E-7)) {
            return false;
        }
        return level.m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty();
    }

    private Direction getBehindDirection() {
        return switch (this.attachFace) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.WALL -> this.f_31699_.m_122424_();
            case AttachFace.FLOOR -> Direction.DOWN;
            case AttachFace.CEILING -> Direction.UP;
        };
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public void setLabelText(FormattedCharSequence[] tempPageLines) {
        this.labelText = tempPageLines;
    }

    public void setLabelTextScale(float scale) {
        this.scale = scale;
    }

    public float getLabelTextScale() {
        return this.scale;
    }

    public FormattedCharSequence[] getLabelText() {
        return this.labelText;
    }

    @Nullable
    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public boolean hasGlowInk() {
        return (Boolean)this.m_20088_().m_135370_(DATA_GLOWING);
    }

    public boolean hasText() {
        return (Boolean)this.m_20088_().m_135370_(DATA_TEXT);
    }

    private void setHasGlowInk(boolean glowing) {
        this.m_20088_().m_135381_(DATA_GLOWING, (Object)glowing);
    }

    private void setHasText(boolean text) {
        this.m_20088_().m_135381_(DATA_TEXT, (Object)text);
    }

    private void cycleText() {
        this.m_20088_().m_135381_(DATA_TEXT, (Object)((Boolean)this.m_20088_().m_135370_(DATA_TEXT) == false ? 1 : 0));
    }

    @Nullable
    public DyeColor getColor() {
        byte i = (Byte)this.m_20088_().m_135370_(DATA_DYE_COLOR);
        return i == -1 ? null : DyeColor.m_41053_((int)i);
    }

    private void setColor(@Nullable DyeColor color) {
        this.m_20088_().m_135381_(DATA_DYE_COLOR, (Object)((byte)(color == null ? -1 : color.ordinal())));
    }
}

