/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ElevatorTargetFloorPacket
extends SimplePacketBase {
    private int entityId;
    private int targetY;

    public ElevatorTargetFloorPacket(AbstractContraptionEntity entity, int targetY) {
        this.targetY = targetY;
        this.entityId = entity.m_19879_();
    }

    public ElevatorTargetFloorPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.targetY = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.targetY);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            Entity entityByID = sender.m_284548_().m_6815_(this.entityId);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
            Contraption patt1377$temp = ace.getContraption();
            if (!(patt1377$temp instanceof ElevatorContraption)) {
                return;
            }
            ElevatorContraption ec = (ElevatorContraption)patt1377$temp;
            if (ace.m_20280_((Entity)sender) > 2500.0) {
                return;
            }
            Level level = sender.m_9236_();
            ElevatorColumn elevatorColumn = ElevatorColumn.get((LevelAccessor)level, ec.getGlobalColumn());
            if (!elevatorColumn.contacts.contains(this.targetY)) {
                return;
            }
            if (ec.isTargetUnreachable(this.targetY)) {
                return;
            }
            BlockPos pos = elevatorColumn.contactAt(this.targetY);
            BlockState blockState = level.m_8055_(pos);
            Block patt1866$temp = blockState.m_60734_();
            if (!(patt1866$temp instanceof ElevatorContactBlock)) {
                return;
            }
            ElevatorContactBlock ecb = (ElevatorContactBlock)patt1866$temp;
            ecb.callToContactAndUpdate(elevatorColumn, blockState, level, pos, false);
        });
        return true;
    }
}

