/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class FilterItem
extends Item
implements MenuProvider {
    private FilterType type;

    public static FilterItem regular(Item.Properties properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(Item.Properties properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    private FilterItem(FilterType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!AllKeys.shiftDown()) {
            List<Component> makeSummary = this.makeSummary(stack);
            if (makeSummary.isEmpty()) {
                return;
            }
            tooltip.add((Component)Components.literal(" "));
            tooltip.addAll(makeSummary);
        }
    }

    private List<Component> makeSummary(ItemStack filter) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!filter.m_41782_()) {
            return list;
        }
        if (this.type == FilterType.REGULAR) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean blacklist = filter.m_41784_().m_128471_("Blacklist");
            list.add((Component)(blacklist ? Lang.translateDirect("gui.filter.deny_list", new Object[0]) : Lang.translateDirect("gui.filter.allow_list", new Object[0])).m_130940_(ChatFormatting.GOLD));
            int count = 0;
            for (int i = 0; i < filterItems.getSlots(); ++i) {
                if (count > 3) {
                    list.add((Component)Components.literal("- ...").m_130940_(ChatFormatting.DARK_GRAY));
                    break;
                }
                ItemStack filterStack = filterItems.getStackInSlot(i);
                if (filterStack.m_41619_()) continue;
                list.add((Component)Components.literal("- ").m_7220_(filterStack.m_41786_()).m_130940_(ChatFormatting.GRAY));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.ATTRIBUTE) {
            AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[filter.m_41784_().m_128451_("WhitelistMode")];
            list.add((Component)(whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ ? Lang.translateDirect("gui.attribute_filter.allow_list_conjunctive", new Object[0]) : (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ ? Lang.translateDirect("gui.attribute_filter.allow_list_disjunctive", new Object[0]) : Lang.translateDirect("gui.attribute_filter.deny_list", new Object[0]))).m_130940_(ChatFormatting.GOLD));
            int count = 0;
            ListTag attributes = filter.m_41784_().m_128437_("MatchedAttributes", 10);
            for (Tag inbt : attributes) {
                CompoundTag compound = (CompoundTag)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                if (attribute == null) continue;
                boolean inverted = compound.m_128471_("Inverted");
                if (count > 3) {
                    list.add((Component)Components.literal("- ...").m_130940_(ChatFormatting.DARK_GRAY));
                    break;
                }
                list.add((Component)Components.literal("- ").m_7220_((Component)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if (!world.f_46443_ && player instanceof ServerPlayer) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.m_130055_(heldItem));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        ItemStack heldItem = player.m_21205_();
        if (this.type == FilterType.REGULAR) {
            return FilterMenu.create(id, inv, heldItem);
        }
        if (this.type == FilterType.ATTRIBUTE) {
            return AttributeFilterMenu.create(id, inv, heldItem);
        }
        return null;
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    public static ItemStackHandler getFilterItems(ItemStack stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER.get() != stack.m_41720_()) {
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + stack);
        }
        if (!stack.m_41782_()) {
            return newInv;
        }
        CompoundTag invNBT = stack.m_41698_("Items");
        if (!invNBT.m_128456_()) {
            newInv.deserializeNBT(invNBT);
        }
        return newInv;
    }

    public static boolean testDirect(ItemStack filter, ItemStack stack, boolean matchNBT) {
        if (matchNBT) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)filter, (ItemStack)stack);
        }
        return ItemHelper.sameItem(filter, stack);
    }

    private static enum FilterType {
        REGULAR,
        ATTRIBUTE;

    }
}

