/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class DisplayLinkConfigurationPacket
extends BlockEntityConfigurationPacket<DisplayLinkBlockEntity> {
    private CompoundTag configData;
    private int targetLine;

    public DisplayLinkConfigurationPacket(BlockPos pos, CompoundTag configData, int targetLine) {
        super(pos);
        this.configData = configData;
        this.targetLine = targetLine;
    }

    public DisplayLinkConfigurationPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.configData);
        buffer.writeInt(this.targetLine);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        this.configData = buffer.m_130260_();
        this.targetLine = buffer.readInt();
    }

    @Override
    protected void applySettings(DisplayLinkBlockEntity be) {
        be.targetLine = this.targetLine;
        if (!this.configData.m_128441_("Id")) {
            be.notifyUpdate();
            return;
        }
        ResourceLocation id = new ResourceLocation(this.configData.m_128461_("Id"));
        DisplaySource source = AllDisplayBehaviours.getSource(id);
        if (source == null) {
            be.notifyUpdate();
            return;
        }
        if (be.activeSource == null || be.activeSource != source) {
            be.activeSource = source;
            be.setSourceConfig(this.configData.m_6426_());
        } else {
            be.getSourceConfig().m_128391_(this.configData);
        }
        be.updateGatheredData();
        be.notifyUpdate();
    }
}

