/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ParrotElement
extends AnimatedSceneElement {
    private Vec3 location;
    private Parrot entity;
    private ParrotPose pose;
    private boolean deferConductor = false;
    private Supplier<? extends ParrotPose> initialPose;

    public static ParrotElement create(Vec3 location, Supplier<? extends ParrotPose> pose) {
        return new ParrotElement(location, pose);
    }

    protected ParrotElement(Vec3 location, Supplier<? extends ParrotPose> pose) {
        this.location = location;
        this.initialPose = pose;
        this.setPose(this.initialPose.get());
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.setPose(this.initialPose.get());
        this.entity.m_20343_(0.0, 0.0, 0.0);
        this.entity.f_19854_ = 0.0;
        this.entity.f_19855_ = 0.0;
        this.entity.f_19856_ = 0.0;
        this.entity.f_19790_ = 0.0;
        this.entity.f_19791_ = 0.0;
        this.entity.f_19792_ = 0.0;
        this.entity.f_19860_ = 0.0f;
        this.entity.m_146926_(0.0f);
        this.entity.f_19859_ = 180.0f;
        this.entity.m_146922_(180.0f);
        this.entity.getPersistentData().m_128473_("TrainHat");
        this.deferConductor = false;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.pose.create(scene.getWorld());
            this.entity.f_19859_ = 180.0f;
            this.entity.m_146922_(180.0f);
            if (this.deferConductor) {
                this.setConductor(this.deferConductor);
            }
            this.deferConductor = false;
        }
        ++this.entity.f_19797_;
        this.entity.f_20886_ = this.entity.f_20885_;
        this.entity.f_29352_ = this.entity.f_29351_;
        this.entity.f_29353_ = this.entity.f_29350_;
        this.entity.m_6853_(true);
        this.entity.f_19854_ = this.entity.m_20185_();
        this.entity.f_19855_ = this.entity.m_20186_();
        this.entity.f_19856_ = this.entity.m_20189_();
        this.entity.f_19859_ = this.entity.m_146908_();
        this.entity.f_19860_ = this.entity.m_146909_();
        this.pose.tick(scene, this.entity, this.location);
        this.entity.f_19790_ = this.entity.m_20185_();
        this.entity.f_19791_ = this.entity.m_20186_();
        this.entity.f_19792_ = this.entity.m_20189_();
    }

    public void setPositionOffset(Vec3 position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        if (!immediate) {
            return;
        }
        this.entity.f_19854_ = position.f_82479_;
        this.entity.f_19855_ = position.f_82480_;
        this.entity.f_19856_ = position.f_82481_;
    }

    public void setRotation(Vec3 eulers, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.m_146926_((float)eulers.f_82479_);
        this.entity.m_146922_((float)eulers.f_82480_);
        if (!immediate) {
            return;
        }
        this.entity.f_19860_ = this.entity.m_146909_();
        this.entity.f_19859_ = this.entity.m_146908_();
    }

    public void setConductor(boolean isConductor) {
        if (this.entity == null) {
            this.deferConductor = isConductor;
            return;
        }
        CompoundTag data = this.entity.getPersistentData();
        if (isConductor) {
            data.m_128379_("TrainHat", true);
        } else {
            data.m_128473_("TrainHat");
        }
    }

    public Vec3 getPositionOffset() {
        return this.entity != null ? this.entity.m_20182_() : Vec3.f_82478_;
    }

    public Vec3 getRotation() {
        return this.entity != null ? new Vec3((double)this.entity.m_146909_(), (double)this.entity.m_146908_(), 0.0) : Vec3.f_82478_;
    }

    @Override
    protected void renderLast(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        if (this.entity == null) {
            this.entity = this.pose.create(world);
            this.entity.f_19859_ = 180.0f;
            this.entity.m_146922_(180.0f);
        }
        ms.m_85836_();
        ms.m_85837_(this.location.f_82479_, this.location.f_82480_, this.location.f_82481_);
        ms.m_85837_(Mth.m_14139_((double)pt, (double)this.entity.f_19854_, (double)this.entity.m_20185_()), Mth.m_14139_((double)pt, (double)this.entity.f_19855_, (double)this.entity.m_20186_()), Mth.m_14139_((double)pt, (double)this.entity.f_19856_, (double)this.entity.m_20189_()));
        TransformStack.cast((PoseStack)ms).rotateY((double)AngleHelper.angleLerp(pt, this.entity.f_19859_, this.entity.m_146908_()));
        entityrenderermanager.m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, ms, buffer, this.lightCoordsFromFade(fade));
        ms.m_85849_();
    }

    public void setPose(ParrotPose pose) {
        this.pose = pose;
    }

    public static abstract class ParrotPose {
        abstract void tick(PonderScene var1, Parrot var2, Vec3 var3);

        Parrot create(PonderWorld world) {
            Parrot entity = new Parrot(EntityType.f_20508_, (Level)world);
            Parrot.Variant[] variants = Parrot.Variant.values();
            Parrot.Variant variant = variants[Create.RANDOM.nextInt(variants.length)];
            entity.m_28464_(variant == Parrot.Variant.BLUE ? Parrot.Variant.RED_BLUE : variant);
            return entity;
        }
    }

    public static class FaceCursorPose
    extends FaceVecPose {
        @Override
        protected Vec3 getFacedVec(PonderScene scene) {
            Minecraft minecraft = Minecraft.m_91087_();
            Window w = minecraft.m_91268_();
            double mouseX = minecraft.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
            double mouseY = minecraft.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
            return scene.getTransform().screenToScene(mouseX, mouseY, 300, 0.0f);
        }
    }

    public static class FacePointOfInterestPose
    extends FaceVecPose {
        @Override
        protected Vec3 getFacedVec(PonderScene scene) {
            return scene.getPointOfInterest();
        }
    }

    public static abstract class FaceVecPose
    extends ParrotPose {
        @Override
        void tick(PonderScene scene, Parrot entity, Vec3 location) {
            Vec3 p_200602_2_ = this.getFacedVec(scene);
            Vec3 Vector3d2 = location.m_82549_(entity.m_20299_(0.0f));
            double d0 = p_200602_2_.f_82479_ - Vector3d2.f_82479_;
            double d1 = p_200602_2_.f_82480_ - Vector3d2.f_82480_;
            double d2 = p_200602_2_.f_82481_ - Vector3d2.f_82481_;
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            float targetPitch = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
            float targetYaw = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875)) + 90.0f));
            entity.m_146926_(AngleHelper.angleLerp(0.4f, entity.m_146909_(), targetPitch));
            entity.m_146922_(AngleHelper.angleLerp(0.4f, entity.m_146908_(), targetYaw));
        }

        protected abstract Vec3 getFacedVec(PonderScene var1);
    }

    public static class SpinOnComponentPose
    extends ParrotPose {
        private BlockPos componentPos;

        public SpinOnComponentPose(BlockPos componentPos) {
            this.componentPos = componentPos;
        }

        @Override
        void tick(PonderScene scene, Parrot entity, Vec3 location) {
            BlockEntity blockEntity = scene.getWorld().m_7702_(this.componentPos);
            if (!(blockEntity instanceof KineticBlockEntity)) {
                return;
            }
            float rpm = ((KineticBlockEntity)blockEntity).getSpeed();
            entity.f_19859_ = entity.m_146908_();
            entity.m_146922_(entity.m_146908_() + rpm * 0.3f);
        }
    }

    public static class FlappyPose
    extends ParrotPose {
        @Override
        void tick(PonderScene scene, Parrot entity, Vec3 location) {
            double length = entity.m_20182_().m_82492_(entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82553_();
            entity.m_6853_(false);
            double phase = Math.min(length * 15.0, 8.0);
            float f = (float)((double)(PonderUI.ponderTicks % 100) * phase);
            entity.f_29351_ = Mth.m_14031_((float)f) + 1.0f;
            if (length == 0.0) {
                entity.f_29351_ = 0.0f;
            }
        }
    }

    public static class DancePose
    extends ParrotPose {
        @Override
        Parrot create(PonderWorld world) {
            Parrot entity = super.create(world);
            entity.m_6818_(BlockPos.f_121853_, true);
            return entity;
        }

        @Override
        void tick(PonderScene scene, Parrot entity, Vec3 location) {
            entity.f_19859_ = entity.m_146908_();
            entity.m_146922_(entity.m_146908_() - 2.0f);
        }
    }
}

