/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui;

import it.hurts.octostudios.octolib.modules.config.annotations.Prop;
import it.hurts.octostudios.octolib.modules.config.impl.OctoConfig;

public class Config
implements OctoConfig {
    @Prop(comment="Enables the hotbar selector animation.")
    private boolean enableHotbarSelectorAnimation = true;
    @Prop(comment="Enables floating item rotation.")
    private boolean enableFloatingItemRotation = true;
    @Prop(comment="Enables hovering of matching items.")
    private boolean enableMatchingItemHovering = true;
    @Prop(comment="Enables particles for rare items.")
    private boolean enableRarityParticles = true;
    @Prop(comment="Enables vanilla slot highlighting")
    private boolean enableVanillaSlotHighlighting = true;
    @Prop(comment="Affects the speed of the hotbar selector.")
    private double hotbarSelectorSpeed = 3.0;
    @Prop(comment="Affects the size of the hovered item.")
    private float hoveredItemScale = 1.4f;
    @Prop(comment="Affects the hover amplitude of items, that match to the item that is carried in the cursor.")
    private float matchingItemHoverAmplitude = 0.8f;
    @Prop(comment="Affects the easing speed, that is applied to the rotation of the floating item.")
    private float floatingItemEasingSpeed = 0.75f;
    @Prop(comment="Affects the rotation amplitude of the floating item.")
    private float floatingItemRotationAmplitude = 1.0f;
    @Prop(comment="Moves the hotbar selector above the items. You might want to disable this, if you use resource packs that change the default selector texture.")
    private boolean renderHotbarSelectorAboveItems = false;

    public boolean isEnableHotbarSelectorAnimation() {
        return this.enableHotbarSelectorAnimation;
    }

    public boolean isEnableFloatingItemRotation() {
        return this.enableFloatingItemRotation;
    }

    public boolean isEnableMatchingItemHovering() {
        return this.enableMatchingItemHovering;
    }

    public boolean isEnableRarityParticles() {
        return this.enableRarityParticles;
    }

    public boolean isEnableVanillaSlotHighlighting() {
        return this.enableVanillaSlotHighlighting;
    }

    public double getHotbarSelectorSpeed() {
        return this.hotbarSelectorSpeed;
    }

    public float getHoveredItemScale() {
        return this.hoveredItemScale;
    }

    public float getMatchingItemHoverAmplitude() {
        return this.matchingItemHoverAmplitude;
    }

    public float getFloatingItemEasingSpeed() {
        return this.floatingItemEasingSpeed;
    }

    public float getFloatingItemRotationAmplitude() {
        return this.floatingItemRotationAmplitude;
    }

    public boolean isRenderHotbarSelectorAboveItems() {
        return this.renderHotbarSelectorAboveItems;
    }

    public void setEnableHotbarSelectorAnimation(boolean enableHotbarSelectorAnimation) {
        this.enableHotbarSelectorAnimation = enableHotbarSelectorAnimation;
    }

    public void setEnableFloatingItemRotation(boolean enableFloatingItemRotation) {
        this.enableFloatingItemRotation = enableFloatingItemRotation;
    }

    public void setEnableMatchingItemHovering(boolean enableMatchingItemHovering) {
        this.enableMatchingItemHovering = enableMatchingItemHovering;
    }

    public void setEnableRarityParticles(boolean enableRarityParticles) {
        this.enableRarityParticles = enableRarityParticles;
    }

    public void setEnableVanillaSlotHighlighting(boolean enableVanillaSlotHighlighting) {
        this.enableVanillaSlotHighlighting = enableVanillaSlotHighlighting;
    }

    public void setHotbarSelectorSpeed(double hotbarSelectorSpeed) {
        this.hotbarSelectorSpeed = hotbarSelectorSpeed;
    }

    public void setHoveredItemScale(float hoveredItemScale) {
        this.hoveredItemScale = hoveredItemScale;
    }

    public void setMatchingItemHoverAmplitude(float matchingItemHoverAmplitude) {
        this.matchingItemHoverAmplitude = matchingItemHoverAmplitude;
    }

    public void setFloatingItemEasingSpeed(float floatingItemEasingSpeed) {
        this.floatingItemEasingSpeed = floatingItemEasingSpeed;
    }

    public void setFloatingItemRotationAmplitude(float floatingItemRotationAmplitude) {
        this.floatingItemRotationAmplitude = floatingItemRotationAmplitude;
    }

    public void setRenderHotbarSelectorAboveItems(boolean renderHotbarSelectorAboveItems) {
        this.renderHotbarSelectorAboveItems = renderHotbarSelectorAboveItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableHotbarSelectorAnimation() != other.isEnableHotbarSelectorAnimation()) {
            return false;
        }
        if (this.isEnableFloatingItemRotation() != other.isEnableFloatingItemRotation()) {
            return false;
        }
        if (this.isEnableMatchingItemHovering() != other.isEnableMatchingItemHovering()) {
            return false;
        }
        if (this.isEnableRarityParticles() != other.isEnableRarityParticles()) {
            return false;
        }
        if (this.isEnableVanillaSlotHighlighting() != other.isEnableVanillaSlotHighlighting()) {
            return false;
        }
        if (Double.compare(this.getHotbarSelectorSpeed(), other.getHotbarSelectorSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getHoveredItemScale(), other.getHoveredItemScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getMatchingItemHoverAmplitude(), other.getMatchingItemHoverAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getFloatingItemEasingSpeed(), other.getFloatingItemEasingSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getFloatingItemRotationAmplitude(), other.getFloatingItemRotationAmplitude()) != 0) {
            return false;
        }
        return this.isRenderHotbarSelectorAboveItems() == other.isRenderHotbarSelectorAboveItems();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableHotbarSelectorAnimation() ? 79 : 97);
        result = result * 59 + (this.isEnableFloatingItemRotation() ? 79 : 97);
        result = result * 59 + (this.isEnableMatchingItemHovering() ? 79 : 97);
        result = result * 59 + (this.isEnableRarityParticles() ? 79 : 97);
        result = result * 59 + (this.isEnableVanillaSlotHighlighting() ? 79 : 97);
        long $hotbarSelectorSpeed = Double.doubleToLongBits(this.getHotbarSelectorSpeed());
        result = result * 59 + (int)($hotbarSelectorSpeed >>> 32 ^ $hotbarSelectorSpeed);
        result = result * 59 + Float.floatToIntBits(this.getHoveredItemScale());
        result = result * 59 + Float.floatToIntBits(this.getMatchingItemHoverAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getFloatingItemEasingSpeed());
        result = result * 59 + Float.floatToIntBits(this.getFloatingItemRotationAmplitude());
        result = result * 59 + (this.isRenderHotbarSelectorAboveItems() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Config(enableHotbarSelectorAnimation=" + this.isEnableHotbarSelectorAnimation() + ", enableFloatingItemRotation=" + this.isEnableFloatingItemRotation() + ", enableMatchingItemHovering=" + this.isEnableMatchingItemHovering() + ", enableRarityParticles=" + this.isEnableRarityParticles() + ", enableVanillaSlotHighlighting=" + this.isEnableVanillaSlotHighlighting() + ", hotbarSelectorSpeed=" + this.getHotbarSelectorSpeed() + ", hoveredItemScale=" + this.getHoveredItemScale() + ", matchingItemHoverAmplitude=" + this.getMatchingItemHoverAmplitude() + ", floatingItemEasingSpeed=" + this.getFloatingItemEasingSpeed() + ", floatingItemRotationAmplitude=" + this.getFloatingItemRotationAmplitude() + ", renderHotbarSelectorAboveItems=" + this.isRenderHotbarSelectorAboveItems() + ")";
    }
}

