/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.mixin;

import com.mojang.math.Axis;
import it.hurts.octostudios.immersiveui.ImmersiveUI;
import it.hurts.octostudios.immersiveui.system.particles.ParticleStorage;
import it.hurts.octostudios.immersiveui.system.particles.data.GenericParticleData;
import it.hurts.octostudios.immersiveui.system.particles.data.ParticleData;
import it.hurts.octostudios.immersiveui.system.particles.data.ParticleEmitter;
import it.hurts.octostudios.immersiveui.util.CommonCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AbstractContainerScreen.class})
public abstract class FloatingItemMixin {
    @Unique
    Random random = new Random();
    @Unique
    Map<Slot, Float> expandingProgress = new HashMap<Slot, Float>();
    @Shadow
    @Nullable
    protected Slot f_97734_;
    @Shadow
    private ItemStack f_97711_;
    @Unique
    private float immersiveui$ticker;
    @Unique
    float deltaX = 0.0f;
    @Unique
    float deltaY = 0.0f;
    @Unique
    private int oX = Integer.MIN_VALUE;
    @Unique
    private int oY = Integer.MIN_VALUE;
    @Unique
    private float currentAngle = 0.0f;
    @Unique
    private float targetAngle = 0.0f;
    @Unique
    private float currentAngleVelocity = 0.0f;
    @Unique
    private float easingSpeed = ImmersiveUI.CONFIG.getFloatingItemEasingSpeed();
    @Unique
    private final float inertiaDamping = 0.75f;

    @Shadow
    protected abstract boolean m_97774_(Slot var1, double var2, double var4);

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderParticles(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        for (ParticleData data : ParticleStorage.getParticlesData()) {
            data.render(data.getPoseStackSnapshot(), Minecraft.m_91087_().m_91104_() ? 0.0f : Minecraft.m_91087_().m_91296_());
        }
    }

    @Inject(method={"renderFloatingItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderFunkyItem(GuiGraphics guiGraphics, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        ParticleEmitter emitter;
        float scale = ImmersiveUI.CONFIG.getHoveredItemScale();
        float deltaTime = Minecraft.m_91087_().m_91297_();
        float amplitude = ImmersiveUI.CONFIG.getFloatingItemRotationAmplitude();
        if (this.oX != Integer.MIN_VALUE && this.oY != Integer.MIN_VALUE) {
            this.targetAngle = Mth.m_14036_((float)(-this.deltaX / 8.0f * amplitude), (float)(-1.5707964f / (2.0f / amplitude)), (float)(1.5707964f / (2.0f / amplitude)));
            this.currentAngleVelocity += (this.targetAngle - this.currentAngle) * this.easingSpeed * deltaTime;
        }
        this.currentAngle = Mth.m_14036_((float)(this.currentAngle + this.currentAngleVelocity * deltaTime), (float)(-1.5707964f / (2.0f / amplitude)), (float)(1.5707964f / (2.0f / amplitude)));
        this.currentAngleVelocity *= (float)Math.pow(0.75, deltaTime);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(i + 8), (float)(j + 8), 232.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        if (ImmersiveUI.CONFIG.isEnableFloatingItemRotation()) {
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252961_(Mth.m_14154_((float)this.currentAngle) > 0.01f ? this.currentAngle : 0.0f));
        }
        guiGraphics.m_280480_(itemStack, -8, -8);
        if (itemStack.m_41791_() != Rarity.COMMON && ImmersiveUI.CONFIG.isEnableRarityParticles() && !ParticleStorage.EMITTERS.containsKey(emitter = new ParticleEmitter(guiGraphics.m_280168_().m_85850_().m_252922_(), new Vector2i(-8, -8))) && (Mth.m_14154_((float)this.deltaX) > 0.0f || Mth.m_14154_((float)this.deltaY) > 0.0f)) {
            ParticleStorage.EMITTERS.put(emitter, new ArrayList());
            GenericParticleData particle = new GenericParticleData(itemStack.m_41791_().f_43022_.m_126665_() != null ? itemStack.m_41791_().f_43022_.m_126665_() + -16777216 : -65281, 0, Mth.m_14154_((float)this.deltaY) + Mth.m_14154_((float)this.deltaX), 0.0f + this.random.nextFloat(-1.0f, 1.0f), 0.0f + this.random.nextFloat(-1.0f, 1.0f), this.random.nextFloat(0.8f, 1.25f), this.random.nextInt(12, 30), emitter);
            particle.direction = new Vector2f(-this.deltaX, -this.deltaY).normalize();
            ParticleStorage.addParticle(emitter, particle);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280302_(font, itemStack, -8, -8, string);
        guiGraphics.m_280168_().m_85849_();
        ci.cancel();
    }

    @Inject(method={"renderSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItem(Lnet/minecraft/world/item/ItemStack;III)V", shift=At.Shift.BEFORE)}, require=0)
    public void renderSize(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        CommonCode.floatingRenderSize(guiGraphics, slot, this.f_97734_, this.expandingProgress);
    }

    @Inject(method={"renderSlotHighlight"}, at={@At(value="HEAD")}, cancellable=true)
    private static void disableSlotHighlight(GuiGraphics guiGraphics, int x, int y, int blitOffset, @NotNull CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;isActive()Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void fixHovering(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci, int i, int j, int k, Slot slot) {
        if (this.m_97774_(slot, mouseX, mouseY) && slot.m_6659_()) {
            this.f_97734_ = slot;
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void resetOldMouse(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        float deltaTime = Minecraft.m_91087_().m_91297_();
        this.deltaX = (float)(this.oX - mouseX) / deltaTime / 20.0f;
        this.deltaY = (float)(this.oY - mouseY) / deltaTime / 20.0f;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void resetOldMouse2(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.oX = mouseX;
        this.oY = mouseY;
    }
}

