/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.system.particles.data;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.immersiveui.system.particles.data.ParticleEmitter;
import it.hurts.octostudios.immersiveui.util.RenderUtils;
import it.hurts.octostudios.immersiveui.util.VectorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class ParticleData {
    private final ResourceLocation texture;
    private final float maxSpeed;
    private final int maxLifetime;
    private final Vector2f startPos;
    private Vector2f oldPos;
    private final ParticleEmitter emitter;
    public Vector2f position;
    public Vector2f direction;
    public float speed;
    public float friction;
    public float size;
    public float angularVelocity;
    public int lifetime;
    public int startColor;
    public int endColor;
    private int tickCount;

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public Vector2f getStartPos() {
        return this.startPos;
    }

    public ParticleEmitter emitter() {
        return this.emitter;
    }

    public ParticleData(ResourceLocation texture, float maxSpeed, int maxLifetime, float xStart, float yStart, ParticleEmitter emitter) {
        this.texture = texture;
        this.maxSpeed = maxSpeed;
        this.maxLifetime = maxLifetime;
        this.lifetime = maxLifetime;
        this.speed = maxSpeed;
        this.emitter = emitter;
        this.position = this.startPos = new Vector2f(xStart, yStart);
        this.oldPos = this.startPos;
        this.size = 1.0f;
        this.friction = 0.0f;
        this.startColor = -1;
        this.endColor = 0;
        this.direction = new Vector2f(0.0f, 1.0f);
        this.angularVelocity = 0.0f;
    }

    public PoseStack getPoseStackSnapshot() {
        PoseStack stack = new PoseStack();
        stack.m_252931_(this.emitter.pose());
        return stack;
    }

    public void tick() {
        this.oldPos = new Vector2f((Vector2fc)this.position);
        if (this.angularVelocity != 0.0f) {
            this.direction = VectorUtils.rotate(this.direction.normalize(), this.angularVelocity);
        } else {
            this.direction.normalize();
        }
        this.speed = Mth.m_14036_((float)(this.speed * (1.0f - this.friction)), (float)0.0f, (float)this.maxSpeed);
        this.lifetime = Mth.m_14045_((int)(this.lifetime - 1), (int)0, (int)this.maxLifetime);
        this.position.add((Vector2fc)this.direction.mul(this.speed));
        --this.lifetime;
        ++this.tickCount;
    }

    public void render(PoseStack pose, float partialTick) {
        Minecraft MC = Minecraft.m_91087_();
        float lifePercentage = (float)this.lifetime / (float)this.maxLifetime;
        int color = RenderUtils.lerpColor(this.startColor, this.endColor, 1.0f - lifePercentage);
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderUtils.renderTextureFromCenter(pose, Mth.m_14179_((float)partialTick, (float)this.oldPos.x, (float)this.position.x), Mth.m_14179_((float)partialTick, (float)this.oldPos.y, (float)this.position.y), 8.0f, 8.0f, this.size * lifePercentage);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }
}

