/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.util;

public class Easing {
    public static float lerp(float start_value, float end_value, float pct) {
        return start_value + (end_value - start_value) * pct;
    }

    public static float flip(float x) {
        return 1.0f - x;
    }

    public static float easeIn(float t) {
        return t * t;
    }

    public static float easeOut(float t) {
        return Easing.flip(Easing.easeIn(Easing.flip(t)));
    }

    public static float easeInOut(float t) {
        return Easing.lerp(Easing.easeIn(t), Easing.easeOut(t), t);
    }

    public static float easeOutBounce(float x) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x < 0.36363637f) {
            return 7.5625f * x * x;
        }
        if (x < 0.72727275f) {
            return (float)((double)(7.5625f * (x -= 0.54545456f) * x) + 0.75);
        }
        if ((double)x < 0.9090909090909091) {
            return (float)((double)(7.5625f * (x -= 0.8181818f) * x) + 0.9375);
        }
        return (float)((double)(7.5625f * (x -= 0.95454544f) * x) + 0.984375);
    }

    public static float animate(Type type, float x) {
        switch (type) {
            case EASE_IN: {
                return Easing.easeIn(x);
            }
            case EASE_OUT: {
                return Easing.easeOut(x);
            }
            case EASE_IN_OUT: {
                return Easing.easeInOut(x);
            }
            case EASE_OUT_BOUNCE: {
                return Easing.easeOutBounce(x);
            }
            case LINEAR: {
                return x;
            }
        }
        return x;
    }

    public static enum Type {
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT,
        EASE_OUT_BOUNCE,
        LINEAR;

    }
}

