/*
 * Decompiled with CFR 0.152.
 */
package salted.packedup.data.models.builders;

import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import salted.packedup.common.block.CrateLidBlock;
import salted.packedup.common.block.HorizontalBlock;
import salted.packedup.common.block.HorizontalSlabBlock;
import salted.packedup.common.block.QuarterSlabBlock;
import salted.packedup.common.block.TurfBlock;
import salted.packedup.common.block.TurfLayerBlock;
import salted.packedup.common.registry.PUBlocks;
import salted.packedup.data.utils.NameUtils;

public class PUBlockBuilder
extends BlockStateProvider {
    private static final int DEFAULT_HORIZONTAL_OFFSET = 180;

    public PUBlockBuilder(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "packedup", existingFileHelper);
    }

    protected void registerStatesAndModels() {
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(NameUtils.blockLocation(NameUtils.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(NameUtils.blockLocation(path), this.models().existingFileHelper);
    }

    private String parent(String model) {
        return this.existingModel(model).getLocation().toString();
    }

    private int defaultRotation(Direction dir) {
        return ((int)dir.m_122435_() + 180) % 360;
    }

    public ConfiguredModel[] withRandomRotation(BlockModelBuilder model) {
        return ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false);
    }

    public void simpleBasket(Block block) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String parentModel = "cube_bottom_top";
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, parentModel)).texture("particle", NameUtils.blockLocation(name + "_top"))).texture("bottom", NameUtils.blockLocation("basket_bottom"))).texture("side", NameUtils.blockLocation(name + "_side"))).texture("top", NameUtils.blockLocation(name + "_top")));
    }

    public void simpleBarrel(Block block) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String parentModel = "cube_bottom_top";
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, parentModel)).texture("particle", NameUtils.blockLocation(name + "_top"))).texture("bottom", NameUtils.mcBlockLocation("barrel_bottom"))).texture("side", NameUtils.mcBlockLocation("barrel_side"))).texture("top", NameUtils.blockLocation(name + "_top")));
    }

    public BlockModelBuilder resourceBag(Block block, boolean alt) {
        String name = NameUtils.blockName(block);
        String resource = NameUtils.nameFromSplit(name, "_bag", true);
        if (alt) {
            return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.parent("template/bag_all"))).texture("top", NameUtils.blockLocation(name + "_top"));
        }
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.parent("template/resource_bag"))).texture("pile", NameUtils.blockLocation(resource + "_pile"));
    }

    public void simpleBag(Block block) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String parentModel = "template/bag";
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent(parentModel))).texture("top", NameUtils.blockLocation(name + "_top")));
    }

    public BlockModelBuilder crateLid(CrateLidBlock block, Half half) {
        String parentModel;
        String name = NameUtils.blockName(block);
        Object blockModel = NameUtils.blockLocation(name).toString();
        if (half.equals((Object)Half.TOP)) {
            parentModel = "template/crate_lid_top";
            blockModel = (String)blockModel + "_top";
        } else {
            parentModel = "template/crate_lid";
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent((String)blockModel, this.parent(parentModel))).texture("top", NameUtils.blockLocation(name + "_top"))).texture("side", NameUtils.blockLocation(name + "_side"))).texture("bottom", NameUtils.blockLocation(name + "_bottom"));
    }

    public void simpleCrateLid(CrateLidBlock block, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Half half = (Half)state.m_61143_((Property)BlockStateProperties.f_61402_);
            return ConfiguredModel.builder().modelFile((ModelFile)this.crateLid(block, half)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
        }, ignored);
    }

    public BlockModelBuilder resourceCrate(Block block, boolean alt) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String resource = NameUtils.nameFromSplit(name, "_crate", true);
        if (alt) {
            return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent("template/crate"))).texture("top", NameUtils.blockLocation(name + "_top"));
        }
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent("template/resource_crate"))).texture("pile", NameUtils.blockLocation(resource + "_pile"));
    }

    public BlockModelBuilder reinforcedCrate(Block block, boolean alt) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String resource = NameUtils.nameFromSplit(name, "_crate", true);
        resource = NameUtils.nameFromSplit(resource, "reinforced_", false);
        if (alt) {
            return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent("template/reinforced_crate"))).texture("top", NameUtils.blockLocation(name + "_top"));
        }
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent("template/reinforced_resource_crate"))).texture("pile", NameUtils.blockLocation(resource + "_pile"));
    }

    public BlockModelBuilder resourcePile(Block block) {
        String name = NameUtils.blockName(block);
        String resource = NameUtils.nameFromSplit(name, "_pile", true);
        String blockModel = NameUtils.blockLocation(name).toString();
        String parentModel = "template/pile";
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent(parentModel))).texture("top", NameUtils.blockLocation(resource + "_pallet_top"))).texture("front", NameUtils.blockLocation(name + "_front"))).texture("side", NameUtils.blockLocation(name + "_side"));
    }

    public BlockModelBuilder resourcePallet(Block block) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String parentModel = "template/resource_pallet";
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent(parentModel))).texture("top", NameUtils.blockLocation(name + "_top"))).texture("front", NameUtils.blockLocation(name + "_front"))).texture("side", NameUtils.blockLocation(name + "_side"));
    }

    public void simpleCrate(Block block) {
        String name = NameUtils.blockName(block);
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(NameUtils.blockName(block), NameUtils.blockLocation(name + "_side"), NameUtils.fdBlockLocation("crate_bottom"), NameUtils.blockLocation(name + "_top")));
    }

    public void mushroomCrate(Block block) {
        String name = NameUtils.blockName(block);
        String blockModel = NameUtils.blockLocation(name).toString();
        String parentModel = "template/mushroom_crate";
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent(parentModel))).texture("top", NameUtils.blockLocation(name + "_top"))).texture("side", NameUtils.blockLocation(name + "_side"))).texture("mush", NameUtils.blockLocation(name + "_mushrooms")));
    }

    public void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), ignored);
    }

    public void horizontalQuarterSlabBlock(QuarterSlabBlock block, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            IntegerProperty layersProperty = block.getQuarterLayers();
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            int layers = (Integer)state.m_61143_((Property)layersProperty);
            String suffix = "_layer" + (layers - 1);
            return ConfiguredModel.builder().modelFile(this.existingModel(NameUtils.blockName(block) + suffix)).rotationY(this.defaultRotation(dir)).build();
        }, ignored);
    }

    private BlockModelBuilder quarterSlabBlock(QuarterSlabBlock block, int layer, boolean bottomTop) {
        ResourceLocation topTexture;
        String name = NameUtils.nameFromSplit(NameUtils.blockName(block), "_layer", true);
        String suffix = "_layer" + layer;
        if (block instanceof TurfLayerBlock) {
            String parentBlock = NameUtils.nameFromSplit(name, "_turf", true);
            topTexture = NameUtils.mcBlockLocation(parentBlock + "_top");
        } else {
            topTexture = NameUtils.blockLocation(name + "_top");
        }
        ResourceLocation bottomTexture = bottomTop ? NameUtils.blockLocation(name + "_bottom") : topTexture;
        String parentModel = layer == 1 ? "block/slab" : this.parent("template/quarter_slab" + suffix);
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.blockLocation(name) + suffix, parentModel)).texture("top", topTexture)).texture("side", NameUtils.blockLocation(name + "_side"))).texture("bottom", bottomTexture);
    }

    public void simpleQuarterSlabBlock(QuarterSlabBlock block, boolean randomRotation, boolean bottomTop, Property<?> ... ignored) {
        String name = NameUtils.nameFromSplit(NameUtils.blockName(block), "_layer", true);
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            IntegerProperty layersProperty = block.getQuarterLayers();
            int layers = (Integer)state.m_61143_((Property)layersProperty);
            if (layers == 4) {
                if (randomRotation) {
                    return ConfiguredModel.allYRotations((ModelFile)this.existingModel(name), (int)0, (boolean)false);
                }
                return ConfiguredModel.builder().modelFile(this.existingModel(name)).build();
            }
            BlockModelBuilder model = this.quarterSlabBlock(block, layers - 1, bottomTop);
            if (randomRotation) {
                return ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, ignored);
    }

    private BlockModelBuilder bookPile(QuarterSlabBlock block, int layer, boolean isColored, boolean isAlt, int variant) {
        String name = NameUtils.blockName(block);
        String suffix = "_layer" + layer;
        Object prefix = "";
        if (!isColored) {
            if (isAlt) {
                prefix = "alt" + variant + "/";
            }
            String parentModel = "book/template/book_pile" + suffix;
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.bookLocation((String)prefix + name) + suffix, this.parent(parentModel))).texture("top", NameUtils.bookLocation((String)prefix + name + "_top" + suffix))).texture("front", NameUtils.bookLocation((String)prefix + name + "_front"))).texture("left", NameUtils.bookLocation((String)prefix + name + "_left"))).texture("right", NameUtils.bookLocation((String)prefix + name + "_right"))).texture("back", NameUtils.bookLocation((String)prefix + name + "_back"))).texture("bottom", NameUtils.bookLocation((String)prefix + name + "_bottom"));
        }
        String parentModel = "book/template/colored_book_pile" + suffix;
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.bookLocation(name) + suffix, this.parent(parentModel))).texture("top", NameUtils.bookLocation(name + "_top"))).texture("front", NameUtils.bookLocation(name + "_front"))).texture("left", NameUtils.bookLocation(name + "_left"))).texture("right", NameUtils.bookLocation(name + "_right"))).texture("bottom", NameUtils.bookLocation(name + "_bottom"));
    }

    public void simpleColoredBookPile(QuarterSlabBlock block, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            IntegerProperty layersProperty = block.getQuarterLayers();
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            int layers = (Integer)state.m_61143_((Property)layersProperty);
            return ConfiguredModel.builder().modelFile((ModelFile)this.bookPile(block, layers - 1, true, false, 0)).rotationY(this.defaultRotation(dir)).build();
        }, ignored);
    }

    public void simpleBookPile(QuarterSlabBlock block, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            IntegerProperty layersProperty = block.getQuarterLayers();
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            int layers = (Integer)state.m_61143_((Property)layersProperty);
            int rotation = this.defaultRotation(dir);
            return ConfiguredModel.builder().modelFile((ModelFile)this.bookPile(block, layers - 1, false, false, 0)).rotationY(rotation).weight(30).nextModel().modelFile((ModelFile)this.bookPile(block, layers - 1, false, true, 1)).rotationY(rotation).weight(25).nextModel().modelFile((ModelFile)this.bookPile(block, layers - 1, false, true, 2)).rotationY(rotation).weight(25).nextModel().modelFile((ModelFile)this.bookPile(block, layers - 1, false, true, 3)).rotationY(rotation).weight(5).nextModel().modelFile((ModelFile)this.bookPile(block, layers - 1, false, true, 4)).rotationY(rotation).weight(5).nextModel().modelFile((ModelFile)this.bookPile(block, layers - 1, false, true, 5)).rotationY(rotation).weight(5).build();
        }, ignored);
    }

    private BlockModelBuilder bookBundle(HorizontalBlock block, boolean isColored, boolean isAlt, int variant) {
        String temp = NameUtils.blockName(block);
        String name = NameUtils.nameFromSplit(temp, "_bundle", true) + "_pile";
        Object prefix = "";
        if (!isColored) {
            if (isAlt) {
                prefix = "alt" + variant + "/";
            }
            String parentModel = "book/template/book_bundle";
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.bookLocation((String)prefix + NameUtils.blockName(block)).toString(), this.parent(parentModel))).texture("top", NameUtils.bookLocation((String)prefix + name + "_top_layer3"))).texture("front", NameUtils.bookLocation((String)prefix + name + "_front"))).texture("left", NameUtils.bookLocation((String)prefix + name + "_left"))).texture("right", NameUtils.bookLocation((String)prefix + name + "_right"))).texture("back", NameUtils.bookLocation((String)prefix + name + "_back"))).texture("bottom", NameUtils.bookLocation((String)prefix + name + "_bottom"));
        }
        String parentModel = "book/template/colored_book_bundle";
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.bookLocation((String)prefix + NameUtils.blockName(block)).toString(), this.parent(parentModel))).texture("top", NameUtils.bookLocation(name + "_top"))).texture("front", NameUtils.bookLocation(name + "_front"))).texture("left", NameUtils.bookLocation(name + "_left"))).texture("right", NameUtils.bookLocation(name + "_right"))).texture("bottom", NameUtils.bookLocation(name + "_bottom"));
    }

    public void simpleColoredBookBundle(HorizontalBlock block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            return ConfiguredModel.builder().modelFile((ModelFile)this.bookBundle(block, true, false, 0)).rotationY(this.defaultRotation(dir)).build();
        });
    }

    public void simpleBookBundle(HorizontalBlock block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            int rotation = this.defaultRotation(dir);
            return ConfiguredModel.builder().modelFile((ModelFile)this.bookBundle(block, false, false, 0)).rotationY(rotation).weight(30).nextModel().modelFile((ModelFile)this.bookBundle(block, false, true, 1)).rotationY(rotation).weight(25).nextModel().modelFile((ModelFile)this.bookBundle(block, false, true, 2)).rotationY(rotation).weight(25).nextModel().modelFile((ModelFile)this.bookBundle(block, false, true, 3)).rotationY(rotation).weight(5).nextModel().modelFile((ModelFile)this.bookBundle(block, false, true, 4)).rotationY(rotation).weight(5).nextModel().modelFile((ModelFile)this.bookBundle(block, false, true, 5)).rotationY(rotation).weight(5).build();
        });
    }

    private BlockModelBuilder bookBundleSlab(HorizontalSlabBlock block, SlabType type, boolean isColored, boolean isAlt, int variant) {
        String temp = NameUtils.blockName((Block)block);
        String name = NameUtils.nameFromSplit(temp, "_bundle", true) + "_pile";
        String slabType = "";
        String layer = "_layer1";
        Object prefix = "";
        String suffix = "";
        if (type == SlabType.TOP) {
            slabType = "_top";
            layer = "_layer3";
            suffix = "_slab_top";
        }
        if (type == SlabType.DOUBLE) {
            slabType = "_double";
            layer = "_layer3";
        }
        if (!isColored) {
            if (isAlt) {
                prefix = "alt" + variant + "/";
            }
            String parentModel = "book/template/book_bundle_slab" + slabType;
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.bookLocation((String)prefix + NameUtils.blockName((Block)block)) + slabType, this.parent(parentModel))).texture("top", NameUtils.bookLocation((String)prefix + name + "_top" + layer))).texture("front", NameUtils.bookLocation((String)prefix + name + "_front"))).texture("left", NameUtils.bookLocation((String)prefix + name + "_left"))).texture("right", NameUtils.bookLocation((String)prefix + name + "_right"))).texture("back", NameUtils.bookLocation((String)prefix + name + "_back"))).texture("bottom", NameUtils.bookLocation((String)prefix + name + "_bottom" + suffix));
        }
        String parentModel = "book/template/colored_book_bundle_slab" + slabType;
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(NameUtils.bookLocation(NameUtils.blockName((Block)block)) + slabType, this.parent(parentModel))).texture("top", NameUtils.bookLocation(name + "_top"))).texture("front", NameUtils.bookLocation(name + "_front"))).texture("left", NameUtils.bookLocation(name + "_left"))).texture("right", NameUtils.bookLocation(name + "_right"))).texture("bottom", NameUtils.bookLocation(name + "_bottom"));
    }

    public void simpleColoredBookBundleSlab(HorizontalSlabBlock block, Property<?> ... ignored) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
            return ConfiguredModel.builder().modelFile((ModelFile)this.bookBundleSlab(block, type, true, false, 0)).rotationY(this.defaultRotation(dir)).build();
        }, ignored);
    }

    public void simpleBookBundleSlab(HorizontalSlabBlock block, Property<?> ... ignored) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
            int rotation = this.defaultRotation(dir);
            return ConfiguredModel.builder().modelFile((ModelFile)this.bookBundleSlab(block, type, false, false, 0)).rotationY(rotation).weight(30).nextModel().modelFile((ModelFile)this.bookBundleSlab(block, type, false, true, 1)).rotationY(rotation).weight(25).nextModel().modelFile((ModelFile)this.bookBundleSlab(block, type, false, true, 2)).rotationY(rotation).weight(25).nextModel().modelFile((ModelFile)this.bookBundleSlab(block, type, false, true, 3)).rotationY(rotation).weight(5).nextModel().modelFile((ModelFile)this.bookBundleSlab(block, type, false, true, 4)).rotationY(rotation).weight(5).nextModel().modelFile((ModelFile)this.bookBundleSlab(block, type, false, true, 5)).rotationY(rotation).weight(5).build();
        }, ignored);
    }

    private BlockModelBuilder turfBlock(QuarterSlabBlock block, int layer, boolean tint) {
        String name = NameUtils.nameFromSplit(NameUtils.blockName(block), "_layer", true);
        String topName = NameUtils.nameFromSplit(name, "_turf", true);
        String suffix = "_layer" + layer;
        String blockModel = NameUtils.blockLocation(name) + suffix;
        Object parentModel = layer == 1 ? (tint ? "template/tinted_overlay_slab" : "template/overlay_slab") : (tint ? "template/tinted_turf" + suffix : "template/turf" + suffix);
        ResourceLocation topTexture = block.m_49966_().m_60713_((Block)PUBlocks.GRASS_TURF_LAYER.get()) ? NameUtils.mcBlockLocation(topName + "_block_top") : NameUtils.mcBlockLocation(topName + "_top");
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent((String)parentModel))).texture("top", topTexture)).texture("side", NameUtils.blockLocation(name + "_side"))).texture("overlay", NameUtils.blockLocation(name + "_overlay"));
    }

    public void simpleTurfBlock(QuarterSlabBlock block, boolean tint, Property<?> ... ignored) {
        String parentBlock = NameUtils.nameFromSplit(NameUtils.blockName(block), "_layer", true);
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            IntegerProperty layersProperty = block.getQuarterLayers();
            int layers = (Integer)state.m_61143_((Property)layersProperty);
            if (layers == 4) {
                return ConfiguredModel.allYRotations((ModelFile)this.existingModel(parentBlock), (int)0, (boolean)false);
            }
            return ConfiguredModel.allYRotations((ModelFile)this.turfBlock(block, layers - 1, tint), (int)0, (boolean)false);
        }, ignored);
    }

    public void grassBaleBlock(RotatedPillarBlock block) {
        String name = NameUtils.blockName((Block)block);
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            Direction.Axis dir = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            if (dir == Direction.Axis.X) {
                return ConfiguredModel.builder().modelFile(this.existingModel(name + "_horizontal")).rotationY(90).build();
            }
            if (dir == Direction.Axis.Y) {
                return ConfiguredModel.builder().modelFile(this.existingModel(name)).build();
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(name + "_horizontal")).build();
        });
    }

    public BlockModelBuilder simpleOverlayBlock(Block block, boolean tint) {
        ResourceLocation topTexture;
        String name = NameUtils.blockName(block);
        String parentModel = tint ? "template/tinted_overlay_block" : "template/overlay_block";
        String blockModel = NameUtils.blockLocation(name).toString();
        if (block instanceof TurfBlock) {
            String parentBlock = NameUtils.nameFromSplit(name, "_turf", true);
            topTexture = block.m_49966_().m_60713_((Block)PUBlocks.GRASS_TURF.get()) ? NameUtils.mcBlockLocation(parentBlock + "_block_top") : NameUtils.mcBlockLocation(parentBlock + "_top");
        } else {
            topTexture = NameUtils.blockLocation(name + "_top");
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockModel, this.parent(parentModel))).texture("top", topTexture)).texture("side", NameUtils.blockLocation(name + "_side"))).texture("overlay", NameUtils.blockLocation(name + "_overlay"));
    }

    private BlockModelBuilder overlayStairBlock(StairBlock block, StairsShape shape, Half half) {
        Object parentModel;
        String name = NameUtils.blockName((Block)block);
        String parentBlock = NameUtils.nameFromSplit(name, "_stairs", true);
        Object blockModel = NameUtils.blockLocation(name).toString();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            parentModel = "template/overlay_inner_stairs";
            blockModel = (String)blockModel + "_inner";
        } else if (shape == StairsShape.OUTER_LEFT || shape == StairsShape.OUTER_RIGHT) {
            parentModel = "template/overlay_outer_stairs";
            blockModel = (String)blockModel + "_outer";
        } else {
            parentModel = "template/overlay_stairs";
        }
        if (half == Half.TOP) {
            parentModel = (String)parentModel + "_top";
            blockModel = (String)blockModel + "_top";
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent((String)blockModel, this.parent((String)parentModel))).texture("top", NameUtils.blockLocation(parentBlock + "_top"))).texture("side", NameUtils.blockLocation(parentBlock + "_side"))).texture("overlay", NameUtils.blockLocation(parentBlock + "_overlay"));
    }

    public void simpleOverlayStairsBlock(StairBlock block) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile((ModelFile)this.overlayStairBlock(block, shape, half)).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private BlockModelBuilder overlaySlabBlock(SlabBlock block, SlabType type) {
        String name = NameUtils.blockName((Block)block);
        String parentBlock = NameUtils.nameFromSplit(name, "_slab", true);
        Object parentModel = "template/overlay_slab";
        Object blockModel = NameUtils.blockLocation(name).toString();
        if (type == SlabType.TOP) {
            parentModel = (String)parentModel + "_top";
            blockModel = (String)blockModel + "_top";
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent((String)blockModel, this.parent((String)parentModel))).texture("top", NameUtils.blockLocation(parentBlock + "_top"))).texture("side", NameUtils.blockLocation(parentBlock + "_side"))).texture("overlay", NameUtils.blockLocation(parentBlock + "_overlay"));
    }

    public void simpleOverlaySlabBlock(SlabBlock block) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            String name = NameUtils.blockName((Block)block);
            String parentBlock = NameUtils.nameFromSplit(name, "_slab", true);
            SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
            if (type == SlabType.DOUBLE) {
                return ConfiguredModel.builder().modelFile(this.existingModel(parentBlock)).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.overlaySlabBlock(block, type)).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }
}

